/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.client.sound.IHasSound;
import mekanism.common.IActiveState;
import mekanism.common.IEjector;
import mekanism.common.IInvConfiguration;
import mekanism.common.IRedstoneControl;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.SideData;
import mekanism.common.block.BlockMachine;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityChemicalCrystalizer
extends TileEntityElectricBlock
implements IActiveState,
IGasHandler,
ITubeConnection,
IRedstoneControl,
IHasSound,
IInvConfiguration {
    public static final int MAX_GAS = 10000;
    public static final int MAX_FLUID = 10000;
    public byte[] sideConfig = new byte[]{0, 3, 0, 0, 1, 2};
    public ArrayList<SideData> sideOutputs = new ArrayList();
    public GasTank inputTank = new GasTank(10000);
    public static int WATER_USAGE = 5;
    public int updateDelay;
    public int gasOutput = 16;
    public int operatingTicks;
    public int TICKS_REQUIRED = 200;
    public boolean isActive;
    public boolean clientActive;
    public double prevEnergy;
    public float spinSpeed;
    public float spin;
    public final double ENERGY_USAGE = Mekanism.chemicalCrystalizerUsage;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentEjector ejectorComponent;

    public TileEntityChemicalCrystalizer() {
        super("ChemicalCrystalizer", BlockMachine.MachineType.CHEMICAL_CRYSTALIZER.baseEnergy);
        this.sideOutputs.add(new SideData(EnumColor.GREY, InventoryUtils.EMPTY));
        this.sideOutputs.add(new SideData(EnumColor.PURPLE, new int[]{0}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_BLUE, new int[]{1}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_GREEN, new int[]{2}));
        this.inventory = new ItemStack[3];
        this.ejectorComponent = new TileComponentEjector(this, this.sideOutputs.get(1));
    }

    @Override
    public void onUpdate() {
        if (this.field_70331_k.field_72995_K) {
            Mekanism.proxy.registerSound(this);
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    this.isActive = this.clientActive;
                    MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
                }
            }
        }
        if (!this.field_70331_k.field_72995_K) {
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
                }
            }
            ChargeUtils.discharge(2, this);
            if (this.inventory[0] != null && (this.inputTank.getGas() == null || this.inputTank.getStored() < this.inputTank.getMaxGas())) {
                this.inputTank.receive(GasTransmission.removeGas(this.inventory[0], null, this.inputTank.getNeeded()), true);
            }
            if (this.canOperate() && MekanismUtils.canFunction(this) && this.getEnergy() >= this.ENERGY_USAGE) {
                this.setActive(true);
                if (this.operatingTicks + 1 < this.TICKS_REQUIRED) {
                    ++this.operatingTicks;
                    this.setEnergy(this.getEnergy() - this.ENERGY_USAGE);
                } else if (this.operatingTicks + 1 >= this.TICKS_REQUIRED) {
                    this.operate();
                    this.operatingTicks = 0;
                    this.setEnergy(this.getEnergy() - this.ENERGY_USAGE);
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (!this.canOperate()) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    public boolean canOperate() {
        if (this.inputTank.getGas() == null) {
            return false;
        }
        ItemStack itemstack = RecipeHandler.getChemicalCrystalizerOutput(this.inputTank, false);
        if (itemstack == null) {
            return false;
        }
        if (this.inventory[1] == null) {
            return true;
        }
        if (!this.inventory[1].func_77969_a(itemstack)) {
            return false;
        }
        return this.inventory[1].field_77994_a + itemstack.field_77994_a <= this.inventory[1].func_77976_d();
    }

    public void operate() {
        ItemStack itemstack = RecipeHandler.getChemicalCrystalizerOutput(this.inputTank, true);
        if (this.inventory[1] == null) {
            this.inventory[1] = itemstack;
        } else {
            this.inventory[1].field_77994_a += itemstack.field_77994_a;
        }
        this.func_70296_d();
        this.ejectorComponent.onOutput();
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        if (!this.field_70331_k.field_72995_K) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.inputTank.setGas(null);
            }
            for (EntityPlayer player : this.playersUsing) {
                PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), player);
            }
            return;
        }
        super.handlePacketData(dataStream);
        this.isActive = dataStream.readBoolean();
        this.operatingTicks = dataStream.readInt();
        for (int i = 0; i < 6; ++i) {
            this.sideConfig[i] = dataStream.readByte();
        }
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        if (dataStream.readBoolean()) {
            this.inputTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
        } else {
            this.inputTank.setGas(null);
        }
        MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.operatingTicks);
        data.add(this.sideConfig);
        data.add(this.controlType.ordinal());
        if (this.inputTank.getGas() != null) {
            data.add(true);
            data.add(this.inputTank.getGas().getGas().getID());
            data.add(this.inputTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.inputTank.read(nbtTags.func_74775_l("rightTank"));
        if (nbtTags.func_74764_b("sideDataStored")) {
            for (int i = 0; i < 6; ++i) {
                this.sideConfig[i] = nbtTags.func_74771_c("config" + i);
            }
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74766_a("rightTank", this.inputTank.write(new NBTTagCompound()));
        nbtTags.func_74757_a("sideDataStored", true);
        for (int i = 0; i < 6; ++i) {
            nbtTags.func_74774_a("config" + i, this.sideConfig[i]);
        }
    }

    @Override
    public boolean canSetFacing(int i) {
        return i != 0 && i != 1;
    }

    public int getScaledInputGasLevel(int i) {
        return this.inputTank != null ? this.inputTank.getStored() * i / 10000 : 0;
    }

    public int getScaledProgress(int i) {
        return this.operatingTicks * i / this.TICKS_REQUIRED;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return side == MekanismUtils.getLeft(this.facing);
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return side == MekanismUtils.getLeft(this.facing) && this.inputTank.canReceive(type);
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.inputTank.receive(stack, true);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        return null;
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack) != null && FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack).getFluid() == FluidRegistry.WATER;
        }
        if (slotID == 2) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 0) {
            return itemstack != null && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).canProvideGas(itemstack, null);
        }
        if (slotID == 1) {
            return true;
        }
        if (slotID == 2) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == MekanismUtils.getLeft(this.facing).ordinal()) {
            return new int[]{0};
        }
        if (side == MekanismUtils.getRight(this.facing).ordinal()) {
            return new int[]{1};
        }
        if (side == 0 || side == 1) {
            return new int[2];
        }
        return InventoryUtils.EMPTY;
    }

    @Override
    public String getSoundPath() {
        return "ChemicalCrystalizer.ogg";
    }

    @Override
    public float getVolumeMultiplier() {
        return 1.0f;
    }

    @Override
    public ArrayList<SideData> getSideData() {
        return this.sideOutputs;
    }

    @Override
    public byte[] getConfiguration() {
        return this.sideConfig;
    }

    @Override
    public int getOrientation() {
        return this.facing;
    }

    @Override
    public IEjector getEjector() {
        return this.ejectorComponent;
    }
}

