/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.client.sound.IHasSound;
import mekanism.common.IActiveState;
import mekanism.common.IRedstoneControl;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.block.BlockMachine;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityChemicalInfuser
extends TileEntityElectricBlock
implements IActiveState,
IGasHandler,
ITubeConnection,
IRedstoneControl,
IHasSound {
    public GasTank leftTank = new GasTank(10000);
    public GasTank rightTank = new GasTank(10000);
    public GasTank centerTank = new GasTank(10000);
    public static final int MAX_GAS = 10000;
    public int updateDelay;
    public int gasOutput = 16;
    public boolean isActive;
    public boolean clientActive;
    public double prevEnergy;
    public final double ENERGY_USAGE = Mekanism.chemicalInfuserUsage;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;

    public TileEntityChemicalInfuser() {
        super("ChemicalInfuser", BlockMachine.MachineType.CHEMICAL_INFUSER.baseEnergy);
        this.inventory = new ItemStack[4];
    }

    @Override
    public void onUpdate() {
        if (this.field_70331_k.field_72995_K) {
            Mekanism.proxy.registerSound(this);
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    this.isActive = this.clientActive;
                    MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
                }
            }
        }
        if (!this.field_70331_k.field_72995_K) {
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
                }
            }
            ChargeUtils.discharge(3, this);
            if (this.inventory[0] != null && (this.leftTank.getGas() == null || this.leftTank.getStored() < this.leftTank.getMaxGas())) {
                this.leftTank.receive(GasTransmission.removeGas(this.inventory[0], null, this.leftTank.getNeeded()), true);
            }
            if (this.inventory[1] != null && (this.rightTank.getGas() == null || this.rightTank.getStored() < this.rightTank.getMaxGas())) {
                this.rightTank.receive(GasTransmission.removeGas(this.inventory[1], null, this.rightTank.getNeeded()), true);
            }
            if (this.inventory[2] != null && this.centerTank.getGas() != null) {
                this.centerTank.draw(GasTransmission.addGas(this.inventory[2], this.centerTank.getGas()), true);
            }
            if (this.canOperate() && this.getEnergy() >= this.ENERGY_USAGE && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                GasStack stack = RecipeHandler.getChemicalInfuserOutput(this.leftTank, this.rightTank, true);
                this.centerTank.receive(stack, true);
                this.setEnergy(this.getEnergy() - this.ENERGY_USAGE);
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (this.centerTank.getGas() != null) {
                GasStack toSend = new GasStack(this.centerTank.getGas().getGas(), Math.min(this.centerTank.getStored(), this.gasOutput));
                this.centerTank.draw(GasTransmission.emitGasToNetwork(toSend, this, ForgeDirection.getOrientation((int)this.facing)), true);
                TileEntity tileEntity = Coord4D.get(this).getFromSide(ForgeDirection.getOrientation((int)this.facing)).getTileEntity((IBlockAccess)this.field_70331_k);
                if (tileEntity instanceof IGasHandler && ((IGasHandler)tileEntity).canReceiveGas(ForgeDirection.getOrientation((int)this.facing).getOpposite(), this.centerTank.getGas().getGas())) {
                    this.centerTank.draw(((IGasHandler)tileEntity).receiveGas(ForgeDirection.getOrientation((int)this.facing).getOpposite(), toSend), true);
                }
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    public boolean canOperate() {
        if (this.leftTank.getGas() == null || this.rightTank.getGas() == null || this.centerTank.getNeeded() == 0) {
            return false;
        }
        GasStack out = RecipeHandler.getChemicalInfuserOutput(this.leftTank, this.rightTank, false);
        if (out == null || this.centerTank.getGas() != null && this.centerTank.getGas().getGas() != out.getGas()) {
            return false;
        }
        return this.centerTank.getNeeded() >= out.amount;
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        if (!this.field_70331_k.field_72995_K) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.leftTank.setGas(null);
            } else if (type == 1) {
                this.rightTank.setGas(null);
            }
            for (EntityPlayer player : this.playersUsing) {
                PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), player);
            }
            return;
        }
        super.handlePacketData(dataStream);
        this.isActive = dataStream.readBoolean();
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        if (dataStream.readBoolean()) {
            this.leftTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
        } else {
            this.leftTank.setGas(null);
        }
        if (dataStream.readBoolean()) {
            this.rightTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
        } else {
            this.rightTank.setGas(null);
        }
        if (dataStream.readBoolean()) {
            this.centerTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
        } else {
            this.centerTank.setGas(null);
        }
        MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        if (this.leftTank.getGas() != null) {
            data.add(true);
            data.add(this.leftTank.getGas().getGas().getID());
            data.add(this.leftTank.getStored());
        } else {
            data.add(false);
        }
        if (this.rightTank.getGas() != null) {
            data.add(true);
            data.add(this.rightTank.getGas().getGas().getID());
            data.add(this.rightTank.getStored());
        } else {
            data.add(false);
        }
        if (this.centerTank.getGas() != null) {
            data.add(true);
            data.add(this.centerTank.getGas().getGas().getID());
            data.add(this.centerTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.leftTank.read(nbtTags.func_74775_l("leftTank"));
        this.rightTank.read(nbtTags.func_74775_l("rightTank"));
        this.centerTank.read(nbtTags.func_74775_l("centerTank"));
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74766_a("leftTank", this.leftTank.write(new NBTTagCompound()));
        nbtTags.func_74766_a("rightTank", this.rightTank.write(new NBTTagCompound()));
        nbtTags.func_74766_a("centerTank", this.centerTank.write(new NBTTagCompound()));
    }

    @Override
    public boolean canSetFacing(int i) {
        return i != 0 && i != 1;
    }

    public GasTank getTank(ForgeDirection side) {
        if (side == MekanismUtils.getLeft(this.facing)) {
            return this.leftTank;
        }
        if (side == MekanismUtils.getRight(this.facing)) {
            return this.rightTank;
        }
        if (side == ForgeDirection.getOrientation((int)this.facing)) {
            return this.centerTank;
        }
        return null;
    }

    public int getScaledLeftGasLevel(int i) {
        return this.leftTank != null ? this.leftTank.getStored() * i / 10000 : 0;
    }

    public int getScaledRightGasLevel(int i) {
        return this.rightTank != null ? this.rightTank.getStored() * i / 10000 : 0;
    }

    public int getScaledCenterGasLevel(int i) {
        return this.centerTank != null ? this.centerTank.getStored() * i / 10000 : 0;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return side == MekanismUtils.getLeft(this.facing) || side == MekanismUtils.getRight(this.facing) || side == ForgeDirection.getOrientation((int)this.facing);
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return this.getTank(side) != null && this.getTank(side) != this.centerTank ? this.getTank(side).canReceive(type) : false;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        if (this.canReceiveGas(side, stack != null ? stack.getGas() : null)) {
            return this.getTank(side).receive(stack, true);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        if (this.canDrawGas(side, null)) {
            return this.getTank(side).draw(amount, true);
        }
        return null;
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return this.getTank(side) != null && this.getTank(side) == this.centerTank ? this.getTank(side).canDraw(type) : false;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 3) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 0 || slotID == 2) {
            return itemstack != null && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).canReceiveGas(itemstack, null);
        }
        if (slotID == 1) {
            return itemstack != null && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).canProvideGas(itemstack, null);
        }
        if (slotID == 3) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == MekanismUtils.getLeft(this.facing).ordinal()) {
            return new int[]{0};
        }
        if (side == this.facing) {
            return new int[]{1};
        }
        if (side == MekanismUtils.getRight(this.facing).ordinal()) {
            return new int[]{2};
        }
        if (side == 0 || side == 1) {
            return new int[3];
        }
        return InventoryUtils.EMPTY;
    }

    @Override
    public String getSoundPath() {
        return "ChemicalInfuser.ogg";
    }

    @Override
    public float getVolumeMultiplier() {
        return 1.0f;
    }
}

