/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.ILuaContext;
import dan200.computer.api.IPeripheral;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.common.HashList;
import mekanism.common.IActiveState;
import mekanism.common.IAdvancedBoundingBlock;
import mekanism.common.ILogisticalTransporter;
import mekanism.common.IRedstoneControl;
import mekanism.common.IUpgradeTile;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.block.BlockMachine;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.miner.MItemStackFilter;
import mekanism.common.miner.MOreDictFilter;
import mekanism.common.miner.MinerFilter;
import mekanism.common.miner.ThreadMinerSearch;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.transporter.InvStack;
import mekanism.common.transporter.TransporterManager;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MinerUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityDigitalMiner
extends TileEntityElectricBlock
implements IPeripheral,
IUpgradeTile,
IRedstoneControl,
IActiveState,
IAdvancedBoundingBlock {
    public static int[] EJECT_INV;
    public BitSet oresToMine = new BitSet();
    public HashList<MinerFilter> filters = new HashList();
    public ThreadMinerSearch searcher = new ThreadMinerSearch(this);
    public final double ENERGY_USAGE = Mekanism.digitalMinerUsage;
    public int radius;
    public boolean inverse;
    public int minY = 0;
    public int maxY = 60;
    public boolean doEject = false;
    public boolean doPull = false;
    public int delay;
    public int clientToMine;
    public ItemStack replaceStack;
    public boolean isActive;
    public boolean clientActive;
    public boolean silkTouch;
    public boolean running;
    public double prevEnergy;
    public int delayTicks;
    public boolean initCalc = false;
    public int numPowering;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentUpgrade upgradeComponent = new TileComponentUpgrade(this, 28);
    public String[] names = new String[]{"setRadius", "setMin", "setMax", "setReplace", "addFilter", "removeFilter", "addOreFilter", "removeOreFilter", "reset", "start", "stop"};

    public TileEntityDigitalMiner() {
        super("DigitalMiner", BlockMachine.MachineType.DIGITAL_MINER.baseEnergy);
        this.inventory = new ItemStack[29];
        this.radius = 10;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.getActive()) {
            for (EntityPlayer player : this.playersUsing) {
                if (!(player.field_71070_bA instanceof ContainerNull) && !(player.field_71070_bA instanceof ContainerFilter)) continue;
                player.func_71053_j();
            }
        }
        if (!this.field_70331_k.field_72995_K) {
            if (!this.initCalc) {
                if (this.searcher.state == ThreadMinerSearch.State.FINISHED) {
                    this.reset();
                    this.start();
                }
                this.initCalc = true;
            }
            ChargeUtils.discharge(27, this);
            if (MekanismUtils.canFunction(this) && this.running && this.getEnergy() >= this.getPerTick() && this.searcher.state == ThreadMinerSearch.State.FINISHED && this.oresToMine.cardinality() > 0) {
                this.setActive(true);
                if (this.delay > 0) {
                    --this.delay;
                }
                this.setEnergy(this.getEnergy() - this.getPerTick());
                if (this.delay == 0) {
                    HashSet<Integer> toRemove;
                    block25: {
                        int meta;
                        int id;
                        Coord4D coord;
                        int index;
                        toRemove = new HashSet<Integer>();
                        int next = 0;
                        while (true) {
                            index = this.oresToMine.nextSetBit(next);
                            coord = this.getCoordFromIndex(index);
                            if (index == -1) break block25;
                            if (!coord.exists(this.field_70331_k)) {
                                toRemove.add(index);
                                next = index + 1;
                                continue;
                            }
                            id = coord.getBlockId((IBlockAccess)this.field_70331_k);
                            meta = coord.getMetadata((IBlockAccess)this.field_70331_k);
                            if (id == 0) {
                                toRemove.add(index);
                                next = index + 1;
                                continue;
                            }
                            boolean hasFilter = false;
                            for (MinerFilter filter : this.filters) {
                                if (!filter.canFilter(new ItemStack(id, 1, meta))) continue;
                                hasFilter = true;
                                break;
                            }
                            if (!(this.inverse ? hasFilter : !hasFilter)) break;
                            toRemove.add(index);
                            next = index + 1;
                        }
                        List<ItemStack> drops = MinerUtils.getDrops(this.field_70331_k, coord, this.silkTouch);
                        if (this.canInsert(drops)) {
                            this.add(drops);
                            this.setReplace(coord);
                            toRemove.add(index);
                            this.field_70331_k.func_72889_a(null, 2001, coord.xCoord, coord.yCoord, coord.zCoord, id + (meta << 12));
                            this.delay = this.getDelay();
                        }
                    }
                    for (Integer i : toRemove) {
                        this.oresToMine.clear(i);
                    }
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (this.doEject && this.delayTicks == 0 && this.getTopEject(false, null) != null && this.getEjectInv() != null) {
                if (this.getEjectInv() instanceof IInventory) {
                    ItemStack remains = InventoryUtils.putStackInInventory((IInventory)this.getEjectInv(), this.getTopEject(false, null), ForgeDirection.getOrientation((int)this.facing).getOpposite().ordinal(), false);
                    this.getTopEject(true, remains);
                } else if (this.getEjectInv() instanceof ILogisticalTransporter) {
                    ItemStack rejected = TransporterUtils.insert(this.getEjectTile(), (ILogisticalTransporter)this.getEjectInv(), this.getTopEject(false, null), null, true, 0);
                    if (TransporterManager.didEmit(this.getTopEject(false, null), rejected)) {
                        this.getTopEject(true, rejected);
                    }
                }
                this.delayTicks = 10;
            } else if (this.delayTicks > 0) {
                --this.delayTicks;
            }
            if (this.playersUsing.size() > 0) {
                for (EntityPlayer player : this.playersUsing) {
                    PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketTileEntity().setParams(Coord4D.get(this), this.getSmallPacket(new ArrayList())), player);
                }
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    public double getPerTick() {
        double ret = MekanismUtils.getEnergyPerTick(this.getSpeedMultiplier(new Object[0]), this.getEnergyMultiplier(new Object[0]), this.ENERGY_USAGE);
        if (this.silkTouch) {
            ret *= 6.0;
        }
        int baseRad = Math.max(this.radius - 10, 0);
        ret *= (double)(1.0f + (float)baseRad / 22.0f);
        int baseHeight = Math.max(this.maxY - this.minY - 60, 0);
        return ret *= (double)(1.0f + (float)baseHeight / 195.0f);
    }

    public int getDelay() {
        return MekanismUtils.getTicks(this.getSpeedMultiplier(new Object[0]), 80);
    }

    public void setReplace(Coord4D obj) {
        ItemStack stack = this.getReplace();
        if (stack != null) {
            this.field_70331_k.func_72832_d(obj.xCoord, obj.yCoord, obj.zCoord, this.replaceStack.field_77993_c, this.replaceStack.func_77960_j(), 3);
            if (Block.field_71973_m[obj.getBlockId((IBlockAccess)this.field_70331_k)] != null && !Block.field_71973_m[obj.getBlockId((IBlockAccess)this.field_70331_k)].func_71854_d(this.field_70331_k, obj.xCoord, obj.yCoord, obj.zCoord)) {
                Block.field_71973_m[obj.getBlockId((IBlockAccess)this.field_70331_k)].func_71897_c(this.field_70331_k, obj.xCoord, obj.yCoord, obj.zCoord, obj.getMetadata((IBlockAccess)this.field_70331_k), 1);
                this.field_70331_k.func_94571_i(obj.xCoord, obj.yCoord, obj.zCoord);
            }
        } else {
            this.field_70331_k.func_94571_i(obj.xCoord, obj.yCoord, obj.zCoord);
        }
    }

    public ItemStack getReplace() {
        InvStack stack;
        if (this.replaceStack == null) {
            return null;
        }
        for (int i = 0; i < 27; ++i) {
            if (this.inventory[i] == null || !this.inventory[i].func_77969_a(this.replaceStack)) continue;
            --this.inventory[i].field_77994_a;
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            return MekanismUtils.size(this.replaceStack, 1);
        }
        if (this.doPull && this.getPullInv() instanceof IInventory && (stack = InventoryUtils.takeDefinedItem((IInventory)this.getPullInv(), 1, this.replaceStack.func_77946_l(), 1, 1)) != null) {
            stack.use();
            return MekanismUtils.size(this.replaceStack, 1);
        }
        return null;
    }

    public ItemStack[] copy(ItemStack[] stacks) {
        ItemStack[] toReturn = new ItemStack[stacks.length];
        for (int i = 0; i < stacks.length; ++i) {
            toReturn[i] = stacks[i] != null ? stacks[i].func_77946_l() : null;
        }
        return toReturn;
    }

    public ItemStack getTopEject(boolean remove, ItemStack reject) {
        for (int i = 26; i >= 0; --i) {
            ItemStack stack = this.inventory[i];
            if (stack == null || this.replaceStack != null && this.replaceStack.func_77969_a(stack)) continue;
            if (remove) {
                this.inventory[i] = reject;
            }
            return stack;
        }
        return null;
    }

    public boolean canInsert(List<ItemStack> stacks) {
        if (stacks.isEmpty()) {
            return true;
        }
        ItemStack[] testInv = this.copy(this.inventory);
        int added = 0;
        block0: for (ItemStack stack : stacks) {
            for (int i = 0; i < 27; ++i) {
                if (testInv[i] == null) {
                    testInv[i] = stack;
                    ++added;
                    continue block0;
                }
                if (!testInv[i].func_77969_a(stack) || testInv[i].field_77994_a + stack.field_77994_a > stack.func_77976_d()) continue;
                testInv[i].field_77994_a += stack.field_77994_a;
                ++added;
                continue block0;
            }
        }
        return added == stacks.size();
    }

    public TileEntity getPullInv() {
        return Coord4D.get(this).translate(0, 2, 0).getTileEntity((IBlockAccess)this.field_70331_k);
    }

    public TileEntity getEjectInv() {
        ForgeDirection side = ForgeDirection.getOrientation((int)this.facing).getOpposite();
        return new Coord4D(this.field_70329_l + side.offsetX * 2, this.field_70330_m + 1, this.field_70327_n + side.offsetZ * 2, this.field_70331_k.field_73011_w.field_76574_g).getTileEntity((IBlockAccess)this.field_70331_k);
    }

    public void add(List<ItemStack> stacks) {
        if (stacks.isEmpty()) {
            return;
        }
        block0: for (ItemStack stack : stacks) {
            for (int i = 0; i < 27; ++i) {
                if (this.inventory[i] == null) {
                    this.inventory[i] = stack;
                    continue block0;
                }
                if (!this.inventory[i].func_77969_a(stack) || this.inventory[i].field_77994_a + stack.field_77994_a > stack.func_77976_d()) continue;
                this.inventory[i].field_77994_a += stack.field_77994_a;
                continue block0;
            }
        }
    }

    public void start() {
        if (this.searcher.state == ThreadMinerSearch.State.IDLE) {
            this.searcher.start();
        }
        this.running = true;
        MekanismUtils.saveChunk(this);
    }

    public void stop() {
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            this.searcher.interrupt();
            this.reset();
            return;
        }
        if (this.searcher.state == ThreadMinerSearch.State.FINISHED) {
            this.running = false;
        }
        MekanismUtils.saveChunk(this);
    }

    public void reset() {
        this.searcher = new ThreadMinerSearch(this);
        this.running = false;
        this.oresToMine.clear();
        MekanismUtils.saveChunk(this);
    }

    @Override
    public void func_70295_k_() {
        super.func_70295_k_();
        if (!this.field_70331_k.field_72995_K) {
            for (EntityPlayer player : this.playersUsing) {
                PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), player);
            }
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.radius = nbtTags.func_74762_e("radius");
        this.minY = nbtTags.func_74762_e("minY");
        this.maxY = nbtTags.func_74762_e("maxY");
        this.doEject = nbtTags.func_74767_n("doEject");
        this.doPull = nbtTags.func_74767_n("doPull");
        this.isActive = nbtTags.func_74767_n("isActive");
        this.running = nbtTags.func_74767_n("running");
        this.delay = nbtTags.func_74762_e("delay");
        this.silkTouch = nbtTags.func_74767_n("silkTouch");
        this.numPowering = nbtTags.func_74762_e("numPowering");
        this.searcher.state = ThreadMinerSearch.State.values()[nbtTags.func_74762_e("state")];
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.inverse = nbtTags.func_74767_n("inverse");
        if (nbtTags.func_74764_b("replaceStack")) {
            this.replaceStack = ItemStack.func_77949_a((NBTTagCompound)nbtTags.func_74775_l("replaceStack"));
        }
        if (nbtTags.func_74764_b("filters")) {
            NBTTagList tagList = nbtTags.func_74761_m("filters");
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.filters.add(MinerFilter.readFromNBT((NBTTagCompound)tagList.func_74743_b(i)));
            }
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            this.reset();
        }
        nbtTags.func_74768_a("radius", this.radius);
        nbtTags.func_74768_a("minY", this.minY);
        nbtTags.func_74768_a("maxY", this.maxY);
        nbtTags.func_74757_a("doEject", this.doEject);
        nbtTags.func_74757_a("doPull", this.doPull);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74757_a("running", this.running);
        nbtTags.func_74768_a("delay", this.delay);
        nbtTags.func_74757_a("silkTouch", this.silkTouch);
        nbtTags.func_74768_a("numPowering", this.numPowering);
        nbtTags.func_74768_a("state", this.searcher.state.ordinal());
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74757_a("inverse", this.inverse);
        if (this.replaceStack != null) {
            nbtTags.func_74766_a("replaceStack", this.replaceStack.func_77955_b(new NBTTagCompound()));
        }
        NBTTagList filterTags = new NBTTagList();
        for (MinerFilter filter : this.filters) {
            filterTags.func_74742_a((NBTBase)filter.write(new NBTTagCompound()));
        }
        if (filterTags.func_74745_c() != 0) {
            nbtTags.func_74782_a("filters", (NBTBase)filterTags);
        }
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        if (!this.field_70331_k.field_72995_K) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.doEject = !this.doEject;
            } else if (type == 1) {
                this.doPull = !this.doPull;
            } else if (type == 2) {
                boolean doNull = dataStream.readBoolean();
                this.replaceStack = !doNull ? new ItemStack(dataStream.readInt(), 1, dataStream.readInt()) : null;
            } else if (type == 3) {
                this.start();
            } else if (type == 4) {
                this.stop();
            } else if (type == 5) {
                this.reset();
            } else if (type == 6) {
                this.radius = dataStream.readInt();
            } else if (type == 7) {
                this.minY = dataStream.readInt();
            } else if (type == 8) {
                this.maxY = dataStream.readInt();
            } else if (type == 9) {
                this.silkTouch = !this.silkTouch;
            } else if (type == 10) {
                this.inverse = !this.inverse;
            }
            for (EntityPlayer player : this.playersUsing) {
                PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketTileEntity().setParams(Coord4D.get(this), this.getGenericPacket(new ArrayList())), player);
            }
            return;
        }
        super.handlePacketData(dataStream);
        int type = dataStream.readInt();
        if (type == 0) {
            this.radius = dataStream.readInt();
            this.minY = dataStream.readInt();
            this.maxY = dataStream.readInt();
            this.doEject = dataStream.readBoolean();
            this.doPull = dataStream.readBoolean();
            this.isActive = dataStream.readBoolean();
            this.running = dataStream.readBoolean();
            this.silkTouch = dataStream.readBoolean();
            this.numPowering = dataStream.readInt();
            this.searcher.state = ThreadMinerSearch.State.values()[dataStream.readInt()];
            this.replaceStack = dataStream.readBoolean() ? new ItemStack(dataStream.readInt(), 1, dataStream.readInt()) : null;
            this.clientToMine = dataStream.readInt();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            this.inverse = dataStream.readBoolean();
            this.filters.clear();
            int amount = dataStream.readInt();
            for (int i = 0; i < amount; ++i) {
                this.filters.add(MinerFilter.readFromPacket(dataStream));
            }
        } else if (type == 1) {
            this.radius = dataStream.readInt();
            this.minY = dataStream.readInt();
            this.maxY = dataStream.readInt();
            this.doEject = dataStream.readBoolean();
            this.doPull = dataStream.readBoolean();
            this.isActive = dataStream.readBoolean();
            this.running = dataStream.readBoolean();
            this.silkTouch = dataStream.readBoolean();
            this.numPowering = dataStream.readInt();
            this.searcher.state = ThreadMinerSearch.State.values()[dataStream.readInt()];
            this.replaceStack = dataStream.readBoolean() ? new ItemStack(dataStream.readInt(), 1, dataStream.readInt()) : null;
            this.clientToMine = dataStream.readInt();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            this.inverse = dataStream.readBoolean();
        } else if (type == 2) {
            this.filters.clear();
            int amount = dataStream.readInt();
            for (int i = 0; i < amount; ++i) {
                this.filters.add(MinerFilter.readFromPacket(dataStream));
            }
        } else if (type == 3) {
            this.isActive = dataStream.readBoolean();
            this.running = dataStream.readBoolean();
            this.clientToMine = dataStream.readInt();
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(0);
        data.add(this.radius);
        data.add(this.minY);
        data.add(this.maxY);
        data.add(this.doEject);
        data.add(this.doPull);
        data.add(this.isActive);
        data.add(this.running);
        data.add(this.silkTouch);
        data.add(this.numPowering);
        data.add(this.searcher.state.ordinal());
        if (this.replaceStack != null) {
            data.add(true);
            data.add(this.replaceStack.field_77993_c);
            data.add(this.replaceStack.func_77960_j());
        } else {
            data.add(false);
        }
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            data.add(this.searcher.found);
        } else {
            data.add(this.oresToMine.cardinality());
        }
        data.add(this.controlType.ordinal());
        data.add(this.inverse);
        data.add(this.filters.size());
        for (MinerFilter filter : this.filters) {
            filter.write(data);
        }
        return data;
    }

    public ArrayList getSmallPacket(ArrayList data) {
        super.getNetworkedData(data);
        data.add(3);
        data.add(this.isActive);
        data.add(this.running);
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            data.add(this.searcher.found);
        } else {
            data.add(this.oresToMine.cardinality());
        }
        return data;
    }

    public ArrayList getGenericPacket(ArrayList data) {
        super.getNetworkedData(data);
        data.add(1);
        data.add(this.radius);
        data.add(this.minY);
        data.add(this.maxY);
        data.add(this.doEject);
        data.add(this.doPull);
        data.add(this.isActive);
        data.add(this.running);
        data.add(this.silkTouch);
        data.add(this.numPowering);
        data.add(this.searcher.state.ordinal());
        if (this.replaceStack != null) {
            data.add(true);
            data.add(this.replaceStack.field_77993_c);
            data.add(this.replaceStack.func_77960_j());
        } else {
            data.add(false);
        }
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            data.add(this.searcher.found);
        } else {
            data.add(this.oresToMine.cardinality());
        }
        data.add(this.controlType.ordinal());
        data.add(this.inverse);
        return data;
    }

    public ArrayList getFilterPacket(ArrayList data) {
        super.getNetworkedData(data);
        data.add(2);
        data.add(this.filters.size());
        for (MinerFilter filter : this.filters) {
            filter.write(data);
        }
        return data;
    }

    public int getTotalSize() {
        return this.getDiameter() * this.getDiameter() * (this.maxY - this.minY + 1);
    }

    public int getDiameter() {
        return this.radius * 2 + 1;
    }

    public Coord4D getStartingCoord() {
        return new Coord4D(this.field_70329_l - this.radius, this.minY, this.field_70327_n - this.radius, this.field_70331_k.field_73011_w.field_76574_g);
    }

    public Coord4D getCoordFromIndex(int index) {
        int diameter = this.getDiameter();
        Coord4D start = this.getStartingCoord();
        int x = start.xCoord + index % diameter;
        int z = start.zCoord + index / diameter % diameter;
        int y = start.yCoord + index / diameter / diameter;
        return new Coord4D(x, y, z, this.field_70331_k.field_73011_w.field_76574_g);
    }

    @Override
    public double getMaxEnergy() {
        return MekanismUtils.getMaxEnergy(this.getEnergyMultiplier(new Object[0]), this.MAX_ELECTRICITY);
    }

    @Override
    public boolean isPowered() {
        return this.redstone || this.numPowering > 0;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public int getEnergyMultiplier(Object ... data) {
        return this.upgradeComponent.energyMultiplier;
    }

    @Override
    public void setEnergyMultiplier(int multiplier, Object ... data) {
        this.upgradeComponent.energyMultiplier = multiplier;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public int getSpeedMultiplier(Object ... data) {
        return this.upgradeComponent.speedMultiplier;
    }

    @Override
    public void setSpeedMultiplier(int multiplier, Object ... data) {
        this.upgradeComponent.speedMultiplier = multiplier;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean supportsUpgrades(Object ... data) {
        return true;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active) {
            PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public void onPlace() {
        for (int x = this.field_70329_l - 1; x <= this.field_70329_l + 1; ++x) {
            for (int y = this.field_70330_m; y <= this.field_70330_m + 1; ++y) {
                for (int z = this.field_70327_n - 1; z <= this.field_70327_n + 1; ++z) {
                    if (x == this.field_70329_l && y == this.field_70330_m && z == this.field_70327_n) continue;
                    MekanismUtils.makeAdvancedBoundingBlock(this.field_70331_k, x, y, z, Coord4D.get(this));
                    this.field_70331_k.func_72898_h(x, y, z, Mekanism.BoundingBlock.field_71990_ca);
                }
            }
        }
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public void onBreak() {
        for (int x = this.field_70329_l - 1; x <= this.field_70329_l + 1; ++x) {
            for (int y = this.field_70330_m; y <= this.field_70330_m + 1; ++y) {
                for (int z = this.field_70327_n - 1; z <= this.field_70327_n + 1; ++z) {
                    this.field_70331_k.func_94571_i(x, y, z);
                }
            }
        }
    }

    @Override
    public int[] func_94128_d(int side) {
        return InventoryUtils.EMPTY;
    }

    public TileEntity getEjectTile() {
        ForgeDirection side = ForgeDirection.getOrientation((int)this.facing).getOpposite();
        return new Coord4D(this.field_70329_l + side.offsetX, this.field_70330_m + 1, this.field_70327_n + side.offsetZ, this.field_70331_k.field_73011_w.field_76574_g).getTileEntity((IBlockAccess)this.field_70331_k);
    }

    @Override
    public int[] getBoundSlots(Coord4D location, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.facing).getOpposite();
        Coord4D eject = Coord4D.get(this).translate(dir.offsetX, 1, dir.offsetZ);
        Coord4D pull = Coord4D.get(this).translate(0, 1, 0);
        if (location.equals(eject) && side == dir.ordinal() || location.equals(pull) && side == 1) {
            if (EJECT_INV == null) {
                EJECT_INV = new int[27];
                for (int i = 0; i < EJECT_INV.length; ++i) {
                    TileEntityDigitalMiner.EJECT_INV[i] = i;
                }
            }
            return EJECT_INV;
        }
        return InventoryUtils.EMPTY;
    }

    @Override
    public boolean canBoundInsert(Coord4D location, int i, ItemStack itemstack) {
        ForgeDirection side = ForgeDirection.getOrientation((int)this.facing).getOpposite();
        Coord4D eject = Coord4D.get(this).translate(side.offsetX, 1, side.offsetZ);
        Coord4D pull = Coord4D.get(this).translate(0, 1, 0);
        if (location.equals(eject)) {
            return false;
        }
        return location.equals(pull) && itemstack != null && this.replaceStack != null && itemstack.func_77969_a(this.replaceStack);
    }

    @Override
    public boolean canBoundExtract(Coord4D location, int i, ItemStack itemstack, int j) {
        ForgeDirection side = ForgeDirection.getOrientation((int)this.facing).getOpposite();
        Coord4D eject = new Coord4D(this.field_70329_l + side.offsetX, this.field_70330_m + 1, this.field_70327_n + side.offsetZ, this.field_70331_k.field_73011_w.field_76574_g);
        Coord4D pull = new Coord4D(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n, this.field_70331_k.field_73011_w.field_76574_g);
        if (location.equals(eject)) {
            return itemstack == null || this.replaceStack == null || !itemstack.func_77969_a(this.replaceStack);
        }
        if (location.equals(pull)) {
            return false;
        }
        return false;
    }

    @Override
    public void onPower() {
        ++this.numPowering;
    }

    @Override
    public void onNoPower() {
        --this.numPowering;
    }

    @Override
    public String getType() {
        return this.func_70303_b();
    }

    @Override
    public String[] getMethodNames() {
        return this.names;
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        if (arguments.length > 0) {
            int num = 0;
            if (arguments[0] instanceof Double) {
                num = ((Double)arguments[0]).intValue();
            } else if (arguments[0] instanceof String && method != 6 && method != 7) {
                num = Integer.parseInt((String)arguments[0]);
            }
            if (num != 0) {
                MinerFilter filter;
                if (method == 0) {
                    this.radius = num;
                } else if (method == 1) {
                    this.minY = num;
                } else if (method == 2) {
                    this.maxY = num;
                } else if (method == 3) {
                    int meta = 0;
                    if (arguments.length > 1) {
                        if (arguments[1] instanceof Double) {
                            num = ((Double)arguments[1]).intValue();
                        } else if (arguments[1] instanceof String) {
                            meta = Integer.parseInt((String)arguments[1]);
                        }
                    }
                    this.replaceStack = new ItemStack(num, 1, meta);
                } else if (method == 4) {
                    int meta = 0;
                    if (arguments.length > 1) {
                        if (arguments[1] instanceof Double) {
                            meta = ((Double)arguments[1]).intValue();
                        } else if (arguments[1] instanceof String) {
                            meta = Integer.parseInt((String)arguments[1]);
                        }
                    }
                    this.filters.add(new MItemStackFilter(new ItemStack(num, 1, meta)));
                } else if (method == 5) {
                    Iterator iter = this.filters.iterator();
                    while (iter.hasNext()) {
                        filter = (MinerFilter)iter.next();
                        if (!(filter instanceof MItemStackFilter) || ((MItemStackFilter)filter).itemType.field_77993_c != num) continue;
                        iter.remove();
                    }
                } else if (method == 6) {
                    String ore = (String)arguments[0];
                    filter = new MOreDictFilter();
                    ((MOreDictFilter)filter).oreDictName = ore;
                    this.filters.add(filter);
                } else if (method == 7) {
                    String ore = (String)arguments[0];
                    Iterator iter = this.filters.iterator();
                    while (iter.hasNext()) {
                        MinerFilter filter2 = (MinerFilter)iter.next();
                        if (!(filter2 instanceof MOreDictFilter) || ((MOreDictFilter)filter2).oreDictName != ore) continue;
                        iter.remove();
                    }
                } else if (method == 8) {
                    this.reset();
                } else if (method == 9) {
                    this.start();
                } else if (method == 10) {
                    this.stop();
                }
            }
        }
        for (EntityPlayer player : this.playersUsing) {
            PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketTileEntity().setParams(Coord4D.get(this), this.getGenericPacket(new ArrayList())), player);
        }
        return null;
    }

    @Override
    public boolean canAttachToSide(int side) {
        return true;
    }

    @Override
    public void attach(IComputerAccess computer) {
    }

    @Override
    public void detach(IComputerAccess computer) {
    }
}

