/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.ILuaContext;
import mekanism.api.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.tile.TileEntityBasicMachine;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class TileEntityElectricMachine
extends TileEntityBasicMachine {
    public TileEntityElectricMachine(String soundPath, String name, ResourceLocation location, double perTick, int ticksRequired, double maxEnergy) {
        super(soundPath, name, location, perTick, ticksRequired, maxEnergy);
        this.sideOutputs.add(new SideData(EnumColor.GREY, InventoryUtils.EMPTY));
        this.sideOutputs.add(new SideData(EnumColor.DARK_RED, new int[]{0}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_GREEN, new int[]{1}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_BLUE, new int[]{2}));
        this.sideOutputs.add(new SideData(EnumColor.ORANGE, new int[]{3}));
        this.sideConfig = new byte[]{2, 1, 0, 0, 4, 3};
        this.inventory = new ItemStack[4];
        this.upgradeComponent = new TileComponentUpgrade(this, 3);
        this.ejectorComponent = new TileComponentEjector(this, (SideData)this.sideOutputs.get(3));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_70331_k.field_72995_K) {
            ChargeUtils.discharge(1, this);
            if (this.canOperate() && MekanismUtils.canFunction(this) && this.getEnergy() >= MekanismUtils.getEnergyPerTick(this.getSpeedMultiplier(new Object[0]), this.getEnergyMultiplier(new Object[0]), this.ENERGY_PER_TICK)) {
                this.setActive(true);
                if (this.operatingTicks + 1 < MekanismUtils.getTicks(this.getSpeedMultiplier(new Object[0]), this.TICKS_REQUIRED)) {
                    ++this.operatingTicks;
                    this.electricityStored -= MekanismUtils.getEnergyPerTick(this.getSpeedMultiplier(new Object[0]), this.getEnergyMultiplier(new Object[0]), this.ENERGY_PER_TICK);
                } else if (this.operatingTicks + 1 >= MekanismUtils.getTicks(this.getSpeedMultiplier(new Object[0]), this.TICKS_REQUIRED)) {
                    this.operate();
                    this.operatingTicks = 0;
                    this.electricityStored -= MekanismUtils.getEnergyPerTick(this.getSpeedMultiplier(new Object[0]), this.getEnergyMultiplier(new Object[0]), this.ENERGY_PER_TICK);
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (!this.canOperate()) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 2) {
            return false;
        }
        if (slotID == 3) {
            return itemstack.field_77993_c == Mekanism.SpeedUpgrade.field_77779_bT || itemstack.field_77993_c == Mekanism.EnergyUpgrade.field_77779_bT;
        }
        if (slotID == 0) {
            return RecipeHandler.isInRecipe(itemstack, this.getRecipes());
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public void operate() {
        ItemStack itemstack = RecipeHandler.getOutput(this.inventory[0], true, this.getRecipes());
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
        if (this.inventory[2] == null) {
            this.inventory[2] = itemstack;
        } else {
            this.inventory[2].field_77994_a += itemstack.field_77994_a;
        }
        this.func_70296_d();
        this.ejectorComponent.onOutput();
    }

    @Override
    public boolean canOperate() {
        if (this.inventory[0] == null) {
            return false;
        }
        ItemStack itemstack = RecipeHandler.getOutput(this.inventory[0], false, this.getRecipes());
        if (itemstack == null) {
            return false;
        }
        if (this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[2].func_77969_a(itemstack)) {
            return false;
        }
        return this.inventory[2].field_77994_a + itemstack.field_77994_a <= this.inventory[2].func_77976_d();
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 2;
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getStored", "getProgress", "isActive", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.operatingTicks};
            }
            case 2: {
                return new Object[]{this.isActive};
            }
            case 3: {
                return new Object[]{this.facing};
            }
            case 4: {
                return new Object[]{this.canOperate()};
            }
            case 5: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 6: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }
}

