/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transporter;

import java.util.List;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;

public abstract class Finder {
    public abstract boolean modifies(ItemStack var1);

    public static class ItemStackFinder
    extends Finder {
        public ItemStack itemType;

        public ItemStackFinder(ItemStack type) {
            this.itemType = type;
        }

        @Override
        public boolean modifies(ItemStack stack) {
            return StackUtils.equalsWildcard(this.itemType, stack);
        }
    }

    public static class OreDictFinder
    extends Finder {
        public String oreDictName;

        public OreDictFinder(String name) {
            this.oreDictName = name;
        }

        @Override
        public boolean modifies(ItemStack stack) {
            List<String> oreKeys = MekanismUtils.getOreDictName(stack);
            if (oreKeys.isEmpty()) {
                return false;
            }
            for (String oreKey : oreKeys) {
                if (this.oreDictName.equals(oreKey) || this.oreDictName.equals("*")) {
                    return true;
                }
                if (!(this.oreDictName.endsWith("*") && !this.oreDictName.startsWith("*") ? oreKey.startsWith(this.oreDictName.substring(0, this.oreDictName.length() - 1)) : (this.oreDictName.startsWith("*") && !this.oreDictName.endsWith("*") ? oreKey.endsWith(this.oreDictName.substring(1)) : this.oreDictName.startsWith("*") && this.oreDictName.endsWith("*") && oreKey.contains(this.oreDictName.substring(1, this.oreDictName.length() - 1))))) continue;
                return true;
            }
            return false;
        }
    }

    public static class FirstFinder
    extends Finder {
        @Override
        public boolean modifies(ItemStack stack) {
            return true;
        }
    }
}

