/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transporter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.common.ILogisticalTransporter;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.transporter.TransporterManager;
import mekanism.common.transporter.TransporterStack;
import mekanism.common.util.InventoryUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public final class TransporterPathfinder {
    public static List<Destination> getPaths(ILogisticalTransporter start, TransporterStack stack, int min) {
        Pathfinder.DestChecker checker = new Pathfinder.DestChecker(){

            @Override
            public boolean isValid(TransporterStack stack, int side, TileEntity tile) {
                return InventoryUtils.canInsert(tile, stack.color, stack.itemStack, side, false);
            }
        };
        InventoryFinder d = new InventoryFinder(start.getTile().field_70331_k, Coord4D.get(start.getTile()), stack);
        Set<Coord4D> destsFound = d.find();
        ArrayList<Destination> paths = new ArrayList<Destination>();
        for (Coord4D obj : destsFound) {
            Pathfinder p = new Pathfinder(checker, start.getTile().field_70331_k, obj, Coord4D.get(start.getTile()), stack);
            if (p.getPath().size() < 2 || TransporterManager.getToUse((ItemStack)stack.itemStack, (ItemStack)d.rejects.get((Object)obj)).field_77994_a < min) continue;
            paths.add(new Destination(p.getPath(), p.finalScore, false, d.rejects.get(obj)));
        }
        Collections.sort(paths);
        return paths;
    }

    public static Destination getNewBasePath(ILogisticalTransporter start, TransporterStack stack, int min) {
        List<Destination> paths = TransporterPathfinder.getPaths(start, stack, min);
        if (paths.isEmpty()) {
            return null;
        }
        return paths.get(0);
    }

    public static Destination getNewRRPath(ILogisticalTransporter start, TransporterStack stack, TileEntityLogisticalSorter outputter, int min) {
        List<Destination> paths = TransporterPathfinder.getPaths(start, stack, min);
        HashMap<Coord4D, Destination> destPaths = new HashMap<Coord4D, Destination>();
        for (Destination d : paths) {
            if (destPaths.get(d.path.get(0)) != null && !(((Destination)destPaths.get((Object)d.path.get((int)0))).score < d.score)) continue;
            destPaths.put(d.path.get(0), d);
        }
        ArrayList dests = new ArrayList();
        dests.addAll(destPaths.values());
        Collections.sort(dests);
        Destination closest = null;
        if (!dests.isEmpty()) {
            if (outputter.rrIndex <= dests.size() - 1) {
                closest = (Destination)dests.get(outputter.rrIndex);
                if (outputter.rrIndex == dests.size() - 1) {
                    outputter.rrIndex = 0;
                } else if (outputter.rrIndex < dests.size() - 1) {
                    ++outputter.rrIndex;
                }
            } else {
                closest = (Destination)dests.get(dests.size() - 1);
                outputter.rrIndex = 0;
            }
        }
        if (closest == null) {
            return null;
        }
        return closest;
    }

    public static List<Coord4D> getIdlePath(ILogisticalTransporter start, TransporterStack stack) {
        if (stack.homeLocation != null) {
            Pathfinder.DestChecker checker = new Pathfinder.DestChecker(){

                @Override
                public boolean isValid(TransporterStack stack, int side, TileEntity tile) {
                    return InventoryUtils.canInsert(tile, stack.color, stack.itemStack, side, true);
                }
            };
            Pathfinder p = new Pathfinder(checker, start.getTile().field_70331_k, stack.homeLocation, Coord4D.get(start.getTile()), stack);
            ArrayList<Coord4D> path = p.getPath();
            if (path.size() >= 2) {
                stack.pathType = TransporterStack.Path.HOME;
                return path;
            }
            if (stack.homeLocation.getTileEntity((IBlockAccess)start.getTile().field_70331_k) == null) {
                stack.homeLocation = null;
            }
        }
        IdlePath d = new IdlePath(start.getTile().field_70331_k, Coord4D.get(start.getTile()), stack);
        List<Coord4D> path = d.find();
        stack.pathType = TransporterStack.Path.NONE;
        if (path == null) {
            return null;
        }
        return path;
    }

    public static class Pathfinder {
        public final Set<Coord4D> openSet;
        public final Set<Coord4D> closedSet;
        public final HashMap<Coord4D, Coord4D> navMap;
        public final HashMap<Coord4D, Double> gScore;
        public final HashMap<Coord4D, Double> fScore;
        public final Coord4D start;
        public final Coord4D finalNode;
        public final TransporterStack transportStack;
        public final DestChecker destChecker;
        public double finalScore;
        public ArrayList<Coord4D> results;
        private World worldObj;

        public Pathfinder(DestChecker checker, World world, Coord4D finishObj, Coord4D startObj, TransporterStack stack) {
            this.destChecker = checker;
            this.worldObj = world;
            this.finalNode = finishObj;
            this.start = startObj;
            this.transportStack = stack;
            this.openSet = new HashSet<Coord4D>();
            this.closedSet = new HashSet<Coord4D>();
            this.navMap = new HashMap();
            this.gScore = new HashMap();
            this.fScore = new HashMap();
            this.results = new ArrayList();
            this.find(this.start);
        }

        public boolean find(Coord4D start) {
            this.openSet.add(start);
            this.gScore.put(start, 0.0);
            this.fScore.put(start, this.gScore.get(start) + this.getEstimate(start, this.finalNode));
            int blockCount = 0;
            for (int i = 0; i < 6; ++i) {
                ForgeDirection direction = ForgeDirection.getOrientation((int)i);
                Coord4D neighbor = start.translate(direction.offsetX, direction.offsetY, direction.offsetZ);
                if (this.transportStack.canInsertToTransporter(neighbor.getTileEntity((IBlockAccess)this.worldObj), direction) || neighbor.equals(this.finalNode) && this.destChecker.isValid(this.transportStack, i, neighbor.getTileEntity((IBlockAccess)this.worldObj))) continue;
                ++blockCount;
            }
            if (blockCount >= 6) {
                return false;
            }
            double maxSearchDistance = start.distanceTo(this.finalNode) * 2;
            while (!this.openSet.isEmpty()) {
                Coord4D currentNode = null;
                double lowestFScore = 0.0;
                for (Coord4D node : this.openSet) {
                    if (currentNode != null && !(this.fScore.get(node) < lowestFScore)) continue;
                    currentNode = node;
                    lowestFScore = this.fScore.get(node);
                }
                if (currentNode == null && (double)start.distanceTo(currentNode) > maxSearchDistance) break;
                this.openSet.remove(currentNode);
                this.closedSet.add(currentNode);
                for (int i = 0; i < 6; ++i) {
                    ForgeDirection direction = ForgeDirection.getOrientation((int)i);
                    Coord4D neighbor = currentNode.getFromSide(direction);
                    if (this.transportStack.canInsertToTransporter(neighbor.getTileEntity((IBlockAccess)this.worldObj), direction)) {
                        TileEntity tile = neighbor.getTileEntity((IBlockAccess)this.worldObj);
                        double tentativeG = this.gScore.get(currentNode) + (double)currentNode.distanceTo(neighbor);
                        if (this.closedSet.contains(neighbor) && (tentativeG += (double)((ILogisticalTransporter)tile).getCost()) >= this.gScore.get(neighbor)) continue;
                        TileEntity currTile = currentNode.getTileEntity((IBlockAccess)this.worldObj);
                        if (this.openSet.contains(neighbor) && !(tentativeG < this.gScore.get(neighbor))) continue;
                        this.navMap.put(neighbor, currentNode);
                        this.gScore.put(neighbor, tentativeG);
                        this.fScore.put(neighbor, this.gScore.get(neighbor) + this.getEstimate(neighbor, this.finalNode));
                        this.openSet.add(neighbor);
                        continue;
                    }
                    if (!neighbor.equals(this.finalNode) || !this.destChecker.isValid(this.transportStack, i, neighbor.getTileEntity((IBlockAccess)this.worldObj))) continue;
                    this.results = this.reconstructPath(this.navMap, currentNode);
                    return true;
                }
            }
            return false;
        }

        private ArrayList<Coord4D> reconstructPath(HashMap<Coord4D, Coord4D> naviMap, Coord4D currentNode) {
            ArrayList<Coord4D> path = new ArrayList<Coord4D>();
            path.add(currentNode);
            if (naviMap.containsKey(currentNode)) {
                path.addAll(this.reconstructPath(naviMap, naviMap.get(currentNode)));
            }
            this.finalScore = this.gScore.get(currentNode) + (double)currentNode.distanceTo(this.finalNode);
            return path;
        }

        public ArrayList<Coord4D> getPath() {
            ArrayList<Coord4D> path = new ArrayList<Coord4D>();
            path.add(this.finalNode);
            path.addAll((ArrayList)this.results.clone());
            return path;
        }

        private double getEstimate(Coord4D start, Coord4D target2) {
            return start.distanceTo(target2);
        }

        public static class DestChecker {
            public boolean isValid(TransporterStack stack, int side, TileEntity tile) {
                return false;
            }
        }
    }

    public static class InventoryFinder {
        public World worldObj;
        public Set<Coord4D> iterated = new HashSet<Coord4D>();
        public Set<Coord4D> destsFound = new HashSet<Coord4D>();
        public Map<Coord4D, ItemStack> rejects = new HashMap<Coord4D, ItemStack>();
        public Coord4D start;
        public TransporterStack transportStack;

        public InventoryFinder(World world, Coord4D obj, TransporterStack stack) {
            this.worldObj = world;
            this.start = obj;
            this.transportStack = stack;
        }

        public void loop(Coord4D pointer) {
            if (pointer == null) {
                return;
            }
            this.iterated.add(pointer);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = pointer.getFromSide(side).getTileEntity((IBlockAccess)this.worldObj);
                if (tile == null || Coord4D.get(tile).equals(this.transportStack.originalLocation)) continue;
                if (tile instanceof IInventory) {
                    ItemStack stack;
                    ILogisticalTransporter trans;
                    if (pointer.getTileEntity((IBlockAccess)this.worldObj) instanceof ILogisticalTransporter && !(trans = (ILogisticalTransporter)pointer.getTileEntity((IBlockAccess)this.worldObj)).canEmitTo(tile, side) || !TransporterManager.didEmit(this.transportStack.itemStack, stack = TransporterManager.getPredictedInsert(tile, this.transportStack.color, this.transportStack.itemStack, side.ordinal()))) continue;
                    this.destsFound.add(Coord4D.get(tile));
                    this.rejects.put(Coord4D.get(tile), stack);
                    continue;
                }
                if (!this.transportStack.canInsertToTransporter(tile, side) || this.iterated.contains(Coord4D.get(tile))) continue;
                this.loop(Coord4D.get(tile));
            }
        }

        public Set<Coord4D> find() {
            this.loop(this.start);
            return this.destsFound;
        }
    }

    public static class Destination
    implements Comparable<Destination> {
        public List<Coord4D> path = new ArrayList<Coord4D>();
        public double score;
        public ItemStack rejected;

        public Destination(ArrayList<Coord4D> list, double d, boolean inv, ItemStack rejects) {
            this.path = (List)list.clone();
            if (inv) {
                Collections.reverse(this.path);
            }
            this.score = d;
            this.rejected = rejects;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.path.hashCode();
            code = 31 * code + new Double(this.score).hashCode();
            return code;
        }

        public boolean equals(Object dest) {
            return dest instanceof Destination && ((Destination)dest).path.equals(this.path) && ((Destination)dest).score == this.score;
        }

        @Override
        public int compareTo(Destination dest) {
            if (this.score < dest.score) {
                return -1;
            }
            if (this.score > dest.score) {
                return 1;
            }
            return 0;
        }
    }

    public static class IdlePath {
        public World worldObj;
        public Coord4D start;
        public Set<Destination> destinations = new HashSet<Destination>();
        public TransporterStack transportStack;

        public IdlePath(World world, Coord4D obj, TransporterStack stack) {
            this.worldObj = world;
            this.start = obj;
            this.transportStack = stack;
        }

        public void loop(Coord4D pointer, ArrayList<Coord4D> currentPath, int dist) {
            if (pointer == null) {
                return;
            }
            currentPath.add(pointer);
            dist += ((ILogisticalTransporter)pointer.getTileEntity((IBlockAccess)this.worldObj)).getCost();
            boolean found = false;
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = pointer.getFromSide(side).getTileEntity((IBlockAccess)this.worldObj);
                if (!this.transportStack.canInsertToTransporter(tile, side) || currentPath.contains(Coord4D.get(tile))) continue;
                this.loop(Coord4D.get(tile), (ArrayList)currentPath.clone(), dist);
                found = true;
            }
            if (!found) {
                this.destinations.add(new Destination(currentPath, dist, true, null));
            }
        }

        public List<Coord4D> find() {
            this.loop(this.start, new ArrayList<Coord4D>(), 0);
            Destination farthest = null;
            for (Destination obj : this.destinations) {
                if (farthest != null && !(obj.score > farthest.score) || obj.path.isEmpty() || obj.path.get(0).equals(this.start)) continue;
                farthest = obj;
            }
            if (farthest == null) {
                return null;
            }
            return farthest.path;
        }
    }
}

