/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Arrays;
import mekanism.api.Coord4D;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmissionType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public final class PipeUtils {
    public static final FluidTankInfo[] EMPTY = new FluidTankInfo[0];

    public static TileEntity[] getConnectedPipes(TileEntity tileEntity) {
        TileEntity[] pipes = new TileEntity[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity pipe = Coord4D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
            if (!TransmissionType.checkTransmissionType(pipe, TransmissionType.FLUID)) continue;
            pipes[orientation.ordinal()] = pipe;
        }
        return pipes;
    }

    public static boolean[] getConnections(TileEntity tileEntity) {
        int side;
        IFluidHandler[] connectedAcceptors;
        boolean[] connectable = new boolean[]{false, false, false, false, false, false};
        TileEntity[] connectedPipes = PipeUtils.getConnectedPipes(tileEntity);
        for (IFluidHandler iFluidHandler : connectedAcceptors = PipeUtils.getConnectedAcceptors(tileEntity)) {
            FluidTankInfo[] infoArray;
            if (iFluidHandler == null || (infoArray = iFluidHandler.getTankInfo(ForgeDirection.getOrientation((int)(side = Arrays.asList(connectedAcceptors).indexOf(iFluidHandler))).getOpposite())) == null || infoArray.length <= 0) continue;
            boolean notNull = false;
            for (FluidTankInfo info : iFluidHandler.getTankInfo(ForgeDirection.getOrientation((int)side).getOpposite())) {
                if (info == null) continue;
                notNull = true;
                break;
            }
            if (!notNull) continue;
            connectable[side] = true;
        }
        for (IFluidHandler iFluidHandler : connectedPipes) {
            if (iFluidHandler == null) continue;
            side = Arrays.asList(connectedPipes).indexOf(iFluidHandler);
            connectable[side] = true;
        }
        return connectable;
    }

    public static IFluidHandler[] getConnectedAcceptors(TileEntity tileEntity) {
        IFluidHandler[] acceptors = new IFluidHandler[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity acceptor = Coord4D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
            if (!(acceptor instanceof IFluidHandler) || acceptor instanceof IGridTransmitter) continue;
            acceptors[orientation.ordinal()] = (IFluidHandler)acceptor;
        }
        return acceptors;
    }
}

