/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import java.util.Arrays;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.ListUtils;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.common.ILogisticalTransporter;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.transporter.TransporterManager;
import mekanism.common.transporter.TransporterStack;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public final class TransporterUtils {
    public static List<EnumColor> colors = ListUtils.asList(EnumColor.DARK_BLUE, EnumColor.DARK_GREEN, EnumColor.DARK_AQUA, EnumColor.DARK_RED, EnumColor.PURPLE, EnumColor.INDIGO, EnumColor.BRIGHT_GREEN, EnumColor.AQUA, EnumColor.RED, EnumColor.PINK, EnumColor.YELLOW, EnumColor.BLACK);

    public static TileEntity[] getConnectedTransporters(ILogisticalTransporter tileEntity) {
        TileEntity[] transporters = new TileEntity[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            ILogisticalTransporter transporter;
            TileEntity tile = Coord4D.get(tileEntity.getTile()).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.getTile().field_70331_k);
            if (!(tile instanceof ILogisticalTransporter) || (transporter = (ILogisticalTransporter)tile).getColor() != null && tileEntity.getColor() != null && transporter.getColor() != tileEntity.getColor()) continue;
            transporters[orientation.ordinal()] = transporter.getTile();
        }
        return transporters;
    }

    public static boolean[] getConnections(ILogisticalTransporter tileEntity) {
        int side;
        IInventory[] connectedInventories;
        boolean[] connectable = new boolean[]{false, false, false, false, false, false};
        TileEntity[] connectedTransporters = TransporterUtils.getConnectedTransporters(tileEntity);
        for (IInventory iInventory : connectedInventories = TransporterUtils.getConnectedInventories(tileEntity)) {
            if (iInventory == null || !tileEntity.canConnect(ForgeDirection.getOrientation((int)(side = Arrays.asList(connectedInventories).indexOf(iInventory))))) continue;
            ForgeDirection forgeSide = ForgeDirection.getOrientation((int)side).getOpposite();
            if (MekanismUtils.useBuildCraft() && iInventory instanceof IPowerReceptor && ((IPowerReceptor)iInventory).getPowerReceiver(forgeSide) != null && ((IPowerReceptor)iInventory).getPowerReceiver(forgeSide).getType() == PowerHandler.Type.MACHINE) {
                connectable[side] = true;
                continue;
            }
            if (iInventory.func_70302_i_() <= 0) continue;
            if (iInventory instanceof ISidedInventory) {
                ISidedInventory sidedInventory = (ISidedInventory)iInventory;
                if (sidedInventory.func_94128_d(forgeSide.ordinal()) == null || sidedInventory.func_94128_d(forgeSide.ordinal()).length <= 0) continue;
                connectable[side] = true;
                continue;
            }
            connectable[side] = true;
        }
        for (IInventory iInventory : connectedTransporters) {
            if (iInventory == null || !tileEntity.canConnectMutual(ForgeDirection.getOrientation((int)(side = Arrays.asList(connectedTransporters).indexOf(iInventory))))) continue;
            connectable[side] = true;
        }
        return connectable;
    }

    public static IInventory[] getConnectedInventories(ILogisticalTransporter tileEntity) {
        IInventory[] inventories = new IInventory[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity inventory = Coord4D.get(tileEntity.getTile()).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.getTile().field_70331_k);
            if (!(inventory instanceof IInventory) || inventory instanceof IGridTransmitter) continue;
            inventories[orientation.ordinal()] = (IInventory)inventory;
        }
        return inventories;
    }

    public static ItemStack insert(TileEntity outputter, ILogisticalTransporter tileEntity, ItemStack itemStack, EnumColor color, boolean doEmit, int min) {
        return tileEntity.insert(Coord4D.get(outputter), itemStack.func_77946_l(), color, doEmit, min);
    }

    public static ItemStack insertRR(TileEntityLogisticalSorter outputter, ILogisticalTransporter tileEntity, ItemStack itemStack, EnumColor color, boolean doEmit, int min) {
        return tileEntity.insertRR(outputter, itemStack.func_77946_l(), color, doEmit, min);
    }

    public static EnumColor increment(EnumColor color) {
        if (color == null) {
            return colors.get(0);
        }
        if (colors.indexOf((Object)color) == colors.size() - 1) {
            return null;
        }
        return colors.get(colors.indexOf((Object)color) + 1);
    }

    public static EnumColor decrement(EnumColor color) {
        if (color == null) {
            return colors.get(colors.size() - 1);
        }
        if (colors.indexOf((Object)color) == 0) {
            return null;
        }
        return colors.get(colors.indexOf((Object)color) - 1);
    }

    public static void drop(ILogisticalTransporter tileEntity, TransporterStack stack) {
        float[] pos = null;
        pos = stack.pathToTarget != null ? TransporterUtils.getStackPosition(tileEntity, stack, 0.0f) : new float[]{0.0f, 0.0f, 0.0f};
        TransporterManager.remove(stack);
        EntityItem entityItem = new EntityItem(tileEntity.getTile().field_70331_k, (double)((float)tileEntity.getTile().field_70329_l + pos[0]), (double)((float)tileEntity.getTile().field_70330_m + pos[1]), (double)((float)tileEntity.getTile().field_70327_n + pos[2]), stack.itemStack);
        entityItem.field_70159_w = 0.0;
        entityItem.field_70181_x = 0.0;
        entityItem.field_70179_y = 0.0;
        tileEntity.getTile().field_70331_k.func_72838_d((Entity)entityItem);
    }

    public static float[] getStackPosition(ILogisticalTransporter tileEntity, TransporterStack stack, float partial) {
        Coord4D offset = new Coord4D(0, 0, 0, tileEntity.getTile().field_70331_k.field_73011_w.field_76574_g).step(ForgeDirection.getOrientation((int)stack.getSide(tileEntity)));
        float progress = ((float)stack.progress + partial) / 100.0f - 0.5f;
        float itemFix = 0.0f;
        if (!(stack.itemStack.func_77973_b() instanceof ItemBlock)) {
            itemFix = 0.1f;
        }
        return new float[]{0.5f + (float)offset.xCoord * progress, 0.5f + (float)offset.yCoord * progress - itemFix, 0.5f + (float)offset.zCoord * progress};
    }

    public static void incrementColor(ILogisticalTransporter tileEntity) {
        if (tileEntity.getColor() == null) {
            tileEntity.setColor(colors.get(0));
            return;
        }
        if (colors.indexOf((Object)tileEntity.getColor()) == colors.size() - 1) {
            tileEntity.setColor(null);
            return;
        }
        int index = colors.indexOf((Object)tileEntity.getColor());
        tileEntity.setColor(colors.get(index + 1));
    }
}

