/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.api.energy;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;

public class EnergyStorageHandler {
    protected long energy;
    protected long capacity;
    protected long maxReceive;
    protected long maxExtract;
    protected long lastEnergy;

    public EnergyStorageHandler() {
        this(0L);
    }

    public EnergyStorageHandler(long capacity) {
        this(capacity, capacity, capacity);
    }

    public EnergyStorageHandler(long capacity, long maxTransfer) {
        this(capacity, maxTransfer, maxTransfer);
    }

    public EnergyStorageHandler(long capacity, long maxReceive, long maxExtract) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public EnergyStorageHandler readFromNBT(NBTTagCompound nbt) {
        NBTBase energyTag = nbt.func_74781_a("energy");
        if (energyTag instanceof NBTTagDouble) {
            this.energy = (long)((NBTTagDouble)energyTag).field_74755_a;
        } else if (energyTag instanceof NBTTagFloat) {
            this.energy = (long)((NBTTagFloat)energyTag).field_74750_a;
        } else if (energyTag instanceof NBTTagInt) {
            this.energy = ((NBTTagInt)energyTag).field_74748_a;
        } else if (energyTag instanceof NBTTagLong) {
            this.energy = ((NBTTagLong)energyTag).field_74753_a;
        }
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74772_a("energy", this.getEnergy());
        return nbt;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
        if (this.getEnergy() > capacity) {
            this.energy = capacity;
        }
    }

    public void setMaxTransfer(long maxTransfer) {
        this.setMaxReceive(maxTransfer);
        this.setMaxExtract(maxTransfer);
    }

    public void setMaxReceive(long maxReceive) {
        this.maxReceive = maxReceive;
    }

    public void setMaxExtract(long maxExtract) {
        this.maxExtract = maxExtract;
    }

    public long getMaxReceive() {
        return this.maxReceive;
    }

    public long getMaxExtract() {
        return this.maxExtract;
    }

    public void setEnergy(long energy) {
        this.energy = energy;
        if (this.getEnergy() > this.getEnergyCapacity()) {
            this.energy = this.getEnergyCapacity();
        } else if (this.getEnergy() < 0L) {
            this.energy = 0L;
        }
    }

    public void modifyEnergyStored(long energy) {
        this.setEnergy(this.getEmptySpace() + energy);
        if (this.getEnergy() > this.getEnergyCapacity()) {
            this.setEnergy(this.getEnergyCapacity());
        } else if (this.getEnergy() < 0L) {
            this.setEnergy(0L);
        }
    }

    public long receiveEnergy(long receive, boolean doReceive) {
        long energyReceived = Math.min(this.getEnergyCapacity() - this.getEnergy(), Math.min(this.getMaxReceive(), receive));
        if (doReceive) {
            this.lastEnergy = this.getEnergy();
            this.setEnergy(this.getEnergy() + energyReceived);
        }
        return energyReceived;
    }

    public long receiveEnergy(boolean doReceive) {
        return this.receiveEnergy(this.getMaxReceive(), doReceive);
    }

    public long receiveEnergy() {
        return this.receiveEnergy(true);
    }

    public long extractEnergy(long extract, boolean doExtract) {
        long energyExtracted = Math.min(this.getEnergy(), Math.min(this.getMaxExtract(), extract));
        if (doExtract) {
            this.lastEnergy = this.getEnergy();
            this.setEnergy(this.getEnergy() - energyExtracted);
        }
        return energyExtracted;
    }

    public long extractEnergy(boolean doExtract) {
        return this.extractEnergy(this.getMaxExtract(), doExtract);
    }

    public long extractEnergy() {
        return this.extractEnergy(true);
    }

    public boolean checkReceive(long receive) {
        return this.receiveEnergy(receive, false) >= receive;
    }

    public boolean checkReceive() {
        return this.checkReceive(this.getMaxReceive());
    }

    public boolean checkExtract(long extract) {
        return this.extractEnergy(extract, false) >= extract;
    }

    public boolean checkExtract() {
        return this.checkExtract(this.getMaxExtract());
    }

    public boolean isFull() {
        return this.getEnergy() >= this.getEnergyCapacity();
    }

    public boolean isEmpty() {
        return this.getEnergy() == 0L;
    }

    public long getLastEnergy() {
        return this.lastEnergy;
    }

    public boolean didEnergyStateChange() {
        return this.getLastEnergy() == 0L && this.getEnergy() > 0L || this.getLastEnergy() > 0L && this.getEnergy() == 0L;
    }

    public long getEmptySpace() {
        return this.getEnergyCapacity() - this.getEnergy();
    }

    public long getEnergy() {
        return this.energy;
    }

    public long getEnergyCapacity() {
        return this.capacity;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getEnergy() + "/" + this.getEnergyCapacity() + "]";
    }
}

