/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.api.vector;

import com.google.common.io.ByteArrayDataInput;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.api.vector.EulerAngle;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Quaternion;
import universalelectricity.api.vector.Vector2;

public class Vector3
implements Cloneable,
IVector3,
Comparable<IVector3> {
    public double x;
    public double y;
    public double z;

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3() {
        this(0.0, 0.0, 0.0);
    }

    @Deprecated
    public Vector3(Vector3 vector) {
        this(vector.x, vector.y, vector.z);
    }

    public Vector3(IVector3 vector) {
        this(vector.x(), vector.y(), vector.z());
    }

    public Vector3(double amount) {
        this(amount, amount, amount);
    }

    public Vector3(Entity par1) {
        this(par1.field_70165_t, par1.field_70163_u, par1.field_70161_v);
    }

    public Vector3(TileEntity par1) {
        this(par1.field_70329_l, par1.field_70330_m, par1.field_70327_n);
    }

    public Vector3(Vec3 par1) {
        this(par1.field_72450_a, par1.field_72448_b, par1.field_72449_c);
    }

    public Vector3(MovingObjectPosition par1) {
        this(par1.field_72311_b, par1.field_72312_c, par1.field_72309_d);
    }

    public Vector3(ChunkCoordinates par1) {
        this(par1.field_71574_a, par1.field_71572_b, par1.field_71573_c);
    }

    public Vector3(ForgeDirection direction) {
        this(direction.offsetX, direction.offsetY, direction.offsetZ);
    }

    public Vector3(NBTTagCompound nbt) {
        this(nbt.func_74769_h("x"), nbt.func_74769_h("y"), nbt.func_74769_h("z"));
    }

    public Vector3(ByteArrayDataInput data) {
        this(data.readDouble(), data.readDouble(), data.readDouble());
    }

    public Vector3(double yaw, double pitch) {
        this(new EulerAngle(yaw, pitch));
    }

    public static Vector3 fromCenter(Entity e) {
        return new Vector3(e.field_70165_t, e.field_70163_u - (double)e.field_70129_M + (double)(e.field_70131_O / 2.0f), e.field_70161_v);
    }

    public static Vector3 fromCenter(TileEntity e) {
        return new Vector3((double)e.field_70329_l + 0.5, (double)e.field_70330_m + 0.5, (double)e.field_70327_n + 0.5);
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public double z() {
        return this.z;
    }

    public int intX() {
        return (int)Math.floor(this.x);
    }

    public int intY() {
        return (int)Math.floor(this.y);
    }

    public int intZ() {
        return (int)Math.floor(this.z);
    }

    public float floatX() {
        return (float)this.x;
    }

    public float floatY() {
        return (float)this.y;
    }

    public float floatZ() {
        return (float)this.z;
    }

    public Vector3 clone() {
        return new Vector3(this.x(), this.y(), this.z());
    }

    public int getBlockID(IBlockAccess world) {
        return world.func_72798_a(this.intX(), this.intY(), this.intZ());
    }

    public int getBlockMetadata(IBlockAccess world) {
        return world.func_72805_g(this.intX(), this.intY(), this.intZ());
    }

    public TileEntity getTileEntity(IBlockAccess world) {
        return world.func_72796_p(this.intX(), this.intY(), this.intZ());
    }

    public boolean setBlock(World world, int id, int metadata, int notify) {
        return world.func_72832_d(this.intX(), this.intY(), this.intZ(), id, metadata, notify);
    }

    public boolean setBlock(World world, int id, int metadata) {
        return this.setBlock(world, id, metadata, 3);
    }

    public boolean setBlock(World world, int id) {
        return this.setBlock(world, id, 0);
    }

    public Vector2 toVector2() {
        return new Vector2(this.x, this.z);
    }

    public Vec3 toVec3() {
        return Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
    }

    public EulerAngle toAngle() {
        return new EulerAngle(Math.toDegrees(Math.atan2(this.x, this.z)), Math.toDegrees(-Math.atan2(this.y, Math.hypot(this.z, this.x))));
    }

    public EulerAngle toAngle(IVector3 target) {
        return this.clone().difference(target).toAngle();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74780_a("x", this.x);
        nbt.func_74780_a("y", this.y);
        nbt.func_74780_a("z", this.z);
        return nbt;
    }

    public ForgeDirection toForgeDirection() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (this.x != (double)direction.offsetX || this.y != (double)direction.offsetY || this.z != (double)direction.offsetZ) continue;
            return direction;
        }
        return ForgeDirection.UNKNOWN;
    }

    public double getMagnitude() {
        return Math.sqrt(this.getMagnitudeSquared());
    }

    public double getMagnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3 normalize() {
        double d = this.getMagnitude();
        if (d != 0.0) {
            this.scale(1.0 / d);
        }
        return this;
    }

    public static double distance(Vector3 vec1, IVector3 vec2) {
        return vec1.distance(vec2);
    }

    public static double distance(IVector3 vec1, IVector3 vec2) {
        return new Vector3(vec1).distance(vec2);
    }

    public double distance(double x, double y, double z) {
        Vector3 difference = this.clone().difference(x, y, z);
        return difference.getMagnitude();
    }

    public double distance(IVector3 compare) {
        return this.distance(compare.x(), compare.y(), compare.z());
    }

    public double distance(Entity entity) {
        return this.distance(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public Vector3 invert() {
        this.scale(-1.0);
        return this;
    }

    public Vector3 translate(ForgeDirection side, double amount) {
        return this.translate(new Vector3(side).scale(amount));
    }

    public Vector3 translate(ForgeDirection side) {
        return this.translate(side, 1.0);
    }

    @Deprecated
    public Vector3 modifyPositionFromSide(ForgeDirection side, double amount) {
        return this.translate(side, amount);
    }

    @Deprecated
    public Vector3 modifyPositionFromSide(ForgeDirection side) {
        return this.translate(side);
    }

    public Vector3 translate(IVector3 addition) {
        this.x += addition.x();
        this.y += addition.y();
        this.z += addition.z();
        return this;
    }

    public Vector3 translate(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vector3 translate(double addition) {
        this.x += addition;
        this.y += addition;
        this.z += addition;
        return this;
    }

    public static Vector3 translate(Vector3 first, IVector3 second) {
        return first.clone().translate(second);
    }

    public static Vector3 translate(Vector3 translate, double addition) {
        return translate.clone().translate(addition);
    }

    public Vector3 add(IVector3 amount) {
        return this.translate(amount);
    }

    public Vector3 add(double amount) {
        return this.translate(amount);
    }

    public Vector3 subtract(IVector3 amount) {
        return this.translate(-amount.x(), -amount.y(), -amount.z());
    }

    public Vector3 subtract(double amount) {
        return this.translate(-amount);
    }

    public Vector3 subtract(double x, double y, double z) {
        return this.difference(x, y, z);
    }

    public Vector3 difference(IVector3 amount) {
        return this.translate(-amount.x(), -amount.y(), -amount.z());
    }

    public Vector3 difference(double amount) {
        return this.translate(-amount);
    }

    public Vector3 difference(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vector3 scale(double amount) {
        this.x *= amount;
        this.y *= amount;
        this.z *= amount;
        return this;
    }

    public Vector3 scale(double x, double y, double z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Vector3 scale(Vector3 amount) {
        this.x *= amount.x;
        this.y *= amount.y;
        this.z *= amount.z;
        return this;
    }

    public static Vector3 scale(Vector3 vec, double amount) {
        return vec.scale(amount);
    }

    public static Vector3 scale(Vector3 vec, Vector3 amount) {
        return vec.scale(amount);
    }

    public Vector3 max(Vector3 other) {
        return new Vector3(Math.max(this.x, other.x), Math.max(this.y, other.y), Math.max(this.z, other.z));
    }

    public Vector3 min(Vector3 other) {
        return new Vector3(Math.min(this.x, other.x), Math.min(this.y, other.y), Math.min(this.z, other.z));
    }

    public Vector3 round() {
        return new Vector3(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    public Vector3 ceil() {
        return new Vector3(Math.ceil(this.x), Math.ceil(this.y), Math.ceil(this.z));
    }

    public Vector3 floor() {
        return new Vector3(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public Vector3 toRound() {
        this.x = Math.round(this.x);
        this.y = Math.round(this.y);
        this.z = Math.round(this.z);
        return this;
    }

    public Vector3 toCeil() {
        this.x = Math.ceil(this.x);
        this.y = Math.ceil(this.y);
        this.z = Math.ceil(this.z);
        return this;
    }

    public Vector3 toFloor() {
        this.x = Math.floor(this.x);
        this.y = Math.floor(this.y);
        this.z = Math.floor(this.z);
        return this;
    }

    public List<Entity> getEntitiesWithin(World worldObj, Class<? extends Entity> par1Class) {
        return worldObj.func_72872_a(par1Class, AxisAlignedBB.func_72330_a((double)this.intX(), (double)this.intY(), (double)this.intZ(), (double)(this.intX() + 1), (double)(this.intY() + 1), (double)(this.intZ() + 1)));
    }

    public Vector3 midPoint(Vector3 pos) {
        return new Vector3((this.x + pos.x) / 2.0, (this.y + pos.y) / 2.0, (this.z + pos.z) / 2.0);
    }

    public Vector3 toCrossProduct(Vector3 compare) {
        double newX = this.y * compare.z - this.z * compare.y;
        double newY = this.z * compare.x - this.x * compare.z;
        double newZ = this.x * compare.y - this.y * compare.x;
        this.x = newX;
        this.y = newY;
        this.z = newZ;
        return this;
    }

    public Vector3 crossProduct(Vector3 compare) {
        return this.clone().toCrossProduct(compare);
    }

    public Vector3 xCrossProduct() {
        return new Vector3(0.0, this.z, -this.y);
    }

    public Vector3 zCrossProduct() {
        return new Vector3(-this.y, this.x, 0.0);
    }

    public double dotProduct(Vector3 vec2) {
        return this.x * vec2.x + this.y * vec2.y + this.z * vec2.z;
    }

    public Vector3 getPerpendicular() {
        if (this.z == 0.0) {
            return this.zCrossProduct();
        }
        return this.xCrossProduct();
    }

    public boolean isZero() {
        return this.equals(Vector3.ZERO());
    }

    public Vector3 rotate(float angle, Vector3 axis) {
        return Vector3.translateMatrix(Vector3.getRotationMatrix(angle, axis), this);
    }

    public double[] getRotationMatrix(float angle) {
        double[] matrix = new double[16];
        Vector3 axis = this.clone().normalize();
        double x = axis.x;
        double y = axis.y;
        double z = axis.z;
        angle = (float)((double)angle * 0.0174532925);
        float cos = (float)Math.cos(angle);
        float ocos = 1.0f - cos;
        float sin = (float)Math.sin(angle);
        matrix[0] = x * x * (double)ocos + (double)cos;
        matrix[1] = y * x * (double)ocos + z * (double)sin;
        matrix[2] = x * z * (double)ocos - y * (double)sin;
        matrix[4] = x * y * (double)ocos - z * (double)sin;
        matrix[5] = y * y * (double)ocos + (double)cos;
        matrix[6] = y * z * (double)ocos + x * (double)sin;
        matrix[8] = x * z * (double)ocos + y * (double)sin;
        matrix[9] = y * z * (double)ocos - x * (double)sin;
        matrix[10] = z * z * (double)ocos + (double)cos;
        matrix[15] = 1.0;
        return matrix;
    }

    public static Vector3 translateMatrix(double[] matrix, Vector3 translation) {
        double x = translation.x * matrix[0] + translation.y * matrix[1] + translation.z * matrix[2] + matrix[3];
        double y = translation.x * matrix[4] + translation.y * matrix[5] + translation.z * matrix[6] + matrix[7];
        double z = translation.x * matrix[8] + translation.y * matrix[9] + translation.z * matrix[10] + matrix[11];
        translation.x = x;
        translation.y = y;
        translation.z = z;
        return translation;
    }

    public static double[] getRotationMatrix(float angle, Vector3 axis) {
        return axis.getRotationMatrix(angle);
    }

    @Deprecated
    public void rotate(double yaw, double pitch, double roll) {
        this.rotate(new EulerAngle(yaw, roll));
    }

    public void rotate(EulerAngle angle) {
        double yawRadians = angle.yawRadians();
        double pitchRadians = angle.pitchRadians();
        double rollRadians = angle.rollRadians();
        double x = this.x;
        double y = this.y;
        double z = this.z;
        this.x = x * Math.cos(yawRadians) * Math.cos(pitchRadians) + z * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) - Math.sin(yawRadians) * Math.cos(rollRadians)) + y * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) + Math.sin(yawRadians) * Math.sin(rollRadians));
        this.z = x * Math.sin(yawRadians) * Math.cos(pitchRadians) + z * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) + Math.cos(yawRadians) * Math.cos(rollRadians)) + y * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) - Math.cos(yawRadians) * Math.sin(rollRadians));
        this.y = -x * Math.sin(pitchRadians) + z * Math.cos(pitchRadians) * Math.sin(rollRadians) + y * Math.cos(pitchRadians) * Math.cos(rollRadians);
    }

    public void rotate(double yaw, double pitch) {
        this.rotate(new EulerAngle(yaw, pitch));
    }

    public void rotate(double yaw) {
        double yawRadians = Math.toRadians(yaw);
        double x = this.x;
        double z = this.z;
        if (yaw != 0.0) {
            this.x = x * Math.cos(yawRadians) - z * Math.sin(yawRadians);
            this.z = x * Math.sin(yawRadians) + z * Math.cos(yawRadians);
        }
    }

    public Vector3 rotate(Quaternion rotator) {
        rotator.rotate(this);
        return this;
    }

    @Deprecated
    public static Vector3 getDeltaPositionFromRotation(float rotationYaw, float rotationPitch) {
        return new Vector3(rotationYaw, rotationPitch);
    }

    public double getAngle(Vector3 vec2) {
        return Vector3.anglePreNorm(this.clone().normalize(), vec2.clone().normalize());
    }

    public static double getAngle(Vector3 vec1, Vector3 vec2) {
        return vec1.getAngle(vec2);
    }

    public double anglePreNorm(Vector3 vec2) {
        return Math.acos(this.dotProduct(vec2));
    }

    public static double anglePreNorm(Vector3 vec1, Vector3 vec2) {
        return Math.acos(vec1.clone().dotProduct(vec2));
    }

    public static Vector3 UP() {
        return new Vector3(0.0, 1.0, 0.0);
    }

    public static Vector3 DOWN() {
        return new Vector3(0.0, -1.0, 0.0);
    }

    public static Vector3 NORTH() {
        return new Vector3(0.0, 0.0, -1.0);
    }

    public static Vector3 SOUTH() {
        return new Vector3(0.0, 0.0, 1.0);
    }

    public static Vector3 WEST() {
        return new Vector3(-1.0, 0.0, 0.0);
    }

    public static Vector3 EAST() {
        return new Vector3(1.0, 0.0, 0.0);
    }

    public static Vector3 ZERO() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public static Vector3 CENTER() {
        return new Vector3(0.5, 0.5, 0.5);
    }

    public MovingObjectPosition rayTrace(World world, float rotationYaw, float rotationPitch, boolean collisionFlag, double reachDistance) {
        Vector3 lookVector = Vector3.getDeltaPositionFromRotation(rotationYaw, rotationPitch);
        Vector3 reachPoint = this.clone().translate(lookVector.clone().scale(reachDistance));
        return this.rayTrace(world, reachPoint, collisionFlag);
    }

    public MovingObjectPosition rayTrace(World world, Vector3 reachPoint, boolean collisionFlag) {
        MovingObjectPosition pickedBlock = this.rayTraceBlocks(world, reachPoint.clone(), collisionFlag);
        MovingObjectPosition pickedEntity = this.rayTraceEntities(world, reachPoint.clone());
        if (pickedBlock == null) {
            return pickedEntity;
        }
        if (pickedEntity == null) {
            return pickedBlock;
        }
        double dBlock = this.distance(new Vector3(pickedBlock.field_72307_f));
        double dEntity = this.distance(new Vector3(pickedEntity.field_72307_f));
        if (dEntity < dBlock) {
            return pickedEntity;
        }
        return pickedBlock;
    }

    public MovingObjectPosition rayTrace(World world, boolean collisionFlag, double reachDistance) {
        return this.rayTrace(world, 0.0f, 0.0f, collisionFlag, reachDistance);
    }

    public MovingObjectPosition rayTraceBlocks(World world, float rotationYaw, float rotationPitch, boolean collisionFlag, double reachDistance) {
        Vector3 lookVector = Vector3.getDeltaPositionFromRotation(rotationYaw, rotationPitch);
        Vector3 reachPoint = this.clone().translate(lookVector.clone().scale(reachDistance));
        return this.rayTraceBlocks(world, reachPoint, collisionFlag);
    }

    public MovingObjectPosition rayTraceBlocks(World world, Vector3 vec, boolean collisionFlag) {
        return world.func_72831_a(this.toVec3(), vec.toVec3(), collisionFlag, !collisionFlag);
    }

    @Deprecated
    public MovingObjectPosition rayTraceEntities(World world, float rotationYaw, float rotationPitch, boolean collisionFlag, double reachDistance) {
        return this.rayTraceEntities(world, rotationYaw, rotationPitch, reachDistance);
    }

    public MovingObjectPosition rayTraceEntities(World world, float rotationYaw, float rotationPitch, double reachDistance) {
        return this.rayTraceEntities(world, Vector3.getDeltaPositionFromRotation(rotationYaw, rotationPitch).scale(reachDistance));
    }

    public MovingObjectPosition rayTraceEntities(World world, Vector3 target) {
        MovingObjectPosition pickedEntity = null;
        Vec3 startingPosition = this.toVec3();
        Vec3 look = target.toVec3();
        double reachDistance = this.distance(target);
        double checkBorder = 1.1 * reachDistance;
        AxisAlignedBB boxToScan = AxisAlignedBB.func_72332_a().func_72299_a(-checkBorder, -checkBorder, -checkBorder, checkBorder, checkBorder, checkBorder).func_72317_d(this.x, this.y, this.z);
        List entitiesInBounds = world.func_72839_b(null, boxToScan);
        double closestEntity = reachDistance;
        if (entitiesInBounds == null || entitiesInBounds.isEmpty()) {
            return null;
        }
        for (Entity possibleHits : entitiesInBounds) {
            float border;
            AxisAlignedBB aabb;
            MovingObjectPosition hitMOP;
            if (possibleHits == null || !possibleHits.func_70067_L() || possibleHits.field_70121_D == null || (hitMOP = (aabb = possibleHits.field_70121_D.func_72314_b((double)(border = possibleHits.func_70111_Y()), (double)border, (double)border)).func_72327_a(startingPosition, target.toVec3())) == null) continue;
            if (aabb.func_72318_a(startingPosition)) {
                if (!(0.0 < closestEntity) && closestEntity != 0.0 || (pickedEntity = new MovingObjectPosition(possibleHits)) == null) continue;
                pickedEntity.field_72307_f = hitMOP.field_72307_f;
                closestEntity = 0.0;
                continue;
            }
            double distance = startingPosition.func_72438_d(hitMOP.field_72307_f);
            if (!(distance < closestEntity) && closestEntity != 0.0) continue;
            pickedEntity = new MovingObjectPosition(possibleHits);
            pickedEntity.field_72307_f = hitMOP.field_72307_f;
            closestEntity = distance;
        }
        return pickedEntity;
    }

    public MovingObjectPosition rayTraceEntities(World world, Entity target) {
        return this.rayTraceEntities(world, new Vector3(target));
    }

    public int hashCode() {
        long x = Double.doubleToLongBits(this.x);
        long y = Double.doubleToLongBits(this.y);
        long z = Double.doubleToLongBits(this.z);
        int hash = (int)(x ^ x >>> 32);
        hash = 31 * hash + (int)(y ^ y >>> 32);
        hash = 31 * hash + (int)(z ^ z >>> 32);
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof Vector3) {
            Vector3 vector3 = (Vector3)o;
            return this.x == vector3.x && this.y == vector3.y && this.z == vector3.z;
        }
        return false;
    }

    public String toString() {
        return "Vector3 [" + this.x + "," + this.y + "," + this.z + "]";
    }

    @Override
    public int compareTo(IVector3 o) {
        return (int)(Vector3.ZERO().distance(this) - Vector3.ZERO().distance(o));
    }
}

