/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core;

import buildcraft.api.power.IPowerReceptor;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import cpw.mods.fml.relauncher.Side;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.item.ISpecialElectricItem;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;
import net.minecraftforge.common.Configuration;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.CompatibilityType;
import universalelectricity.compatibility.ModuleUniversalElectricity;
import universalelectricity.core.CommonProxy;
import universalelectricity.core.asm.TemplateInjectionManager;
import universalelectricity.core.asm.UniversalTransformer;
import universalelectricity.core.asm.template.item.TemplateICItem;
import universalelectricity.core.asm.template.item.TemplateTEItem;
import universalelectricity.core.asm.template.tile.TemplateBCTile;
import universalelectricity.core.asm.template.tile.TemplateICTile;
import universalelectricity.core.asm.template.tile.TemplateTETile;
import universalelectricity.core.net.NetworkTickHandler;

@Mod(modid="UniversalElectricity", version="3.1.0", name="Universal Electricity", dependencies="before:ForgeMultipart")
@IFMLLoadingPlugin.TransformerExclusions(value={"universalelectricity.core.asm", "universalelectricity.core.asm.template"})
public class UELoader
implements IFMLLoadingPlugin,
IFMLCallHook {
    public static final String ID = "UniversalElectricity";
    public static final String NAME = "Universal Electricity";
    public static Configuration CONFIGURATION;
    @SidedProxy(clientSide="universalelectricity.core.ClientProxy", serverSide="universalelectricity.core.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Metadata(value="UniversalElectricity")
    public static ModMetadata metadata;
    public static final Logger LOGGER;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        CONFIGURATION = new Configuration(new File(Loader.instance().getConfigDir(), "UniversalElectricity.cfg"));
        CONFIGURATION.load();
        CompatibilityType.THERMAL_EXPANSION.reciprocal_ratio = CONFIGURATION.get("Compatibility", "Thermal Expansion Conversion Ratio", CompatibilityType.THERMAL_EXPANSION.reciprocal_ratio).getDouble(CompatibilityType.THERMAL_EXPANSION.reciprocal_ratio);
        CompatibilityType.INDUSTRIALCRAFT.reciprocal_ratio = CONFIGURATION.get("Compatibility", "IndustrialCraft Conversion Ratio", CompatibilityType.INDUSTRIALCRAFT.reciprocal_ratio).getDouble(CompatibilityType.INDUSTRIALCRAFT.reciprocal_ratio);
        CompatibilityType.BUILDCRAFT.reciprocal_ratio = CONFIGURATION.get("Compatibility", "BuildCraft Conversion Ratio", CompatibilityType.BUILDCRAFT.reciprocal_ratio).getDouble(CompatibilityType.BUILDCRAFT.reciprocal_ratio);
        CompatibilityType.THERMAL_EXPANSION.ratio = 1.0 / CompatibilityType.THERMAL_EXPANSION.reciprocal_ratio;
        CompatibilityType.INDUSTRIALCRAFT.ratio = 1.0 / CompatibilityType.INDUSTRIALCRAFT.reciprocal_ratio;
        CompatibilityType.BUILDCRAFT.ratio = 1.0 / CompatibilityType.BUILDCRAFT.reciprocal_ratio;
        CompatibilityModule.register(new ModuleUniversalElectricity());
        for (CompatibilityType compatibility : CompatibilityType.values()) {
            compatibility.isModuleEnabled = CONFIGURATION.get("Compatibility", "Load " + compatibility.moduleName + " Module", true).getBoolean(true);
            if (!compatibility.isModuleEnabled) continue;
            try {
                CompatibilityModule.register((CompatibilityModule)Class.forName("universalelectricity.compatibility.Module" + compatibility.moduleName).newInstance());
            }
            catch (Exception e) {
                System.out.println("[Universal Electricity] Failed to load module: " + compatibility.moduleName);
                e.printStackTrace();
            }
        }
        CONFIGURATION.save();
        TickRegistry.registerTickHandler((ITickHandler)NetworkTickHandler.INSTANCE, (Side)Side.SERVER);
        proxy.init();
        UELoader.metadata.modId = ID;
        UELoader.metadata.name = NAME;
        UELoader.metadata.description = "Universal Electricity is a Minecraft modding library that provides an easy, flexible energy framework and compatibility bridges between various energy systems in Minecraft.";
        UELoader.metadata.url = "http://www.universalelectricity.com/";
        UELoader.metadata.version = "3.1.0.101";
        UELoader.metadata.authorList = Arrays.asList("Calclavia", "DarkCow", "tgame14");
        UELoader.metadata.credits = "Please visit the website.";
        UELoader.metadata.autogenerated = false;
    }

    public String[] getASMTransformerClass() {
        return new String[]{UniversalTransformer.class.getName()};
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return UELoader.class.getName();
    }

    public void injectData(Map<String, Object> data) {
    }

    public String[] getLibraryRequestClass() {
        return null;
    }

    public Void call() throws Exception {
        String asmICTiles = System.getProperty("asmICTile");
        String asmTETiles = System.getProperty("asmTETile");
        String asmBCTiles = System.getProperty("asmBCTile");
        String diable = System.getProperty("asmUEDsiable");
        if (asmTETiles == null || asmTETiles.equalsIgnoreCase("true") || asmTETiles.equalsIgnoreCase("t")) {
            if (asmTETiles == null || asmTETiles.equalsIgnoreCase("true") || asmTETiles.equalsIgnoreCase("t")) {
                TemplateInjectionManager.registerTileTemplate(CompatibilityType.THERMAL_EXPANSION.moduleName, TemplateTETile.class, IEnergyHandler.class);
            }
            if (asmICTiles == null || asmICTiles.equalsIgnoreCase("true") || asmICTiles.equalsIgnoreCase("t")) {
                TemplateInjectionManager.registerTileTemplate(CompatibilityType.INDUSTRIALCRAFT.moduleName, TemplateICTile.class, IEnergySink.class, IEnergySource.class);
            }
            if (asmBCTiles == null || asmBCTiles.equalsIgnoreCase("true") || asmBCTiles.equalsIgnoreCase("t")) {
                TemplateInjectionManager.registerTileTemplate(CompatibilityType.BUILDCRAFT.moduleName, TemplateBCTile.class, IPowerReceptor.class);
            }
            TemplateInjectionManager.registerItemTemplate(CompatibilityType.THERMAL_EXPANSION.moduleName, TemplateTEItem.class, IEnergyContainerItem.class);
            TemplateInjectionManager.registerItemTemplate(CompatibilityType.INDUSTRIALCRAFT.moduleName, TemplateICItem.class, ISpecialElectricItem.class);
        }
        return null;
    }

    static {
        LOGGER = Logger.getLogger(NAME);
    }
}

