/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.asm;

import com.google.common.collect.HashBiMap;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import universalelectricity.api.CompatibilityType;
import universalelectricity.api.energy.IConductor;
import universalelectricity.api.energy.IEnergyInterface;
import universalelectricity.api.item.IEnergyItem;
import universalelectricity.core.asm.ASMHelper;
import universalelectricity.core.asm.TemplateInjectionManager;

public class UniversalTransformer
implements IClassTransformer {
    static LaunchClassLoader cl = (LaunchClassLoader)UniversalTransformer.class.getClassLoader();

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.startsWith("net.minecraft") || TemplateInjectionManager.tileTemplates.isEmpty()) {
            return bytes;
        }
        boolean changed = false;
        ClassNode cnode = ASMHelper.createClassNode(bytes);
        if (cnode != null && cnode.visibleAnnotations != null) {
            for (AnnotationNode nodes : cnode.visibleAnnotations) {
                if (!nodes.desc.equals("Luniversalelectricity/api/UniversalClass;")) continue;
                String flags = null;
                if (nodes.values != null && nodes.values.size() >= 2) {
                    flags = (String)nodes.values.get(1);
                }
                int transformationType = -1;
                if (cnode.interfaces.contains(IEnergyInterface.class.getName().replace(".", "/"))) {
                    transformationType = 0;
                } else if (cnode.interfaces.contains(IConductor.class.getName().replace(".", "/"))) {
                    transformationType = 1;
                } else if (cnode.interfaces.contains(IEnergyItem.class.getName().replace(".", "/"))) {
                    transformationType = 2;
                }
                if (transformationType == 0 || transformationType == 1) {
                    changed |= this.injectTemplate(cnode, flags, TemplateInjectionManager.tileTemplates);
                    break;
                }
                if (transformationType == 2) {
                    changed |= this.injectTemplate(cnode, flags, TemplateInjectionManager.itemTemplates);
                    break;
                }
                System.out.println("[Universal Electricity] Failed to inject class " + cnode.name + " due to missing required interfaces.");
                break;
            }
        }
        return changed ? ASMHelper.createBytes(cnode, 2) : bytes;
    }

    private boolean injectTemplate(ClassNode cnode, String flags, HashBiMap<String, TemplateInjectionManager.InjectionTemplate> templates) {
        boolean changed = false;
        if (flags == null || flags.equals("")) {
            for (TemplateInjectionManager.InjectionTemplate template : templates.values()) {
                if (template == null || !CompatibilityType.get((String)((String)templates.inverse().get((Object)template))).isModuleEnabled) continue;
                changed |= template.patch(cnode, false);
                System.out.println("[Universal Electricity] Injected " + template.className + " API into: " + cnode.name);
            }
        } else {
            String[] separatedFlags;
            for (String separated : separatedFlags = flags.split(";")) {
                TemplateInjectionManager.InjectionTemplate template;
                if (CompatibilityType.get(separated) == null || !CompatibilityType.get((String)separated).isModuleEnabled || (template = (TemplateInjectionManager.InjectionTemplate)templates.get((Object)separated)) == null) continue;
                changed |= template.patch(cnode, false);
                System.out.println("[Universal Electricity] Injected " + template.className + " API into: " + cnode.name);
            }
        }
        return changed;
    }
}

