/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.net;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.UniversalElectricity;
import universalelectricity.api.energy.EnergyNetworkLoader;
import universalelectricity.api.energy.IConductor;
import universalelectricity.api.energy.IEnergyNetwork;
import universalelectricity.api.net.NetworkEvent;
import universalelectricity.core.net.NetworkTickHandler;
import universalelectricity.core.net.NodeNetwork;

public class EnergyNetwork
extends NodeNetwork<IEnergyNetwork, IConductor, Object>
implements IEnergyNetwork {
    protected long energyBuffer;
    protected final HashMap<IConductor, Long> conductorBuffers = new HashMap();
    protected float resistance;
    protected long lastEnergyBuffer;
    protected long lastNetworkRequest = -1L;
    private long energyPerWire;
    protected final HashMap<Object, EnumSet<ForgeDirection>> handlerDirectionMap = new LinkedHashMap<Object, EnumSet<ForgeDirection>>();

    public EnergyNetwork() {
        super(IConductor.class);
        NetworkTickHandler.addNetwork(this);
    }

    @Override
    public void addConnector(IConductor connector) {
        connector.setNetwork(this);
        super.addConnector(connector);
    }

    @Override
    public void update() {
        Iterator it;
        long usableEnergy;
        long currentEnergy = usableEnergy = Math.max(this.energyBuffer - this.getEnergyLoss(), 0L);
        long perHandler = 0L;
        long perSide = 0L;
        int handlers = this.handlerDirectionMap.size();
        if (handlers > 0) {
            for (Map.Entry<Object, EnumSet<ForgeDirection>> entry : this.handlerDirectionMap.entrySet()) {
                perHandler = usableEnergy / (long)handlers + usableEnergy % (long)handlers;
                for (ForgeDirection direction : entry.getValue()) {
                    perSide = perHandler / (long)entry.getValue().size() + perHandler % (long)entry.getValue().size();
                    currentEnergy -= this.addEnergyToHandler(entry.getKey(), direction, perSide, true);
                }
                if (handlers <= 1) continue;
                --handlers;
            }
            this.lastEnergyBuffer = this.energyBuffer;
            if (usableEnergy != currentEnergy) {
                this.energyBuffer = Math.max(currentEnergy, 0L);
            }
        }
        long remainingBufferPerConductor = 0L;
        if (this.getConnectors().size() > 0) {
            remainingBufferPerConductor = this.energyBuffer / (long)this.getConnectors().size();
        }
        if ((it = this.getConnectors().iterator()) != null) {
            while (it.hasNext()) {
                this.conductorBuffers.put((IConductor)it.next(), remainingBufferPerConductor);
            }
        }
        this.lastNetworkRequest = -1L;
    }

    public long addEnergyToHandler(Object handler, ForgeDirection side, long energy, boolean doApply) {
        return CompatibilityModule.receiveEnergy(handler, side, energy, doApply);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public boolean continueUpdate() {
        return this.getConnectors().size() > 0 && this.energyBuffer > 0L;
    }

    @Override
    public long getRequest() {
        if (this.lastNetworkRequest == -1L) {
            this.lastNetworkRequest = 0L;
            if (this.getNodes().size() > 0) {
                for (Map.Entry<Object, EnumSet<ForgeDirection>> entry : this.handlerDirectionMap.entrySet()) {
                    if (entry.getValue() == null || entry.getValue() instanceof IConductor) continue;
                    for (ForgeDirection direction : entry.getValue()) {
                        this.lastNetworkRequest += Math.max(CompatibilityModule.receiveEnergy(entry.getKey(), direction, Long.MAX_VALUE, false), 0L);
                    }
                }
            }
        }
        return this.lastNetworkRequest;
    }

    @Override
    public boolean isValidConnector(Object node) {
        return node instanceof IConductor;
    }

    @Override
    public float getResistance() {
        return this.resistance;
    }

    @Override
    public void reconstruct() {
        if (this.getConnectors().size() > 0) {
            this.getNodes().clear();
            this.handlerDirectionMap.clear();
            this.resistance = 0.0f;
            Iterator it = this.getConnectors().iterator();
            while (it.hasNext()) {
                IConductor conductor = (IConductor)it.next();
                if (conductor != null) {
                    this.reconstructConnector(conductor);
                    continue;
                }
                it.remove();
            }
            if (this.getNodes().size() > 0) {
                NetworkTickHandler.addNetwork(this);
            }
        }
    }

    @Override
    protected void reconstructConnector(IConductor conductor) {
        conductor.setNetwork(this);
        if (conductor.getConnections() != null) {
            for (int i = 0; i < conductor.getConnections().length; ++i) {
                this.reconstructHandler(conductor, conductor.getConnections()[i], ForgeDirection.getOrientation((int)i).getOpposite());
            }
        }
        this.resistance += conductor.getResistance();
    }

    protected void reconstructHandler(IConductor conductor, Object obj, ForgeDirection side) {
        if (obj != null && !(obj instanceof IConductor) && CompatibilityModule.canConnect(obj, side, conductor)) {
            EnumSet<ForgeDirection> set = this.handlerDirectionMap.get(obj);
            if (set == null) {
                set = EnumSet.noneOf(ForgeDirection.class);
            }
            this.getNodes().add(obj);
            set.add(side);
            this.handlerDirectionMap.put(obj, set);
        }
    }

    @Override
    public IEnergyNetwork merge(IEnergyNetwork network) {
        IEnergyNetwork newNetwork = super.merge(network);
        if (newNetwork != null) {
            long newBuffer = this.getBuffer() + ((EnergyNetwork)network).getBuffer();
            newNetwork.setBuffer(newBuffer);
            return newNetwork;
        }
        return null;
    }

    @Override
    public void split(IConductor splitPoint) {
        this.energyPerWire = this.energyBuffer / (long)Math.max(this.getConnectors().size() - 1, 1);
        super.split(splitPoint);
    }

    @Override
    public void onSplit(IEnergyNetwork newNetwork) {
        newNetwork.setBuffer(newNetwork.getBuffer() + this.energyPerWire);
        this.energyBuffer -= this.energyPerWire;
    }

    @Override
    public Class getConnectorClass() {
        return IConductor.class;
    }

    @Override
    public IEnergyNetwork newInstance() {
        return EnergyNetworkLoader.getNewNetwork(new IConductor[0]);
    }

    @Override
    public long produce(IConductor conductor, ForgeDirection from, long amount, boolean doReceive) {
        long energyReceived = 0L;
        long conductorBuffer = 0L;
        if (amount > 0L) {
            NetworkEvent.EnergyProduceEvent evt = new NetworkEvent.EnergyProduceEvent(this, conductor, amount, doReceive);
            MinecraftForge.EVENT_BUS.post((Event)evt);
            if (!evt.isCanceled()) {
                if (this.conductorBuffers.containsKey(conductor)) {
                    conductorBuffer = this.conductorBuffers.get(conductor);
                }
                energyReceived = Math.min(Math.max(conductor.getCurrentCapacity() * this.getVoltage() - conductorBuffer, 0L), amount);
                if (doReceive && energyReceived > 0L) {
                    this.energyBuffer += energyReceived;
                    this.conductorBuffers.put(conductor, conductorBuffer += energyReceived);
                }
            }
        }
        if (this.energyBuffer > 0L) {
            NetworkTickHandler.addNetwork(this);
        }
        return energyReceived;
    }

    protected long getEnergyLoss() {
        long amperage = this.getBuffer() / this.getVoltage();
        return (long)((float)(amperage * amperage) * this.resistance);
    }

    public long getVoltage() {
        return UniversalElectricity.DEFAULT_VOLTAGE;
    }

    @Override
    public long getBuffer() {
        return this.energyBuffer;
    }

    @Override
    public void setBuffer(long newBuffer) {
        this.energyBuffer = newBuffer;
    }

    @Override
    public long getLastBuffer() {
        return this.lastEnergyBuffer;
    }

    @Override
    public long getBufferOf(IConductor conductor) {
        if (this.conductorBuffers != null && this.conductorBuffers.containsKey(conductor) && this.conductorBuffers.get(conductor) != null) {
            return this.conductorBuffers.get(conductor);
        }
        return 0L;
    }

    @Override
    public void setBufferFor(IConductor conductor, long buffer) {
        this.conductorBuffers.put(conductor, buffer);
        this.energyBuffer += buffer;
    }
}

