/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.net;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import universalelectricity.api.net.IConnector;
import universalelectricity.api.net.INetwork;
import universalelectricity.core.net.ConnectionPathfinder;

public abstract class Network<N extends INetwork, C extends IConnector>
implements INetwork<N, C> {
    private final Set<C> connectors = Collections.newSetFromMap(new WeakHashMap());
    private final Class<? extends C> connectorType;

    public Network(Class<? extends C> type) {
        this.connectorType = type;
    }

    public abstract N newInstance();

    @Override
    public void addConnector(C connector) {
        this.connectors.add(connector);
    }

    @Override
    public void removeConnector(C connector) {
        this.connectors.remove(connector);
    }

    @Override
    public Set<C> getConnectors() {
        return this.connectors;
    }

    @Override
    public void reconstruct() {
        Iterator<C> it = new HashSet<C>(this.getConnectors()).iterator();
        while (it.hasNext()) {
            IConnector connector = (IConnector)it.next();
            if (this.isValidConnector(connector)) {
                this.reconstructConnector(connector);
                continue;
            }
            it.remove();
        }
    }

    public boolean isValidConnector(Object node) {
        return this.connectorType.isAssignableFrom(node.getClass());
    }

    public C getFirstConnector() {
        Iterator<C> i$ = this.getConnectors().iterator();
        if (i$.hasNext()) {
            IConnector node = (IConnector)i$.next();
            return (C)node;
        }
        return null;
    }

    protected void reconstructConnector(C node) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public N merge(N network) {
        if (network != null && network.getClass().isAssignableFrom(this.getClass()) && network != this) {
            Set<C> set = this.getConnectors();
            synchronized (set) {
                N newNetwork = this.newInstance();
                newNetwork.getConnectors().addAll(this.getConnectors());
                newNetwork.getConnectors().addAll(network.getConnectors());
                network.getConnectors().clear();
                this.getConnectors().clear();
                newNetwork.reconstruct();
                return newNetwork;
            }
        }
        return null;
    }

    @Override
    public void split(C splitPoint) {
        Object[] connectedBlocks = this.getConnectionsFor(splitPoint);
        this.removeConnector(splitPoint);
        for (int i = 0; i < connectedBlocks.length; ++i) {
            Object connectedA = connectedBlocks[i];
            if (connectedA == null || !this.isValidConnector(connectedA)) continue;
            for (int ii = 0; ii < connectedBlocks.length; ++ii) {
                Object connectedB = connectedBlocks[ii];
                if (connectedB == null || connectedA == connectedB || !this.isValidConnector(connectedB)) continue;
                ConnectionPathfinder finder = new ConnectionPathfinder(this.getConnectorClass(), (IConnector)connectedB, new IConnector[]{splitPoint});
                finder.findNodes((IConnector)connectedA);
                if (finder.results.size() > 0) continue;
                try {
                    N newNetwork = this.newInstance();
                    for (IConnector node : finder.closedSet) {
                        if (node == splitPoint) continue;
                        newNetwork.addConnector((IConnector)node);
                        this.removeConnector(node);
                        this.onSplit(newNetwork);
                    }
                    newNetwork.reconstruct();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.reconstruct();
    }

    public Object[] getConnectionsFor(C connector) {
        return connector.getConnections();
    }

    @Override
    public void split(C connectorA, C connectorB) {
        if (connectorA != null && connectorB != null) {
            ConnectionPathfinder finder = new ConnectionPathfinder(this.getConnectorClass(), connectorB, new IConnector[0]);
            finder.findNodes(connectorA);
            if (finder.results.size() <= 0) {
                N newNetwork = this.newInstance();
                for (IConnector node : finder.closedSet) {
                    newNetwork.addConnector((IConnector)node);
                }
                newNetwork.reconstruct();
            }
        }
        this.reconstruct();
    }

    public void onSplit(N newNetwork) {
    }

    public Class getConnectorClass() {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.hashCode() + ", Connectors: " + this.connectors.size() + "]";
    }
}

