/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.net;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.api.net.IUpdate;

public class NetworkTickHandler
implements ITickHandler {
    public static final NetworkTickHandler INSTANCE = new NetworkTickHandler();
    private final Set<IUpdate> updaters = Collections.newSetFromMap(new WeakHashMap());
    private final Queue<Event> queuedEvents = new ConcurrentLinkedQueue<Event>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addNetwork(IUpdate updater) {
        Set<IUpdate> set = NetworkTickHandler.INSTANCE.updaters;
        synchronized (set) {
            NetworkTickHandler.INSTANCE.updaters.add(updater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void queueEvent(Event event) {
        Queue<Event> queue = NetworkTickHandler.INSTANCE.queuedEvents;
        synchronized (queue) {
            NetworkTickHandler.INSTANCE.queuedEvents.add(event);
        }
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        Collection<IUpdate> collection = this.updaters;
        synchronized (collection) {
            Set removeUpdaters = Collections.newSetFromMap(new WeakHashMap());
            Iterator<IUpdate> updaterIt = new HashSet<IUpdate>(this.updaters).iterator();
            try {
                while (updaterIt.hasNext()) {
                    IUpdate updater = updaterIt.next();
                    if (updater.canUpdate()) {
                        updater.update();
                    }
                    if (updater.continueUpdate()) continue;
                    removeUpdaters.add(updater);
                }
                this.updaters.removeAll(removeUpdaters);
            }
            catch (Exception e) {
                System.out.println(this.getLabel() + ": Failed while tcking updater. This is a bug! Clearing all tickers for self repair.");
                this.updaters.clear();
                e.printStackTrace();
            }
        }
        collection = this.queuedEvents;
        synchronized (collection) {
            while (!this.queuedEvents.isEmpty()) {
                MinecraftForge.EVENT_BUS.post(this.queuedEvents.poll());
            }
        }
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.SERVER);
    }

    public String getLabel() {
        return "Universal Electricity Ticker";
    }
}

