/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.util.landmine.behavior;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import tconstruct.util.landmine.Helper;
import tconstruct.util.landmine.behavior.BehaviorBlockThrow;
import tconstruct.util.landmine.behavior.BehaviorDefault;
import tconstruct.util.landmine.behavior.BehaviorDummy;
import tconstruct.util.landmine.behavior.BehaviorExplosive;
import tconstruct.util.landmine.behavior.BehaviorFirecharge;
import tconstruct.util.landmine.behavior.BehaviorFirework;
import tconstruct.util.landmine.behavior.BehaviorPotion;
import tconstruct.util.landmine.behavior.BehaviorPreventExplode;
import tconstruct.util.landmine.behavior.BehaviorProjectile;
import tconstruct.util.landmine.behavior.BehaviorShears;
import tconstruct.util.landmine.behavior.BehaviorSpawnEgg;

public abstract class Behavior {
    public static HashMap<Integer, Behavior> behaviorsListItems = new HashMap();
    public static HashMap<Integer, Behavior> behaviorsListBlocks = new HashMap();
    protected static Behavior defaultBehavior;
    public static Behavior dummy;
    public static Behavior utilityMode;
    public static Behavior explosive;
    public static Behavior firework;
    public static Behavior blockThrow;
    public static Behavior potion;
    public static Behavior fireball;
    public static Behavior spawn;
    public static Behavior shoot;
    public static Behavior shear;

    public static void registerBuiltInBehaviors() {
        defaultBehavior = new BehaviorDefault();
        Behavior.addBehavior(new ItemStack(Item.field_77669_D), dummy);
        Behavior.addBehavior(new ItemStack(Item.field_77767_aC), utilityMode);
        Behavior.addBehavior(new ItemStack(Block.field_72069_aq), blockThrow);
        Behavior.addBehavior(new ItemStack(Item.field_77677_M), explosive);
        Behavior.addBehavior(new ItemStack(Block.field_72091_am), explosive);
        Behavior.addBehavior(new ItemStack(Item.field_92104_bU), firework);
        Behavior.addBehavior(new ItemStack((Item)Item.field_77726_bs), potion);
        Behavior.addBehavior(new ItemStack(Item.field_77811_bE), fireball);
        Behavior.addBehavior(new ItemStack(Item.field_77815_bC), spawn);
        Behavior.addBehavior(new ItemStack(Item.field_77704_l), shoot);
        Behavior.addBehavior(new ItemStack(Item.field_77768_aD), shoot);
        Behavior.addBehavior(new ItemStack(Item.field_77730_bn), shoot);
        Behavior.addBehavior(new ItemStack((Item)Item.field_77745_be), shear);
        for (int i = 1; i < Block.field_71973_m.length; ++i) {
            if (Block.field_71973_m[i] == null || !Block.field_71973_m[i].func_71926_d() || !Block.field_71973_m[i].func_71886_c() || Block.field_71973_m[i] instanceof ITileEntityProvider || behaviorsListBlocks.containsKey(new ItemStack(Block.field_71973_m[i]))) continue;
            Behavior.addBehavior(new ItemStack(Block.field_71973_m[i]), blockThrow);
        }
    }

    public static Behavior getBehaviorFromStack(ItemStack par1ItemStack) {
        if (par1ItemStack == null) {
            return null;
        }
        if (par1ItemStack.func_77973_b() instanceof ItemBlock) {
            if (!behaviorsListBlocks.isEmpty()) {
                return behaviorsListBlocks.get(par1ItemStack.field_77993_c);
            }
            return null;
        }
        if (!behaviorsListItems.isEmpty()) {
            return behaviorsListItems.get(par1ItemStack.field_77993_c);
        }
        return null;
    }

    public static Behavior getDefaulBehavior() {
        return defaultBehavior;
    }

    public static void addBehavior(ItemStack par1ItemStack, Behavior par2Behavior) {
        if (par1ItemStack.func_77973_b() instanceof ItemBlock) {
            if (!behaviorsListBlocks.containsKey(par1ItemStack.field_77993_c)) {
                behaviorsListBlocks.put(par1ItemStack.field_77993_c, par2Behavior);
            }
        } else if (!behaviorsListItems.containsKey(par1ItemStack.field_77993_c)) {
            behaviorsListItems.put(par1ItemStack.field_77993_c, par2Behavior);
        }
    }

    public abstract void executeLogic(World var1, int var2, int var3, int var4, ItemStack var5, Entity var6, boolean var7);

    public int getStackLimit(ItemStack par1ItemStack) {
        return 1;
    }

    public void getInformation(ItemStack par1ItemStack, List par2List) {
    }

    public boolean effectStacks() {
        return true;
    }

    public EnumFacing getFacing(World par1World, int par2, int par3, int par4) {
        ForgeDirection dir = Helper.convertMetaToForgeOrientation(par1World.func_72805_g(par2, par3, par4));
        switch (dir) {
            case DOWN: {
                return EnumFacing.UP;
            }
            case UP: {
                return EnumFacing.DOWN;
            }
            case WEST: {
                return EnumFacing.WEST;
            }
            case EAST: {
                return EnumFacing.EAST;
            }
            case SOUTH: {
                return EnumFacing.NORTH;
            }
            case NORTH: {
                return EnumFacing.SOUTH;
            }
        }
        return EnumFacing.UP;
    }

    public boolean doesBehaviorPreventRemovalOfBlock(ItemStack par1ItemStack) {
        return false;
    }

    public boolean isOffensive(ItemStack par1ItemStack) {
        return true;
    }

    public boolean isBehaviorExchangableWithOffensive(ItemStack par1ItemStack) {
        return true;
    }

    public boolean shouldItemBeRemoved(ItemStack par1ItemStack, boolean willBlockGetRemoved) {
        return true;
    }

    public static final int arrayIndexOfStack(ArrayList<ItemStack> stacks, ItemStack item) {
        Iterator<ItemStack> i1 = stacks.iterator();
        int index = 0;
        while (i1.hasNext()) {
            ItemStack stack = i1.next();
            if (stack.func_77969_a(item)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static final boolean arrayContainsEqualStack(ArrayList<ItemStack> stacks, ItemStack item) {
        for (ItemStack stack : stacks) {
            if (!stack.func_77969_a(item)) continue;
            return true;
        }
        return false;
    }

    public boolean overridesDefault() {
        return false;
    }

    static {
        dummy = new BehaviorDummy();
        utilityMode = new BehaviorPreventExplode();
        explosive = new BehaviorExplosive();
        firework = new BehaviorFirework();
        blockThrow = new BehaviorBlockThrow();
        potion = new BehaviorPotion();
        fireball = new BehaviorFirecharge();
        spawn = new BehaviorSpawnEgg();
        shoot = new BehaviorProjectile();
        shear = new BehaviorShears();
    }
}

