/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.ItemPanelStack;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.Widget;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import java.util.ArrayList;
import java.util.List;

public class ItemPanel
extends Widget {
    public static ArrayList<ItemPanelObject> visibleitems = new ArrayList();
    public ye draggedStack;
    public int mouseDownSlot = -1;
    private int marginLeft;
    private int marginTop;
    private int rows;
    private int columns;
    private boolean[] validSlotMap;
    private int firstIndex;
    private int itemsPerPage;
    private int page;
    private int numPages;

    @Override
    public void resize() {
        this.marginLeft = this.x + this.width % 18 / 2;
        this.marginTop = this.y + this.height % 18 / 2;
        this.columns = this.width / 18;
        this.rows = this.height / 18;
        this.calculatePage();
        this.updateValidSlots();
    }

    private void calculatePage() {
        this.numPages = this.itemsPerPage == 0 ? 0 : (int)Math.ceil((float)visibleitems.size() / (float)this.itemsPerPage);
        this.page = this.numPages == 0 ? 0 : this.firstIndex / this.itemsPerPage + 1;
    }

    private void updateValidSlots() {
        awy gui = NEIClientUtils.getGuiContainer();
        this.validSlotMap = new boolean[this.rows * this.columns];
        this.itemsPerPage = 0;
        int i = 0;
        while (i < this.validSlotMap.length) {
            if (this.slotValid(gui, i)) {
                this.validSlotMap[i] = true;
                ++this.itemsPerPage;
            }
            ++i;
        }
    }

    private boolean slotValid(awy gui, int i) {
        Rectangle4i rect = this.getSlotRect(i);
        for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
            if (!handler.hideItemPanelSlot(gui, rect.x, rect.y, rect.w, rect.h)) continue;
            return false;
        }
        return true;
    }

    public Rectangle4i getSlotRect(int i) {
        return this.getSlotRect(i / this.columns, i % this.columns);
    }

    public Rectangle4i getSlotRect(int row, int column) {
        return new Rectangle4i(this.marginLeft + column * 18, this.marginTop + row * 18, 18, 18);
    }

    @Override
    public void draw(int mousex, int mousey) {
        if (this.itemsPerPage == 0) {
            return;
        }
        int index = this.firstIndex;
        int i = 0;
        while (i < this.rows * this.columns && index < visibleitems.size()) {
            if (this.validSlotMap[i]) {
                Rectangle4i rect = this.getSlotRect(i);
                if (rect.contains(mousex, mousey)) {
                    GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)-296397483);
                }
                visibleitems.get(index).draw(rect.x, rect.y);
                ++index;
            }
            ++i;
        }
    }

    @Override
    public void postDraw(int mousex, int mousey) {
        if (this.draggedStack != null) {
            GuiContainerManager.drawItems.f += 100.0f;
            GuiContainerManager.drawItem(mousex - 8, mousey - 8, this.draggedStack);
            GuiContainerManager.drawItems.f -= 100.0f;
        }
    }

    @Override
    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        if (this.mouseDownSlot >= 0 && this.draggedStack == null && NEIClientUtils.getHeldItem() == null) {
            ItemPanelSlot mouseOverSlot = this.getSlotMouseOver(mousex, mousey);
            ye stack = new ItemPanelSlot(this.mouseDownSlot).getItemStack();
            if (stack != null && (mouseOverSlot == null || mouseOverSlot.slotIndex != this.mouseDownSlot || heldTime > 500L)) {
                int amount = NEIClientConfig.getItemQuantity();
                if (amount == 0) {
                    amount = stack.e();
                }
                this.draggedStack = NEIServerUtils.copyStack(stack, amount);
            }
        }
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        if (this.handleDraggedClick(mousex, mousey, button)) {
            return true;
        }
        if (NEIClientUtils.getHeldItem() != null) {
            if (NEIClientConfig.canPerformAction("delete") && NEIClientConfig.canPerformAction("item")) {
                if (button == 1) {
                    NEIClientUtils.decreaseSlotStack(-999);
                } else {
                    NEIClientUtils.deleteHeldItem();
                }
            } else {
                NEIClientUtils.dropHeldItem();
            }
            return true;
        }
        ItemPanelSlot hoverSlot = this.getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null) {
            if (button == 2) {
                ye stack = hoverSlot.getItemStack();
                if (stack != null) {
                    int amount = NEIClientConfig.getItemQuantity();
                    if (amount == 0) {
                        amount = stack.e();
                    }
                    this.draggedStack = NEIServerUtils.copyStack(stack, amount);
                }
            } else {
                this.mouseDownSlot = hoverSlot.slotIndex;
            }
            return true;
        }
        return false;
    }

    private boolean handleDraggedClick(int mousex, int mousey, int button) {
        if (this.draggedStack == null) {
            return false;
        }
        awy gui = NEIClientUtils.getGuiContainer();
        boolean handled = false;
        for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
            if (!handler.handleDragNDrop(gui, mousex, mousey, this.draggedStack, button)) continue;
            handled = true;
            if (this.draggedStack.b != 0) continue;
            this.draggedStack = null;
            return true;
        }
        if (handled) {
            return true;
        }
        we overSlot = gui.c(mousex, mousey);
        if (overSlot != null && overSlot.a(this.draggedStack)) {
            if (NEIClientConfig.canPerformAction("item")) {
                int total;
                int add;
                int contents = overSlot.e() ? overSlot.d().b : 0;
                int n = add = button == 0 ? this.draggedStack.b : 1;
                if (overSlot.e() && !NEIServerUtils.areStacksSameType(this.draggedStack, overSlot.d())) {
                    contents = 0;
                }
                if ((total = Math.min(contents + add, Math.min(overSlot.a(), this.draggedStack.e()))) > contents) {
                    NEIClientUtils.setSlotContents(overSlot.g, NEIServerUtils.copyStack(this.draggedStack, total), true);
                    NEICPH.sendSpawnItem(NEIServerUtils.copyStack(this.draggedStack, total), false, false);
                    this.draggedStack.b -= total - contents;
                }
                if (this.draggedStack.b == 0) {
                    this.draggedStack = null;
                }
            } else {
                this.draggedStack = null;
            }
        } else if (mousex < gui.p || mousey < gui.q || mousex >= gui.p + gui.c || mousey >= gui.q + gui.d) {
            this.draggedStack = null;
        }
        return true;
    }

    @Override
    public boolean handleClickExt(int mousex, int mousey, int button) {
        return this.handleDraggedClick(mousex, mousey, button);
    }

    @Override
    public void mouseUp(int mousex, int mousey, int button) {
        ItemPanelSlot hoverSlot = this.getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null && hoverSlot.slotIndex == this.mouseDownSlot && hoverSlot.getItemStack() != null && this.draggedStack == null) {
            ye item = hoverSlot.getItemStack();
            if (NEIController.manager.window instanceof GuiRecipe || !NEIClientConfig.canPerformAction("item")) {
                if (button == 0) {
                    GuiCraftingRecipe.openRecipeGui("item", item);
                } else if (button == 1) {
                    GuiUsageRecipe.openRecipeGui("item", item);
                }
                this.draggedStack = null;
                this.mouseDownSlot = -1;
                return;
            }
            NEIClientUtils.cheatItem(item, button, -1);
        }
        this.mouseDownSlot = -1;
    }

    @Override
    public boolean onMouseWheel(int i, int mousex, int mousey) {
        if (!this.contains(mousex, mousey)) {
            return false;
        }
        this.scroll(-i);
        return true;
    }

    @Override
    public boolean handleKeyPress(int keyID, char keyChar) {
        if (keyID == NEIClientConfig.getKeyBinding("gui.next")) {
            this.scroll(1);
            return true;
        }
        if (keyID == NEIClientConfig.getKeyBinding("gui.prev")) {
            this.scroll(-1);
            return true;
        }
        return false;
    }

    @Override
    public ye getStackMouseOver(int mousex, int mousey) {
        ItemPanelSlot slot = this.getSlotMouseOver(mousex, mousey);
        return slot == null ? null : slot.getItemStack();
    }

    public ItemPanelSlot getSlotMouseOver(int mousex, int mousey) {
        int index = this.firstIndex;
        int i = 0;
        while (i < this.rows * this.columns && index < visibleitems.size()) {
            if (this.validSlotMap[i]) {
                if (this.getSlotRect(i).contains(mousex, mousey)) {
                    return new ItemPanelSlot(index);
                }
                ++index;
            }
            ++i;
        }
        return null;
    }

    @Override
    public List<String> handleTooltip(int mx, int my, List<String> tooltip) {
        if (this.getSlotMouseOver(mx, my) == null) {
            return tooltip;
        }
        return this.getSlotMouseOver((int)mx, (int)my).contents.handleTooltip(tooltip);
    }

    public void scroll(int i) {
        if (this.itemsPerPage != 0) {
            int oldIndex = this.firstIndex;
            this.firstIndex += i * this.itemsPerPage;
            if (this.firstIndex > visibleitems.size()) {
                this.firstIndex = 0;
            }
            if (this.firstIndex < 0) {
                this.firstIndex = oldIndex > 0 ? 0 : (visibleitems.size() - 1) / this.itemsPerPage * this.itemsPerPage;
            }
            this.calculatePage();
        }
    }

    public int getPage() {
        return this.page;
    }

    public int getNumPages() {
        return this.numPages;
    }

    public static interface ItemPanelObject {
        public void draw(int var1, int var2);

        public List<String> handleTooltip(List<String> var1);
    }

    public class ItemPanelSlot {
        public ItemPanelObject contents;
        public int slotIndex;

        public ItemPanelSlot(int index) {
            this.contents = visibleitems.get(index);
            this.slotIndex = index;
        }

        public ye getItemStack() {
            return this.contents instanceof ItemPanelStack ? ((ItemPanelStack)this.contents).item : null;
        }
    }
}

