/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.lib.config.ConfigTag;
import codechicken.lib.lang.LangUtil;
import codechicken.nei.config.ConfigSet;
import codechicken.nei.config.GuiOptionList;
import codechicken.nei.config.OptionList;
import java.util.List;

public abstract class Option {
    public GuiOptionList.OptionScrollSlot slot;
    public String namespace = null;
    public final String name;
    public OptionList parent;

    public Option(String name) {
        this.name = name;
    }

    public String fullName() {
        return this.namespaced(this.name);
    }

    public String configName() {
        return this.fullName().substring(this.configBase().fullName().length() + 1);
    }

    public String namespaced(String name) {
        return this.namespace == null ? name : String.valueOf(this.namespace) + "." + name;
    }

    public String translateN(String s, Object ... args) {
        return LangUtil.translateG((String)this.namespaced(s), (Object[])args);
    }

    public ConfigSet globalConfigSet() {
        return this.parent.globalConfigSet();
    }

    public ConfigSet worldConfigSet() {
        return this.parent.worldConfigSet();
    }

    public OptionList configBase() {
        return this.parent.configBase();
    }

    public boolean worldSpecific() {
        return this.worldSpecific(this.configName());
    }

    public boolean worldSpecific(String s) {
        return this.worldConfigSet().config.containsTag(s);
    }

    public ConfigSet configSet() {
        return this.worldConfig() ? this.worldConfigSet() : this.globalConfigSet();
    }

    public ConfigTag renderTag() {
        return this.renderTag(this.configName());
    }

    public ConfigTag renderTag(String s) {
        return (this.worldConfig() && this.worldSpecific((String)s) ? this.worldConfigSet() : this.globalConfigSet()).config.getTag(s);
    }

    public ConfigTag getTag() {
        return this.getTag(this.configName());
    }

    public ConfigTag getTag(String s) {
        return this.configSet().config.getTag(s);
    }

    public boolean worldConfig() {
        return this.slot.getGui().worldConfig();
    }

    public boolean renderDefault() {
        return this.renderDefault(this.configName());
    }

    public boolean renderDefault(String s) {
        return this.worldConfig() && !this.worldSpecific(s);
    }

    public void useGlobal() {
        this.useGlobal(this.configName());
    }

    public void useGlobal(String s) {
        if (this.worldConfig()) {
            this.worldConfigSet().config.removeTag(s);
        }
    }

    public void copyGlobal() {
        this.copyGlobal(this.configName());
    }

    public void copyGlobal(String s) {
        if (this.worldConfig()) {
            this.worldConfigSet().config.getTag(s).setValue(this.globalConfigSet().config.getTag(s).getValue());
        }
    }

    public void onAdded(GuiOptionList.OptionScrollSlot slot) {
        this.slot = slot;
    }

    public void onAdded(OptionList list) {
        this.parent = list;
    }

    public void onMouseClicked(int mousex, int mousey, int button) {
    }

    public void mouseClicked(int mousex, int mousey, int button) {
    }

    public void update() {
    }

    public void draw(int mousex, int mousey, float frame) {
    }

    public void keyTyped(char c, int keycode) {
    }

    public List<String> handleTooltip(int mousex, int mousey, List<String> currenttip) {
        return currenttip;
    }

    public boolean showWorldSelector() {
        return true;
    }

    public void copyGlobals() {
        this.copyGlobal();
    }

    public void useGlobals() {
        this.useGlobal();
    }

    public boolean hasWorldOverride() {
        return this.worldSpecific();
    }
}

