/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.core.Profiler;
import codechicken.core.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ProfilerRecipeHandler
implements ICraftingHandler,
IUsageHandler {
    private static Profiler profiler = new Profiler();
    private boolean crafting;

    public static Profiler getProfiler() {
        profiler.clear();
        return profiler;
    }

    public ProfilerRecipeHandler(boolean crafting) {
        this.crafting = crafting;
    }

    @Override
    public String getRecipeName() {
        return NEIClientUtils.translate("recipe.profiler." + (this.crafting ? "crafting" : "usage"), new Object[0]);
    }

    @Override
    public int numRecipes() {
        if (!NEIClientConfig.getBooleanSetting("inventory.profileRecipes")) {
            return 0;
        }
        return (int)Math.ceil((double)((this.crafting ? GuiCraftingRecipe.craftinghandlers.size() : GuiUsageRecipe.usagehandlers.size()) - 1) / 6.0);
    }

    @Override
    public void drawBackground(int recipe) {
    }

    @Override
    public void drawForeground(int recipe) {
        List results = profiler.getResults();
        Iterator it = results.iterator();
        while (it.hasNext()) {
            if (!((Profiler.ProfilerResult)it.next()).name.equals(this.getRecipeName())) continue;
            it.remove();
        }
        Collections.sort(results, new Comparator<Profiler.ProfilerResult>(){

            @Override
            public int compare(Profiler.ProfilerResult o1, Profiler.ProfilerResult o2) {
                return o1.time < o2.time ? 1 : -1;
            }
        });
        int i = recipe * 6;
        while (i < results.size() && i < (recipe + 1) * 6) {
            Profiler.ProfilerResult r = (Profiler.ProfilerResult)results.get(i);
            int y = i % 6 * 20 + 6;
            GuiDraw.drawString((String)r.name, (int)8, (int)y, (int)-8355712, (boolean)false);
            DecimalFormat format = new DecimalFormat("0.00");
            String s = String.valueOf(format.format(r.fraction * 100.0)) + "%";
            s = r.time < 1000000L ? String.valueOf(s) + " (" + r.time / 1000L + "us)" : String.valueOf(s) + " (" + r.time / 1000000L + "ms)";
            GuiDraw.drawString((String)s, (int)(156 - GuiDraw.getStringWidth((String)s)), (int)(y + 10), (int)-12566464, (boolean)false);
            ++i;
        }
    }

    public ArrayList<PositionedStack> getIngredientStacks(int recipe) {
        return new ArrayList<PositionedStack>();
    }

    public ArrayList<PositionedStack> getOtherStacks(int recipetype) {
        return new ArrayList<PositionedStack>();
    }

    @Override
    public PositionedStack getResultStack(int recipe) {
        return null;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public boolean hasOverlay(awy gui, uy container, int recipe) {
        return false;
    }

    @Override
    public IRecipeOverlayRenderer getOverlayRenderer(awy gui, int recipe) {
        return null;
    }

    @Override
    public IOverlayHandler getOverlayHandler(awy gui, int recipe) {
        return null;
    }

    @Override
    public int recipiesPerPage() {
        return 1;
    }

    @Override
    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        return currenttip;
    }

    @Override
    public List<String> handleItemTooltip(GuiRecipe gui, ye stack, List<String> currenttip, int recipe) {
        return currenttip;
    }

    @Override
    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        return false;
    }

    @Override
    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        return false;
    }

    @Override
    public IUsageHandler getUsageHandler(String inputId, Object ... ingredients) {
        return this;
    }

    @Override
    public ICraftingHandler getRecipeHandler(String outputId, Object ... results) {
        return this;
    }
}

