/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.device;

import cofh.entity.PlayerFake;
import cofh.network.ITileInfoPacketHandler;
import cofh.network.Payload;
import cofh.render.IconRegistry;
import cofh.util.BlockHelper;
import cofh.util.CoreUtils;
import cofh.util.ServerHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.TileReconfigurableInventory;
import thermalexpansion.block.device.BlockDevice;
import thermalexpansion.core.TEProps;

public class TileActivator
extends TileReconfigurableInventory
implements ISidedInventory,
ITileInfoPacketHandler {
    protected static int guiId;
    public static final int[] SIDE_TEX;
    public static final int[] SLOTS;
    public static final byte GUI_BUTTON = 0;
    public boolean leftClick = false;
    public byte tickSlot = 0;
    public boolean actsSneaking = false;
    public byte angle = 1;
    PlayerFake myFakePlayer;
    boolean needsWorld = true;
    int slotTracker = 0;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileActivator.class, (String)"cofh.thermalexpansion.Activator");
        guiId = ThermalExpansion.proxy.registerGui("Activator", "device", true);
    }

    public TileActivator() {
        this.inventory = new ItemStack[9];
    }

    public int getBlockID() {
        return TEBlocks.blockDevice.field_71990_ca;
    }

    public String getName() {
        return "tile.thermalexpansion.device." + BlockDevice.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return BlockDevice.Types.ACTIVATOR.ordinal();
    }

    public boolean openGui(EntityPlayer player) {
        player.openGui((Object)ThermalExpansion.instance, guiId, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public boolean sendRedstoneUpdates() {
        return true;
    }

    @Override
    public void onRedstoneUpdate() {
        if (!this.redstoneControlOrDisable() && !this.needsWorld && this.myFakePlayer.field_71074_e != null) {
            this.myFakePlayer.func_71034_by();
        } else {
            int[] coords = BlockHelper.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)this.facing);
            int BlockID = this.field_70331_k.func_72798_a(coords[0], coords[1], coords[2]);
            if (BlockID <= 0 || Block.field_71973_m[BlockID] != null && Block.field_71973_m[BlockID].isAirBlock(this.field_70331_k, coords[0], coords[1], coords[2])) {
                this.doDeploy();
            }
        }
    }

    public void func_70316_g() {
        if (ServerHelper.isServerWorld((World)this.field_70331_k)) {
            if (this.field_70331_k.func_82737_E() % 16L == 0L && this.redstoneControlOrDisable()) {
                this.doDeploy();
            } else if (!this.needsWorld) {
                if (this.leftClick && this.myFakePlayer.field_71134_c.field_73094_o > -1) {
                    int tickSlot = this.getNextStackIndex();
                    this.myFakePlayer.field_71134_c.func_73075_a();
                    if (this.myFakePlayer.field_71134_c.field_73094_o >= 9) {
                        this.simLeftClick((EntityPlayer)this.myFakePlayer, this.func_70301_a(tickSlot), this.facing);
                    }
                } else if (!this.leftClick && this.myFakePlayer.field_71074_e != null) {
                    this.myFakePlayer.tickItemInUse(this.func_70301_a(this.getNextStackIndex()));
                }
            }
        }
    }

    public void doDeploy() {
        int tickSlot = this.getNextStackIndex();
        ItemStack theStack = this.func_70301_a(tickSlot);
        this.updateFakePlayer(tickSlot);
        if (this.leftClick) {
            this.simLeftClick((EntityPlayer)this.myFakePlayer, theStack, this.facing);
        } else {
            int[] coords = BlockHelper.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)this.facing);
            this.simRightClick((EntityPlayer)this.myFakePlayer, theStack, coords[0], coords[1], coords[2], 1);
        }
        if (theStack != null && theStack.field_77994_a <= 0) {
            this.func_70299_a(tickSlot, null);
        }
        this.checkItemsUpdated();
    }

    public void checkItemsUpdated() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, this.myFakePlayer.field_71071_by.field_70462_a[i]);
            if (this.inventory[i] == null || this.inventory[i].field_77994_a > 0) continue;
            this.inventory[i] = null;
        }
    }

    public int getNextStackIndex() {
        if (!this.needsWorld) {
            if (this.leftClick && this.myFakePlayer.field_71134_c.field_73094_o > -1 || this.myFakePlayer.field_71074_e != null) {
                return this.slotTracker;
            }
            if (this.tickSlot == 0) {
                return this.incrementTracker();
            }
            if (this.tickSlot == 1) {
                return this.getRandomStackIndex();
            }
            return 0;
        }
        return 0;
    }

    public int getRandomStackIndex() {
        int i = -1;
        for (int k = 0; k < this.func_70302_i_(); ++k) {
            if (this.func_70301_a(k) == null || CoreUtils.rand.nextInt(2) != 0) continue;
            i = k;
        }
        return i == -1 ? this.incrementTracker() : i;
    }

    public int incrementTracker() {
        int k;
        ++this.slotTracker;
        this.slotTracker %= this.func_70302_i_();
        for (k = this.slotTracker; k < this.func_70302_i_(); ++k) {
            if (this.inventory[k] == null) continue;
            this.slotTracker = k;
            return this.slotTracker;
        }
        for (k = 0; k < this.slotTracker; ++k) {
            if (this.inventory[k] == null) continue;
            this.slotTracker = k;
            return this.slotTracker;
        }
        this.slotTracker = 0;
        return this.slotTracker;
    }

    public void updateFakePlayer(int tickSlot) {
        float yaw;
        if (this.needsWorld) {
            this.myFakePlayer = new PlayerFake(this.field_70331_k);
            this.needsWorld = false;
        }
        this.myFakePlayer.field_71071_by.field_70462_a = new ItemStack[36];
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.myFakePlayer.field_71071_by.field_70462_a[i] = this.func_70301_a(i);
        }
        double x = (double)this.field_70329_l + 0.5;
        double y = (double)this.field_70330_m - 1.1;
        double z = (double)this.field_70327_n + 0.5;
        float pitch = this.angle == 0 ? 45.0f : (this.angle == 1 ? 0.0f : -45.0f);
        switch (this.facing) {
            case 0: {
                pitch = this.angle == 0 ? -90.0f : (this.angle == 1 ? 0.0f : 90.0f);
                yaw = 0.0f;
                y -= 0.51;
                break;
            }
            case 1: {
                pitch = this.angle == 0 ? 90.0f : (this.angle == 1 ? 0.0f : -90.0f);
                yaw = 0.0f;
                y += 1.51;
                break;
            }
            case 2: {
                yaw = 180.0f;
                z -= 0.51;
                y += 0.5;
                break;
            }
            case 3: {
                yaw = 0.0f;
                z += 0.51;
                y += 0.5;
                break;
            }
            case 4: {
                yaw = 90.0f;
                x -= 0.51;
                y += 0.5;
                break;
            }
            default: {
                yaw = -90.0f;
                x += 0.51;
                y += 0.5;
            }
        }
        this.myFakePlayer.func_70080_a(x, y, z, yaw, pitch);
        this.myFakePlayer.isSneaking = this.actsSneaking;
        this.myFakePlayer.field_70129_M = -1.1f;
        this.myFakePlayer.setItemInHand(tickSlot);
        this.myFakePlayer.func_70071_h_();
    }

    public boolean simLeftClick(EntityPlayer thePlayer, ItemStack deployingStack, int side) {
        int[] coords = BlockHelper.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)this.facing);
        int blockID = this.field_70331_k.func_72798_a(coords[0], coords[1], coords[2]);
        if (blockID != 0) {
            if (this.myFakePlayer.field_71134_c.field_73094_o == -1) {
                this.myFakePlayer.field_71134_c.func_73074_a(coords[0], coords[1], coords[2], this.facing ^ 1);
            } else if (this.myFakePlayer.field_71134_c.field_73094_o >= 9) {
                this.myFakePlayer.field_71134_c.func_73082_a(coords[0], coords[1], coords[2]);
                this.myFakePlayer.field_71134_c.field_73094_o = -1;
                if (deployingStack != null) {
                    deployingStack.func_77941_a(this.field_70331_k, blockID, coords[0], coords[1], coords[2], (EntityPlayer)this.myFakePlayer);
                }
            }
        } else {
            this.myFakePlayer.field_71134_c.field_73094_o = -1;
            List entities = this.field_70331_k.func_72872_a(Entity.class, BlockHelper.getAdjacentAABBForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)this.facing));
            if (entities.size() == 0) {
                return false;
            }
            thePlayer.func_71059_n((Entity)entities.get(entities.size() > 1 ? CoreUtils.rand.nextInt(entities.size() - 1) : 0));
        }
        return true;
    }

    public void simRightClick(EntityPlayer thePlayer, ItemStack deployingStack, int blockX, int blockY, int blockZ, int side) {
        if (thePlayer.field_71074_e == null && !this.simRightClick2(thePlayer, deployingStack, blockX, blockY, blockZ, side) && deployingStack != null) {
            List entities = this.field_70331_k.func_72872_a(Entity.class, BlockHelper.getAdjacentAABBForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)this.facing));
            if (entities.size() > 0 && thePlayer.func_70998_m((Entity)entities.get(entities.size() > 1 ? CoreUtils.rand.nextInt(entities.size() - 1) : 0))) {
                return;
            }
            ItemStack theResult = deployingStack.func_77957_a(this.field_70331_k, thePlayer);
            thePlayer.field_71071_by.func_70299_a(this.myFakePlayer.field_71071_by.field_70461_c, theResult.field_77994_a <= 0 ? null : theResult);
        }
    }

    public boolean simRightClick2(EntityPlayer thePlayer, ItemStack deployingStack, int blockX, int blockY, int blockZ, int side) {
        int BlockID;
        boolean isAir;
        int offsetY;
        float f = 0.5f;
        float f1 = 0.5f;
        float f2 = 0.5f;
        int n = offsetY = this.facing == 1 ? 1 : -1;
        if (this.facing > 1) {
            if (this.angle == 0) {
                --blockY;
            }
            if (this.angle == 2) {
                ++blockY;
            }
        }
        boolean bl = isAir = (BlockID = this.field_70331_k.func_72798_a(blockX, blockY, blockZ)) > 0 && Block.field_71973_m[BlockID] != null ? Block.field_71973_m[BlockID].isAirBlock(this.field_70331_k, blockX, blockY, blockZ) : true;
        if (deployingStack != null && deployingStack.func_77973_b() != null && deployingStack.func_77973_b().onItemUseFirst(deployingStack, thePlayer, this.field_70331_k, blockX, blockY, blockZ, side, f, f1, f2)) {
            return true;
        }
        if ((!thePlayer.func_70093_af() || thePlayer.func_70694_bm() == null) && BlockID > 0 && Block.field_71973_m[BlockID].func_71903_a(this.field_70331_k, blockX, blockY, blockZ, thePlayer, side, f, f1, f2)) {
            return true;
        }
        if (deployingStack == null) {
            return false;
        }
        if (deployingStack.func_77973_b() instanceof ItemBlock ? !deployingStack.func_77943_a(thePlayer, this.field_70331_k, blockX, blockY + offsetY, blockZ, this.facing != 1 ? 1 : 0, f, f1, f2) && (isAir ? !deployingStack.func_77943_a(thePlayer, this.field_70331_k, blockX, blockY, blockZ, this.facing != 1 ? 1 : 0, f, f1, f2) : !deployingStack.func_77943_a(thePlayer, this.field_70331_k, blockX, blockY, blockZ, 0, f, f1, f2)) : (isAir ? !deployingStack.func_77943_a(thePlayer, this.field_70331_k, blockX, blockY, blockZ, this.facing != 1 ? 1 : 0, f, f1, f2) && !deployingStack.func_77943_a(thePlayer, this.field_70331_k, blockX, blockY + offsetY, blockZ, this.facing != 1 ? 1 : 0, f, f1, f2) : !deployingStack.func_77943_a(thePlayer, this.field_70331_k, blockX, blockY, blockZ, 0, f, f1, f2) && !deployingStack.func_77943_a(thePlayer, this.field_70331_k, blockX, blockY + offsetY, blockZ, this.facing != 1 ? 1 : 0, f, f1, f2))) {
            return false;
        }
        if (deployingStack.field_77994_a <= 0) {
            MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(thePlayer, deployingStack));
            thePlayer.field_71071_by.func_70299_a(this.myFakePlayer.field_71071_by.field_70461_c, null);
        }
        return true;
    }

    @Override
    public Payload getDescriptionPayload() {
        Payload payload = super.getDescriptionPayload();
        payload.addBool(this.actsSneaking);
        payload.addBool(this.leftClick);
        payload.addByte(this.tickSlot);
        payload.addByte(this.angle);
        return payload;
    }

    @Override
    public void handleTilePacket(Payload payload) {
        super.handleTilePacket(payload);
        this.actsSneaking = payload.getBool();
        this.leftClick = payload.getBool();
        this.tickSlot = payload.getByte();
        this.angle = payload.getByte();
    }

    public void handleTileInfoPacket(Payload payload, NetHandler handler) {
        byte type = payload.getByte();
        if (type == 0) {
            this.leftClick = payload.getBool();
            this.actsSneaking = payload.getBool();
            this.tickSlot = payload.getByte();
            this.angle = payload.getByte();
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.actsSneaking = nbt.func_74767_n("Sneaking");
        this.leftClick = nbt.func_74767_n("LeftClick");
        this.tickSlot = nbt.func_74771_c("TickSlotB");
        if (nbt.func_74764_b("TickSlot")) {
            this.tickSlot = nbt.func_74767_n("TickSlot") ? (byte)0 : 1;
        }
        this.angle = nbt.func_74771_c("Angle");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74757_a("Sneaking", this.actsSneaking);
        nbt.func_74757_a("LeftClick", this.leftClick);
        nbt.func_74774_a("TickSlotB", this.tickSlot);
        nbt.func_74774_a("Angle", this.angle);
    }

    @Override
    public boolean allowYAxisFacing() {
        return true;
    }

    @Override
    public boolean setFacing(int side) {
        if (side < 0 || side > 5) {
            return false;
        }
        this.facing = (byte)side;
        this.sideCache[this.facing ^ 1] = 2;
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockID());
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    @Override
    public int getNumConfig(int side) {
        return 3;
    }

    @Override
    public Icon getBlockTexture(int side, int pass) {
        if (pass == 0) {
            return side != this.facing ? IconRegistry.getIcon((String)"DeviceSide") : (this.redstoneControlOrDisable() ? IconRegistry.getIcon((String)"DeviceActive_", (int)this.getType()) : IconRegistry.getIcon((String)"DeviceFace_", (int)this.getType()));
        }
        if (side < 6) {
            return IconRegistry.getIcon((String)TEProps.textureSelection, (int)SIDE_TEX[this.sideCache[side]]);
        }
        return IconRegistry.getIcon((String)"DeviceSide");
    }

    public int[] func_94128_d(int side) {
        return this.sideCache[side] != 0 ? SLOTS : TEProps.EMPTY_INVENTORY;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.sideCache[side] == 1;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return this.sideCache[side] == 2;
    }

    static {
        SIDE_TEX = new int[]{0, 1, 4};
        SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }
}

