/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.device;

import cofh.api.tileentity.ISecureTile;
import cofh.api.tileentity.ISidedBlockTexture;
import cofh.network.ITileInfoPacketHandler;
import cofh.network.ITilePacketHandler;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cofh.render.IconRegistry;
import cofh.util.InventoryHelper;
import cofh.util.ItemHelper;
import cofh.util.ServerHelper;
import cofh.util.StringHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileInventory;
import thermalexpansion.block.device.BlockDevice;
import thermalexpansion.core.TEProps;
import thermalexpansion.item.SchematicHelper;

public class TileWorkbench
extends TileInventory
implements ISecureTile,
ISidedInventory,
ITilePacketHandler,
ITileInfoPacketHandler,
ISidedBlockTexture {
    protected static int guiId;
    public static boolean enableSecurity;
    String owner = "[None]";
    private ISecureTile.AccessMode access = ISecureTile.AccessMode.PUBLIC;
    public int selectedSchematic = 0;
    public boolean[] missingItem = new boolean[]{false, false, false, false, false, false, false, false, false};
    public boolean canAccess = true;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileWorkbench.class, (String)"cofh.thermalexpansion.Workbench");
        guiId = ThermalExpansion.proxy.registerGui("Workbench", "device", true);
    }

    public static void configure() {
        String comment = "Enable this to allow for Machinist Workbenches to be secure inventories. (Default: true)";
        enableSecurity = ThermalExpansion.config.get("block.security", "Workbench.Secure", enableSecurity, comment);
    }

    public TileWorkbench() {
        this.inventory = new ItemStack[30];
    }

    public boolean canUpdate() {
        return false;
    }

    public String getName() {
        return "tile.thermalexpansion.device." + BlockDevice.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return BlockDevice.Types.WORKBENCH.ordinal();
    }

    public boolean openGui(EntityPlayer player) {
        if (this.canPlayerAccess(player.field_71092_bJ)) {
            player.openGui((Object)ThermalExpansion.instance, guiId, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return true;
        }
        if (ServerHelper.isServerWorld((World)this.field_70331_k)) {
            player.func_71035_c(StringHelper.localize((String)"message.cofh.secure1") + " " + this.owner + "! " + StringHelper.localize((String)"message.cofh.secure2"));
        }
        return true;
    }

    public boolean createItem(boolean doCreate, ItemStack output) {
        ItemStack[] invCopy = InventoryHelper.cloneInventory((ItemStack[])this.inventory);
        boolean found = false;
        for (int i = 0; i < 9; ++i) {
            ItemStack recipeSlot = this.func_70301_a(i + this.getMatrixOffset());
            String recipeOre = OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)recipeSlot));
            if (recipeSlot == null) continue;
            for (int j = 0; j < this.func_70302_i_(); ++j) {
                if (invCopy[j] == null || !ItemHelper.craftingEquivalent((ItemStack)invCopy[j], (ItemStack)recipeSlot, (String)recipeOre, (ItemStack)output)) continue;
                this.inventory[i + this.getMatrixOffset()] = ItemHelper.cloneStack((ItemStack)invCopy[j], (int)1);
                --invCopy[j].field_77994_a;
                if (invCopy[j].func_77973_b().func_77634_r()) {
                    ItemStack containerStack = invCopy[j].func_77973_b().getContainerItemStack(invCopy[j]);
                    if (containerStack.func_77984_f() && containerStack.func_77960_j() > containerStack.func_77958_k()) {
                        containerStack = null;
                    }
                    if (!(containerStack == null || invCopy[j].func_77973_b().func_77630_h(invCopy[j]) && InventoryHelper.addItemStackToInventory((ItemStack[])invCopy, (ItemStack)containerStack, (int)2))) {
                        if (invCopy[j].field_77994_a <= 0) {
                            invCopy[j] = containerStack;
                            if (containerStack.field_77994_a <= 0) {
                                invCopy[j].field_77994_a = 1;
                            }
                        } else {
                            return false;
                        }
                    }
                }
                if (invCopy[j].field_77994_a <= 0) {
                    invCopy[j] = null;
                }
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            found = false;
        }
        if (doCreate) {
            this.inventory = invCopy;
        }
        return true;
    }

    public boolean createItemClient(boolean doCreate, ItemStack output) {
        ItemStack[] invCopy = InventoryHelper.cloneInventory((ItemStack[])this.inventory);
        boolean found = false;
        boolean masterFound = true;
        this.missingItem = new boolean[]{false, false, false, false, false, false, false, false, false};
        for (int i = 0; i < 9; ++i) {
            ItemStack recipeSlot = this.func_70301_a(i + this.getMatrixOffset());
            String recipeOre = OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)recipeSlot));
            if (recipeSlot == null) continue;
            for (int j = 0; j < this.func_70302_i_(); ++j) {
                if (invCopy[j] == null || !ItemHelper.craftingEquivalent((ItemStack)invCopy[j], (ItemStack)recipeSlot, (String)recipeOre, (ItemStack)output)) continue;
                this.inventory[i + this.getMatrixOffset()] = ItemHelper.cloneStack((ItemStack)invCopy[j], (int)1);
                --invCopy[j].field_77994_a;
                if (invCopy[j].func_77973_b().func_77634_r()) {
                    ItemStack containerStack = invCopy[j].func_77973_b().getContainerItemStack(invCopy[j]);
                    if (containerStack.func_77984_f() && containerStack.func_77960_j() > containerStack.func_77958_k()) {
                        containerStack = null;
                    }
                    if (!(containerStack == null || invCopy[j].func_77973_b().func_77630_h(invCopy[j]) && InventoryHelper.addItemStackToInventory((ItemStack[])invCopy, (ItemStack)containerStack, (int)2))) {
                        if (invCopy[j].field_77994_a <= 0) {
                            invCopy[j] = containerStack;
                            if (containerStack.field_77994_a <= 0) {
                                invCopy[j].field_77994_a = 1;
                            }
                        } else {
                            return false;
                        }
                    }
                }
                if (invCopy[j].field_77994_a <= 0) {
                    invCopy[j] = null;
                }
                found = true;
                break;
            }
            if (!found) {
                masterFound = false;
                this.missingItem[i] = true;
            }
            found = false;
        }
        if (!masterFound) {
            return false;
        }
        if (doCreate) {
            this.inventory = invCopy;
        }
        return true;
    }

    public int getCurrentSchematicSlot() {
        return 18 + this.selectedSchematic;
    }

    public int getMatrixOffset() {
        return 21;
    }

    public void setCurrentSchematicSlot(int slotIndex) {
        this.selectedSchematic = slotIndex - 18;
    }

    public void clearCraftingGrid() {
        for (int i = 0; i < 9; ++i) {
            this.inventory[this.getMatrixOffset() + i] = null;
        }
        PacketUtils.sendToServer((Packet)Payload.getInfoPayload((TileEntity)this).addByte(PacketInfoID.CLEAR_GRID.ordinal()).getPacket());
    }

    public void setCraftingGrid() {
        for (int i = 0; i < 9; ++i) {
            this.inventory[this.getMatrixOffset() + i] = SchematicHelper.getSchematicSlot(this.func_70301_a(this.getCurrentSchematicSlot()), i);
        }
        PacketUtils.sendToServer((Packet)Payload.getInfoPayload((TileEntity)this).addByte(PacketInfoID.SET_GRID.ordinal()).getPacket());
    }

    @Override
    public Payload getDescriptionPayload() {
        Payload payload = super.getDescriptionPayload();
        payload.addByte((byte)this.access.ordinal());
        payload.addByte(this.selectedSchematic);
        payload.addString(this.owner);
        return payload;
    }

    @Override
    public void handleTilePacket(Payload payload) {
        super.handleTilePacket(payload);
        this.access = ISecureTile.AccessMode.values()[payload.getByte()];
        this.selectedSchematic = payload.getByte();
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            this.owner = payload.getString();
        } else {
            payload.getString();
        }
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockID());
    }

    public void handleTileInfoPacket(Payload payload, NetHandler handler) {
        byte type = payload.getByte();
        if (type == PacketInfoID.CLEAR_GRID.ordinal()) {
            for (int i = 0; i < 9; ++i) {
                this.inventory[this.getMatrixOffset() + i] = null;
                if (handler.getPlayer().field_71070_bA == null) continue;
                handler.getPlayer().field_71070_bA.func_75130_a(null);
            }
        } else if (type == PacketInfoID.SET_GRID.ordinal()) {
            for (int i = 0; i < 9; ++i) {
                this.inventory[this.getMatrixOffset() + i] = SchematicHelper.getSchematicSlot(this.func_70301_a(this.getCurrentSchematicSlot()), i);
                if (handler.getPlayer().field_71070_bA == null) continue;
                handler.getPlayer().field_71070_bA.func_75130_a(null);
            }
        } else if (type == PacketInfoID.NEI_SUP.ordinal()) {
            byte slot;
            for (int i = 0; i < 9; ++i) {
                this.inventory[this.getMatrixOffset() + i] = null;
            }
            while ((slot = payload.getByte()) >= 0) {
                this.inventory[slot + this.getMatrixOffset()] = payload.getItemStack();
            }
            Container container = handler.getPlayer().field_71070_bA;
            if (container != null) {
                ((ICrafting)handler.getPlayer()).func_71110_a(container, container.func_75138_a());
                container.func_75130_a(null);
            }
        }
    }

    public void receiveGuiNetworkData(int i, int j) {
        this.canAccess = j != 0;
    }

    public void sendGuiNetworkData(Container container, ICrafting player) {
        int access = 0;
        if (this.canPlayerAccess(((EntityPlayer)player).field_71092_bJ)) {
            access = 1;
        }
        player.func_71112_a(container, 0, access);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.access = ISecureTile.AccessMode.values()[nbt.func_74771_c("Access")];
        this.owner = nbt.func_74779_i("Owner");
        this.selectedSchematic = nbt.func_74771_c("Mode");
        if (!enableSecurity) {
            this.access = ISecureTile.AccessMode.PUBLIC;
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74774_a("Access", (byte)this.access.ordinal());
        nbt.func_74778_a("Owner", this.owner);
        nbt.func_74774_a("Mode", (byte)this.selectedSchematic);
    }

    @Override
    public int func_70302_i_() {
        return this.inventory.length - 9;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public int[] func_94128_d(int side) {
        return TEProps.EMPTY_INVENTORY;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return false;
    }

    public boolean setAccess(ISecureTile.AccessMode access) {
        this.access = access;
        this.sendUpdatePacket(Side.SERVER);
        return true;
    }

    public ISecureTile.AccessMode getAccess() {
        return this.access;
    }

    public boolean setOwnerName(String name) {
        if (this.owner.equals("[None]")) {
            this.owner = name;
            return true;
        }
        return false;
    }

    public String getOwnerName() {
        return this.owner;
    }

    public Icon getBlockTexture(int side, int pass) {
        if (side == 0) {
            return IconRegistry.getIcon((String)"WorkbenchBottom");
        }
        if (side == 1) {
            return IconRegistry.getIcon((String)"WorkbenchTop");
        }
        return IconRegistry.getIcon((String)"WorkbenchSide");
    }

    static {
        enableSecurity = true;
        TileWorkbench.configure();
    }

    public static enum PacketInfoID {
        CLEAR_GRID,
        SET_GRID,
        NEI_SUP;

    }
}

