/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.dynamo;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyStorage;
import cofh.api.tileentity.IEnergyInfo;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.network.ITileInfoPacketHandler;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cofh.util.BlockHelper;
import cofh.util.EnergyHelper;
import cofh.util.ServerHelper;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.TileRSInventory;
import thermalexpansion.block.conduit.energy.TileConduitEnergy;
import thermalexpansion.block.dynamo.BlockDynamo;
import thermalexpansion.core.TEProps;

public abstract class TileDynamoBase
extends TileRSInventory
implements ITileInfoPacketHandler,
IReconfigurableFacing,
ISidedInventory,
IEnergyHandler,
IEnergyInfo {
    protected static final int[] guiIds = new int[BlockDynamo.Types.values().length];
    protected static final DynamoConfig defaultConfig = new DynamoConfig();
    protected static final int MAX_FLUID = 4000;
    protected static final int[] SLOTS = new int[]{0};
    DynamoConfig config = new DynamoConfig(defaultConfig);
    EnergyStorage energyStorage;
    boolean cached = false;
    IEnergyHandler adjacentHandler = null;
    byte facing = 1;
    boolean isActive;
    int fuelRF;
    int compareTracker;

    public TileDynamoBase() {
        this.energyStorage = new EnergyStorage(this.config.maxEnergy, this.config.maxTransfer);
    }

    protected abstract boolean canGenerate();

    protected abstract void generate();

    public Icon getActiveIcon() {
        return FluidRegistry.WATER.getIcon();
    }

    protected void attenuate() {
        this.energyStorage.modifyEnergyStored(-this.config.minPower);
        if (this.timeCheck() && this.fuelRF > 0) {
            this.fuelRF -= 10;
            if (this.fuelRF < 0) {
                this.fuelRF = 0;
            }
        }
    }

    public int calcEnergy() {
        if (!this.isActive) {
            return 0;
        }
        if (this.energyStorage.getEnergyStored() < this.config.maxPowerLevel) {
            return this.config.maxPower;
        }
        if (this.energyStorage.getEnergyStored() > this.config.minPowerLevel) {
            return this.config.minPower;
        }
        return (this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored()) / this.config.energyRamp;
    }

    protected void transferEnergy(int bSide) {
        if (this.adjacentHandler == null) {
            return;
        }
        this.energyStorage.modifyEnergyStored(-this.adjacentHandler.receiveEnergy(ForgeDirection.VALID_DIRECTIONS[bSide ^ 1], Math.min(this.config.maxTransfer, this.energyStorage.getEnergyStored()), false));
    }

    public void func_70316_g() {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        if (!this.cached) {
            this.updateAdjacentHandlers();
        }
        boolean curActive = this.isActive;
        if (this.redstoneControlOrDisable()) {
            int curScale;
            if (this.isActive) {
                if (this.canGenerate()) {
                    this.generate();
                    this.transferEnergy(this.facing);
                } else {
                    this.isActive = false;
                }
            } else if (this.canGenerate()) {
                this.isActive = true;
                this.generate();
                this.transferEnergy(this.facing);
            } else {
                this.attenuate();
            }
            if (this.timeCheck() && (curScale = this.getScaledEnergyStored(15)) != this.compareTracker) {
                this.compareTracker = curScale;
                this.callNeighborTileChange();
            }
        } else {
            this.isActive = false;
            this.attenuate();
        }
        if (curActive != this.isActive) {
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    public int getScaledEnergyStored(int scale) {
        return this.energyStorage.getEnergyStored() * scale / this.energyStorage.getMaxEnergyStored();
    }

    public int getLightValue() {
        return this.isActive ? 7 : 0;
    }

    public String getName() {
        return "tile.thermalexpansion.dynamo." + BlockDynamo.NAMES[this.getType()] + ".name";
    }

    public boolean openGui(EntityPlayer player) {
        player.openGui((Object)ThermalExpansion.instance, guiIds[this.getType()], this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateAdjacentHandlers();
    }

    public void onNeighborTileChange(int tileX, int tileY, int tileZ) {
        super.onNeighborTileChange(tileX, tileY, tileZ);
        this.updateAdjacentHandlers();
    }

    protected void updateAdjacentHandlers() {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        TileEntity tile = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)this.facing);
        this.adjacentHandler = EnergyHelper.isEnergyHandlerFromSide((TileEntity)tile, (ForgeDirection)ForgeDirection.VALID_DIRECTIONS[this.facing ^ 1]) ? (IEnergyHandler)tile : null;
        this.cached = true;
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public Payload getDescriptionPayload() {
        Payload payload = super.getDescriptionPayload();
        payload.addByte(this.facing);
        payload.addBool(this.isActive);
        return payload;
    }

    public Payload getGuiPayload() {
        Payload payload = Payload.getInfoPayload((TileEntity)this);
        payload.addByte(TEProps.PacketID.GUI.ordinal());
        payload.addInt(this.energyStorage.getEnergyStored());
        return payload;
    }

    @Override
    public void handleTilePacket(Payload payload) {
        super.handleTilePacket(payload);
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            this.facing = payload.getByte();
            this.isActive = payload.getBool();
        } else {
            payload.getByte();
            payload.getBool();
        }
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockID());
    }

    public void handleTileInfoPacket(Payload payload, NetHandler handler) {
        switch (TEProps.PacketID.values()[payload.getByte()]) {
            case GUI: {
                this.energyStorage.setEnergyStored(payload.getInt());
                return;
            }
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        if (iCrafting instanceof EntityPlayer && ServerHelper.isServerWorld((World)this.field_70331_k)) {
            PacketUtils.sendToPlayer((Packet)this.getGuiPayload().getPacket(), (EntityPlayer)((EntityPlayer)iCrafting));
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.facing = nbt.func_74771_c("Facing");
        this.isActive = nbt.func_74767_n("Active");
        this.fuelRF = nbt.func_74762_e("Fuel");
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74774_a("Facing", this.facing);
        nbt.func_74757_a("Active", this.isActive);
        nbt.func_74768_a("Fuel", this.fuelRF);
        this.energyStorage.writeToNBT(nbt);
    }

    public int[] func_94128_d(int side) {
        return TEProps.EMPTY_INVENTORY;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return side != this.facing;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return side != this.facing;
    }

    public int getFacing() {
        return this.facing;
    }

    public boolean rotateBlock() {
        int i;
        for (i = this.facing + 1; i < this.facing + 6; ++i) {
            TileEntity theTile = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)(i % 6));
            if (!(theTile instanceof TileConduitEnergy)) continue;
            this.facing = (byte)(i % 6);
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, TEBlocks.blockDynamo.field_71990_ca);
            this.updateAdjacentHandlers();
            this.sendUpdatePacket(Side.CLIENT);
            return true;
        }
        for (i = this.facing + 1; i < this.facing + 6; ++i) {
            if (!EnergyHelper.isAdjacentEnergyHandlerFromSide((TileEntity)this, (int)(i % 6))) continue;
            this.facing = (byte)(i % 6);
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, TEBlocks.blockDynamo.field_71990_ca);
            this.updateAdjacentHandlers();
            this.sendUpdatePacket(Side.CLIENT);
            return true;
        }
        return false;
    }

    public boolean onWrench(EntityPlayer player, int hitSide) {
        this.rotateBlock();
        return true;
    }

    public boolean setFacing(int side) {
        return false;
    }

    public boolean allowYAxisFacing() {
        return true;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public boolean canInterface(ForgeDirection from) {
        return from.ordinal() == this.facing;
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getEnergyPerTick() {
        return this.calcEnergy();
    }

    public int getMaxEnergyPerTick() {
        return this.config.maxPower;
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergy() {
        return this.config.maxEnergy;
    }

    public int getComparatorInput() {
        return this.compareTracker;
    }

    static {
        TileDynamoBase.defaultConfig.minPower = 4;
        TileDynamoBase.defaultConfig.maxPower = 80;
        TileDynamoBase.defaultConfig.maxEnergy = 40000;
        TileDynamoBase.defaultConfig.maxTransfer = 160;
        TileDynamoBase.defaultConfig.minPowerLevel = 9 * TileDynamoBase.defaultConfig.maxEnergy / 10;
        TileDynamoBase.defaultConfig.maxPowerLevel = 1 * TileDynamoBase.defaultConfig.maxEnergy / 10;
        TileDynamoBase.defaultConfig.energyRamp = TileDynamoBase.defaultConfig.minPowerLevel / TileDynamoBase.defaultConfig.maxPower;
    }

    public static class DynamoConfig {
        public int minPower;
        public int maxPower;
        public int maxEnergy;
        public int maxTransfer;
        public int minPowerLevel;
        public int maxPowerLevel;
        public int energyRamp;

        public DynamoConfig() {
        }

        public DynamoConfig(DynamoConfig config) {
            this.minPower = config.minPower;
            this.maxPower = config.maxPower;
            this.maxEnergy = config.maxEnergy;
            this.maxTransfer = config.maxTransfer;
            this.minPowerLevel = config.minPowerLevel;
            this.maxPowerLevel = config.maxPowerLevel;
            this.energyRamp = config.energyRamp;
        }

        public DynamoConfig copy() {
            return new DynamoConfig(this);
        }
    }
}

