/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.util.BlockHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.TileMachineBase;
import thermalexpansion.block.machine.TileMachineEnergized;
import thermalexpansion.util.crafting.SmelterManager;

public class TileSmelter
extends TileMachineEnergized {
    public static final int TYPE = BlockMachine.Types.SMELTER.ordinal();
    int outputTrackerPrimary;
    int outputTrackerSecondary;

    public static void initialize() {
        TileSmelter.sideData[TileSmelter.TYPE] = new TileMachineBase.SideConfig();
        TileSmelter.sideData[TileSmelter.TYPE].numGroup = 7;
        TileSmelter.sideData[TileSmelter.TYPE].slotGroups = new int[][]{new int[0], {0, 1}, {2, 3}, {4}, {2, 3, 4}, {0}, {1}};
        TileSmelter.sideData[TileSmelter.TYPE].allowInsertion = new boolean[]{false, true, false, false, false, true, true};
        TileSmelter.sideData[TileSmelter.TYPE].allowExtraction = new boolean[]{false, false, true, true, true, false, false};
        TileSmelter.sideData[TileSmelter.TYPE].sideTex = new int[]{0, 1, 2, 3, 4, 5, 6};
        TileSmelter.energyData[TileSmelter.TYPE] = new TileMachineEnergized.EnergyConfig();
        energyData[TYPE].setEnergyParams(40);
        TileSmelter.guiIds[TileSmelter.TYPE] = ThermalExpansion.proxy.registerGui("Smelter", "machine", true);
        GameRegistry.registerTileEntity(TileSmelter.class, (String)"cofh.thermalexpansion.Smelter");
    }

    public TileSmelter() {
        this.sideCache = new byte[]{3, 3, 2, 2, 2, 2};
        this.inventory = new ItemStack[6];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public int getMaxInputSlot() {
        return 1;
    }

    @Override
    public boolean canStart() {
        if (this.inventory[0] == null && this.inventory[1] == null) {
            return false;
        }
        SmelterManager.RecipeSmelter recipe = SmelterManager.getRecipe(this.inventory[0], this.inventory[1]);
        if (recipe == null || this.energyStorage.getEnergyStored() < recipe.getEnergy()) {
            return false;
        }
        if (SmelterManager.isRecipeReversed(this.inventory[0], this.inventory[1]) ? recipe.getPrimaryInput().field_77994_a > this.inventory[1].field_77994_a || recipe.getSecondaryInput().field_77994_a > this.inventory[0].field_77994_a : recipe.getPrimaryInput().field_77994_a > this.inventory[0].field_77994_a || recipe.getSecondaryInput().field_77994_a > this.inventory[1].field_77994_a) {
            return false;
        }
        ItemStack primaryItem = recipe.getPrimaryOutput();
        ItemStack secondaryItem = recipe.getSecondaryOutput();
        if (secondaryItem != null && this.inventory[4] != null) {
            if (!this.inventory[4].func_77969_a(secondaryItem)) {
                return false;
            }
            if (this.inventory[4].field_77994_a + secondaryItem.field_77994_a > secondaryItem.func_77976_d()) {
                return false;
            }
        }
        if (this.inventory[2] == null || this.inventory[3] == null) {
            return true;
        }
        if (!this.inventory[2].func_77969_a(primaryItem) && !this.inventory[3].func_77969_a(primaryItem)) {
            return false;
        }
        if (!this.inventory[2].func_77969_a(primaryItem)) {
            return this.inventory[3].field_77994_a + primaryItem.field_77994_a <= primaryItem.func_77976_d();
        }
        if (!this.inventory[3].func_77969_a(primaryItem)) {
            return this.inventory[2].field_77994_a + primaryItem.field_77994_a <= primaryItem.func_77976_d();
        }
        return this.inventory[2].field_77994_a + this.inventory[3].field_77994_a + primaryItem.field_77994_a <= primaryItem.func_77976_d() * 2;
    }

    @Override
    protected boolean hasValidInput() {
        SmelterManager.RecipeSmelter recipe = SmelterManager.getRecipe(this.inventory[0], this.inventory[1]);
        if (recipe == null) {
            return false;
        }
        return !(SmelterManager.isRecipeReversed(this.inventory[0], this.inventory[1]) ? recipe.getPrimaryInput().field_77994_a > this.inventory[1].field_77994_a || recipe.getSecondaryInput().field_77994_a > this.inventory[0].field_77994_a : recipe.getPrimaryInput().field_77994_a > this.inventory[0].field_77994_a || recipe.getSecondaryInput().field_77994_a > this.inventory[1].field_77994_a);
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = SmelterManager.getRecipe(this.inventory[0], this.inventory[1]).getEnergy();
    }

    @Override
    protected void processFinish() {
        SmelterManager.RecipeSmelter recipe = SmelterManager.getRecipe(this.inventory[0], this.inventory[1]);
        ItemStack primaryItem = recipe.getPrimaryOutput();
        ItemStack secondaryItem = recipe.getSecondaryOutput();
        if (this.inventory[2] == null) {
            this.inventory[2] = primaryItem;
        } else if (this.inventory[2].func_77969_a(primaryItem)) {
            if (this.inventory[2].field_77994_a + primaryItem.field_77994_a <= primaryItem.func_77976_d()) {
                this.inventory[2].field_77994_a += primaryItem.field_77994_a;
            } else {
                int overflow = primaryItem.func_77976_d() - this.inventory[2].field_77994_a;
                this.inventory[2].field_77994_a += overflow;
                if (this.inventory[3] == null) {
                    this.inventory[3] = primaryItem;
                    this.inventory[3].field_77994_a = primaryItem.field_77994_a - overflow;
                } else {
                    this.inventory[3].field_77994_a += primaryItem.field_77994_a - overflow;
                }
            }
        } else if (this.inventory[3] == null) {
            this.inventory[3] = primaryItem;
        } else {
            this.inventory[3].field_77994_a += primaryItem.field_77994_a;
        }
        if (secondaryItem != null && this.field_70331_k.field_73012_v.nextInt(100) < recipe.getSecondaryOutputChance()) {
            if (this.inventory[4] == null) {
                this.inventory[4] = secondaryItem;
            } else {
                this.inventory[4].field_77994_a += secondaryItem.field_77994_a;
            }
        }
        if (SmelterManager.isRecipeReversed(this.inventory[0], this.inventory[1])) {
            this.inventory[1].field_77994_a -= recipe.getPrimaryInput().field_77994_a;
            this.inventory[0].field_77994_a -= recipe.getSecondaryInput().field_77994_a;
        } else {
            this.inventory[0].field_77994_a -= recipe.getPrimaryInput().field_77994_a;
            this.inventory[1].field_77994_a -= recipe.getSecondaryInput().field_77994_a;
        }
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
        if (this.inventory[1].field_77994_a <= 0) {
            this.inventory[1] = null;
        }
    }

    @Override
    protected void transferProducts() {
        int side;
        int i;
        if (this.inventory[2] != null || this.inventory[3] != null) {
            for (i = this.outputTrackerPrimary + 1; i <= this.outputTrackerPrimary + 6; ++i) {
                side = i % 6;
                if (this.sideCache[side] != 2 && this.sideCache[side] != 4) continue;
                if (this.transferItem(2, 4, side)) {
                    if (!this.transferItem(3, 4, side)) {
                        this.transferItem(2, 4, side);
                    }
                    this.outputTrackerPrimary = side;
                    break;
                }
                if (!this.transferItem(3, 8, side)) continue;
                this.outputTrackerPrimary = side;
                break;
            }
        }
        if (this.inventory[4] == null) {
            return;
        }
        for (i = this.outputTrackerSecondary + 1; i <= this.outputTrackerSecondary + 6; ++i) {
            side = i % 6;
            if (this.sideCache[side] != 3 && this.sideCache[side] != 4 || !this.transferItem(4, 4, side)) continue;
            this.outputTrackerSecondary = side;
            break;
        }
    }

    @Override
    public boolean canAcceptItem(ItemStack stack, int slot, int side) {
        return slot == 0 ? SmelterManager.isItemValid(stack) : true;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.outputTrackerPrimary = nbt.func_74762_e("Tracker1");
        this.outputTrackerSecondary = nbt.func_74762_e("Tracker2");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("Tracker1", this.outputTrackerPrimary);
        nbt.func_74768_a("Tracker2", this.outputTrackerSecondary);
    }

    @Override
    public boolean setFacing(int side) {
        if (side < 0 || side > 5) {
            return false;
        }
        this.sideCache[side] = 0;
        this.sideCache[BlockHelper.SIDE_OPPOSITE[side]] = 6;
        this.sideCache[BlockHelper.SIDE_LEFT[side]] = 5;
        this.facing = (byte)side;
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }
}

