/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.tank;

import cofh.block.ITileInfo;
import cofh.network.ITilePacketHandler;
import cofh.network.Payload;
import cofh.util.BlockHelper;
import cofh.util.FluidHelper;
import cofh.util.ServerHelper;
import cofh.util.StringHelper;
import cofh.util.fluid.FluidTankAdv;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.block.tank.BlockTank;

public class TileTank
extends TileTEBase
implements IFluidHandler,
ITilePacketHandler,
ITileInfo {
    protected static final int UPDATE_FACTOR = 4;
    public static final int RENDER_LEVELS = 128;
    public static final int[] CAPACITY = new int[]{1000, 8000, 16000, 32000, 64000};
    public byte type;
    public byte mode;
    FluidTankAdv tank;
    boolean cached = false;
    IFluidHandler[] adjacentHandlers = new IFluidHandler[2];
    boolean[] adjacentTanks = new boolean[2];
    public int lastDisplayLevel = 0;
    int compareTracker;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileTank.class, (String)"cofh.thermalexpansion.Tank");
    }

    public TileTank() {
        this.tank = new FluidTankAdv(CAPACITY[1]);
    }

    public TileTank(int metadata) {
        this.tank = new FluidTankAdv(CAPACITY[metadata]);
        this.type = (byte)metadata;
    }

    public String getName() {
        return "tile.thermalexpansion.tank." + BlockTank.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return this.type;
    }

    public Payload getDescriptionPayload() {
        Payload payload = Payload.getDescriptionPayload((TileEntity)this);
        payload.addByte(this.type);
        payload.addByte(this.mode);
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    public void handleTilePacket(Payload payload) {
        byte prevMode = this.mode;
        this.type = payload.getByte();
        this.mode = payload.getByte();
        this.tank.setFluid(payload.getFluidStack());
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void updateRender() {
        int curDisplayLevel = 0;
        if (this.tank.getFluidAmount() > 0) {
            curDisplayLevel = (int)((float)this.tank.getFluidAmount() / (float)CAPACITY[this.type] * 127.0f);
            if (curDisplayLevel == 0) {
                curDisplayLevel = 1;
            }
            if (this.lastDisplayLevel == 0) {
                this.lastDisplayLevel = curDisplayLevel;
                this.sendUpdatePacket(Side.CLIENT);
                return;
            }
        } else if (this.lastDisplayLevel != 0) {
            this.lastDisplayLevel = 0;
            this.sendUpdatePacket(Side.CLIENT);
        }
        if (curDisplayLevel <= this.lastDisplayLevel - 4) {
            this.lastDisplayLevel = curDisplayLevel;
            this.sendUpdatePacket(Side.CLIENT);
        } else if (curDisplayLevel >= this.lastDisplayLevel + 4) {
            this.lastDisplayLevel = curDisplayLevel;
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    public void calcLastDisplay() {
        this.lastDisplayLevel = (int)((float)this.tank.getFluidAmount() / (float)CAPACITY[this.type] * 127.0f);
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public int getTankFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public int getTankCapacity() {
        return this.tank.getCapacity();
    }

    public boolean onWrench(EntityPlayer player, int bSide) {
        this.mode = (byte)(this.mode + 1);
        this.mode = (byte)(this.mode % 2);
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateAdjacentHandlers();
    }

    public void onNeighborTileChange(int tileX, int tileY, int tileZ) {
        super.onNeighborTileChange(tileX, tileY, tileZ);
        this.updateAdjacentHandlers();
    }

    protected void updateAdjacentHandlers() {
        byte curMode = this.mode;
        TileEntity tile = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)0);
        if (FluidHelper.isFluidHandler((TileEntity)tile)) {
            this.adjacentHandlers[0] = (IFluidHandler)tile;
            if (tile instanceof TileTank) {
                this.mode = 1;
                this.adjacentTanks[0] = true;
            } else {
                this.adjacentTanks[0] = false;
            }
        } else {
            this.adjacentHandlers[0] = null;
            this.adjacentTanks[0] = false;
        }
        tile = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)1);
        if (FluidHelper.isFluidHandler((TileEntity)tile)) {
            this.adjacentHandlers[1] = (IFluidHandler)tile;
            this.adjacentTanks[1] = tile instanceof TileTank;
        } else {
            this.adjacentHandlers[1] = null;
            this.adjacentTanks[1] = false;
        }
        if (curMode != this.mode) {
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    public void func_70316_g() {
        int curScale;
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        if (!this.cached) {
            this.updateAdjacentHandlers();
        }
        if (this.mode == 1) {
            this.transferFluid();
        }
        if (this.timeCheck() && (curScale = this.getScaledFluidStored(15)) != this.compareTracker) {
            this.compareTracker = curScale;
            this.callNeighborTileChange();
        }
        if (this.field_70331_k.func_82737_E() % 4L == 0L) {
            this.updateRender();
        }
        super.func_70316_g();
    }

    protected void transferFluid() {
        if (this.tank.getFluidAmount() <= 0 || this.adjacentHandlers[0] == null) {
            return;
        }
        this.tank.drain(this.adjacentHandlers[0].fill(ForgeDirection.VALID_DIRECTIONS[1], new FluidStack(this.tank.getFluid(), Math.min(1000, this.tank.getFluidAmount())), true), true);
        if (this.tank.getFluidAmount() <= 0) {
            this.updateRender();
        }
    }

    public int getScaledFluidStored(int scale) {
        return this.tank.getFluid() == null ? 0 : this.tank.getFluid().amount * scale / this.tank.getCapacity();
    }

    public int getLightValue() {
        if (this.tank.getFluid() == null || this.tank.getFluid().getFluid() == null) {
            return 0;
        }
        int fluidLightLevel = this.tank.getFluid().getFluid().getLuminosity();
        if (this.tank.getFluidAmount() <= CAPACITY[this.type] / 4) {
            return fluidLightLevel >> 1;
        }
        if (this.tank.getFluidAmount() >= CAPACITY[this.type] * 3 / 4) {
            return fluidLightLevel;
        }
        return (fluidLightLevel >> 1) + (fluidLightLevel - (fluidLightLevel >> 1)) * (this.tank.getFluidAmount() - (CAPACITY[this.type] >> 2)) / (CAPACITY[this.type] >> 1);
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.type = nbt.func_74771_c("Type");
        this.mode = nbt.func_74771_c("Mode");
        this.tank = new FluidTankAdv(CAPACITY[this.type]);
        this.tank.readFromNBT(nbt);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74774_a("Type", this.type);
        nbt.func_74774_a("Mode", this.mode);
        this.tank.writeToNBT(nbt);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (from.ordinal() == 0 && this.mode == 1 && !this.adjacentTanks[0]) {
            return 0;
        }
        if (from.ordinal() > 1 && from.ordinal() < 6) {
            return 0;
        }
        if (this.tank.getFluid() != null && !this.tank.getFluid().isFluidEqual(resource)) {
            return 0;
        }
        if (resource.fluidID == 0) {
            return 0;
        }
        int amount = this.tank.fill(resource, doFill);
        if (from.ordinal() != 1 && this.adjacentHandlers[1] != null && this.adjacentTanks[1]) {
            if (amount == 0) {
                return this.adjacentHandlers[1].fill(ForgeDirection.DOWN, resource, doFill);
            }
            if (amount != resource.amount) {
                FluidStack remaining = resource.copy();
                remaining.amount -= amount;
                return amount + this.adjacentHandlers[1].fill(ForgeDirection.DOWN, remaining, doFill);
            }
        }
        return amount;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (from.ordinal() == 0 && this.mode == 1) {
            return null;
        }
        if (from.ordinal() > 1 && from.ordinal() < 6) {
            return null;
        }
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from.ordinal() == 0 && this.mode == 1) {
            return null;
        }
        if (from.ordinal() > 1 && from.ordinal() < 6) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from.ordinal() < 2;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from.ordinal() < 1;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public void getTileInfo(List<String> info, ForgeDirection side, EntityPlayer player, boolean debug) {
        if (debug) {
            return;
        }
        if (this.tank.getFluid() != null) {
            info.add("Fluid: " + StringHelper.getFluidName((FluidStack)this.tank.getFluid()));
            info.add("Amount: " + this.tank.getFluidAmount() + "/" + this.tank.getCapacity() + " mB");
        } else {
            info.add("Fluid: Empty");
        }
    }

    public int getComparatorInput() {
        return this.compareTracker;
    }
}

