/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.part.conduit.item;

import cofh.network.Payload;
import cofh.util.BlockHelper;
import cofh.util.CoreUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import thermalexpansion.part.conduit.ConduitBase;
import thermalexpansion.part.conduit.GridTickHandler;
import thermalexpansion.part.conduit.IConduit;
import thermalexpansion.part.conduit.item.ConduitItem;
import thermalexpansion.part.conduit.item.ItemRoute;
import thermalexpansion.util.Utils;

public class TravelingItem {
    public ItemStack stack;
    public float x;
    public float y;
    public float z;
    public byte progress;
    public int direction;
    public int oldDirection;
    public ItemRoute myPath;
    public boolean goingToStuff = false;
    public int startX;
    public int startY;
    public int startZ;
    public int destX;
    public int destY;
    public int destZ;
    public boolean mustGoToDest = false;
    public boolean hasDest = false;
    public boolean reRoute = false;
    public boolean shouldDie = false;
    public static final float[][] START_COORD = new float[][]{{0.5f, 1.0f, 0.5f}, {0.5f, 0.0f, 0.5f}, {0.5f, 0.5f, 1.0f}, {0.5f, 0.5f, 0.0f}, {1.0f, 0.5f, 0.5f}, {0.0f, 0.5f, 0.5f}};

    public TravelingItem(ItemStack theItem, int xCoord, int yCoord, int zCoord, ItemRoute itemPath, int oldDirection) {
        this.progress = 0;
        this.direction = itemPath.getNextDirection();
        this.myPath = itemPath;
        this.x = xCoord;
        this.y = yCoord;
        this.z = zCoord;
        this.startX = xCoord;
        this.startY = yCoord;
        this.startZ = zCoord;
        this.stack = theItem;
        this.oldDirection = oldDirection;
    }

    public TravelingItem(byte progress, byte direction, byte oldDirection, ItemStack theItem, ConduitItem homeTile) {
        this.progress = progress;
        this.direction = direction;
        this.oldDirection = oldDirection;
        this.stack = theItem;
        TravelingItem.calcCoordsFromProgress(this, homeTile);
    }

    public void tickForward(ConduitItem homeTile) {
        this.progress = (byte)(this.progress + 1);
        this.progress = (byte)(this.progress % homeTile.getPipeLength());
        if (this.myPath == null) {
            this.bounceItem(homeTile);
        } else if (this.progress == 0) {
            if (homeTile.sideType[this.direction] == 1) {
                ConduitItem newHome = (ConduitItem)homeTile.getConduit(this.direction);
                if (newHome != null && newHome.sideType[this.direction ^ 1] == 1) {
                    homeTile.itemsToRemove.add(this);
                    if (this.myPath.pathPos == 0 && this.goingToStuff) {
                        if (newHome.canStuffItem()) {
                            this.goingToStuff = false;
                            newHome.stuffItem(this);
                        } else {
                            this.bounceItem(newHome);
                        }
                        return;
                    }
                    newHome.insertItem(this);
                    if (this.myPath.hasNextDirection()) {
                        this.oldDirection = this.direction;
                        this.direction = this.myPath.getNextDirection();
                    } else {
                        this.reRoute = true;
                    }
                }
            } else if (homeTile.sideType[this.direction] == 2 && homeTile.sideMode[this.direction] == 1) {
                if (this.myPath.pathPos >= this.myPath.pathLength && this.goingToStuff) {
                    if (homeTile.canStuffItem()) {
                        this.goingToStuff = false;
                        homeTile.stuffItem(this);
                        homeTile.itemsToRemove.add(this);
                    } else {
                        this.goingToStuff = false;
                        this.bounceItem(homeTile);
                    }
                    return;
                }
                if (homeTile.cacheType[this.direction] != ConduitBase.CacheTypes.NOT_SET) {
                    this.stack.field_77994_a = Utils.addToInventory(homeTile.getImportant(this.direction), this.direction, this.stack);
                    if (this.stack.field_77994_a > 0) {
                        this.bounceItem(homeTile);
                        return;
                    }
                    homeTile.itemsToRemove.add(this);
                } else {
                    this.bounceItem(homeTile);
                }
            } else {
                this.bounceItem(homeTile);
            }
        } else if (this.progress % homeTile.getPipeHalfLength() == 0 && (this.reRoute || homeTile.sideType[this.direction] == 0)) {
            this.bounceItem(homeTile);
        }
    }

    public void bounceItem(ConduitItem homeTile) {
        ConduitItem.routeInfo curInfo;
        homeTile.cacheRoutes();
        if (this.hasDest) {
            for (ItemRoute aRoute : homeTile.validOutputs) {
                if (!aRoute.endPoint.isNode || aRoute.endPoint.x() != this.destX || aRoute.endPoint.y() != this.destY || aRoute.endPoint.z() != this.destZ) continue;
                curInfo = aRoute.endPoint.canRouteItem(this.stack, aRoute.pathLength == 0, aRoute.endPoint.moveStackSize[aRoute.getLastSide()]);
                if (!curInfo.canRoute) continue;
                this.myPath = aRoute.copy();
                this.myPath.pathDirections.add(curInfo.side);
                this.oldDirection = this.direction ^ 1;
                this.direction = this.myPath.getNextDirection();
                homeTile.hasChanged = true;
                return;
            }
        }
        if (!this.hasDest || !this.mustGoToDest && this.hasDest) {
            for (ItemRoute aRoute : homeTile.validOutputs) {
                if (!aRoute.endPoint.isNode) continue;
                curInfo = aRoute.endPoint.canRouteItem(this.stack, aRoute.pathLength == 0, aRoute.endPoint.moveStackSize[aRoute.getLastSide()]);
                if (!curInfo.canRoute) continue;
                this.myPath = aRoute.copy();
                this.myPath.pathDirections.add(curInfo.side);
                this.oldDirection = this.direction ^ 1;
                this.direction = this.myPath.getNextDirection();
                homeTile.hasChanged = true;
                return;
            }
        }
        if (homeTile.isInput) {
            homeTile.itemsToRemove.add(this);
            homeTile.stuffItem(this);
        } else if (!homeTile.validStuffable.isEmpty()) {
            this.goingToStuff = true;
            this.myPath = this.getStuffedRoute(homeTile);
            this.myPath.pathDirections.add(this.myPath.endPoint.getStuffedSide());
            this.oldDirection = this.direction ^ 1;
            this.direction = this.myPath.getNextDirection();
            homeTile.hasChanged = true;
        } else {
            CoreUtils.dropItemStackIntoWorld((ItemStack)this.stack, (World)homeTile.world(), (double)homeTile.x(), (double)homeTile.y(), (double)homeTile.z());
            homeTile.itemsToRemove.add(this);
        }
    }

    public ItemRoute getStuffedRoute(ConduitItem homeTile) {
        for (ItemRoute aRoute : homeTile.validStuffable) {
            if (aRoute.endPoint.x() != this.startX || aRoute.endPoint.y() != this.startY || aRoute.endPoint.z() != this.startZ) continue;
            return aRoute.copy();
        }
        return homeTile.validStuffable.getFirst().copy();
    }

    public void tickClientForward(ConduitItem homeTile) {
        this.progress = (byte)(this.progress + 1);
        this.progress = (byte)(this.progress % homeTile.getPipeLength());
        if (!this.shouldDie || this.shouldDie && this.progress <= homeTile.getPipeHalfLength()) {
            TravelingItem.moveCoordsByProgress(this.progress, this, homeTile);
        }
        if (this.progress == 0) {
            if (this.shouldDie) {
                homeTile.itemsToRemove.add(this);
            } else {
                IConduit newConduit;
                homeTile.itemsToRemove.add(this);
                this.shouldDie = true;
                TileEntity newTile = BlockHelper.getAdjacentTileEntity((TileEntity)homeTile.tile(), (int)this.direction);
                if (newTile instanceof IConduit && (newConduit = (IConduit)newTile).isItemConduit()) {
                    this.oldDirection = this.direction;
                    newConduit.getConduitItem().myItems.add(this);
                    if (!GridTickHandler.ItemClientTickHandler.tickConduit.contains(newConduit.getConduitItem()) && !GridTickHandler.ItemClientTickHandler.tickConduitToAdd.contains(newConduit.getConduitItem())) {
                        GridTickHandler.ItemClientTickHandler.tickConduitToAdd.add(newConduit.getConduitItem());
                    }
                    TravelingItem.calcCoordsFromProgress(this, newConduit.getConduitItem());
                }
            }
        }
    }

    public static void calcCoordsFromProgress(TravelingItem theItem, ConduitItem homeTile) {
        theItem.x = START_COORD[theItem.oldDirection][0];
        theItem.y = START_COORD[theItem.oldDirection][1];
        theItem.z = START_COORD[theItem.oldDirection][2];
        for (int i = 0; i < theItem.progress; ++i) {
            TravelingItem.moveCoordsByProgress(i, theItem, homeTile);
        }
    }

    public static void moveCoordsByProgress(int Progress, TravelingItem theItem, ConduitItem homeTile) {
        if (Progress <= homeTile.getPipeHalfLength()) {
            theItem.x += homeTile.getSideCoordsModifier()[theItem.oldDirection][0];
            theItem.y += homeTile.getSideCoordsModifier()[theItem.oldDirection][1];
            theItem.z += homeTile.getSideCoordsModifier()[theItem.oldDirection][2];
        } else if (theItem.direction >= 0) {
            theItem.x += homeTile.getSideCoordsModifier()[theItem.direction][0];
            theItem.y += homeTile.getSideCoordsModifier()[theItem.direction][1];
            theItem.z += homeTile.getSideCoordsModifier()[theItem.direction][2];
        }
    }

    public void writePacket(Payload myPayload) {
        myPayload.addByte(this.progress);
        myPayload.addByte(this.direction);
        myPayload.addByte(this.oldDirection);
        myPayload.addItemStack(this.stack);
    }

    public static TravelingItem fromPacket(Payload payload, ConduitItem homeTile) {
        return new TravelingItem(payload.getByte(), payload.getByte(), payload.getByte(), payload.getItemStack(), homeTile);
    }

    public void toNBT(NBTTagCompound theNBT) {
        theNBT.func_74782_a("stack", (NBTBase)new NBTTagCompound());
        this.stack.func_77955_b(theNBT.func_74775_l("stack"));
        theNBT.func_74776_a("x", this.x);
        theNBT.func_74776_a("y", this.y);
        theNBT.func_74776_a("z", this.z);
        theNBT.func_74774_a("progress", this.progress);
        theNBT.func_74768_a("direction", this.direction);
        theNBT.func_74768_a("oldDir", this.oldDirection);
        theNBT.func_74757_a("gts", this.goingToStuff);
        if (this.hasDest) {
            theNBT.func_74768_a("destX", this.myPath.endPoint.x());
            theNBT.func_74768_a("destY", this.myPath.endPoint.y());
            theNBT.func_74768_a("destZ", this.myPath.endPoint.z());
            theNBT.func_74757_a("mustGo", this.mustGoToDest);
        }
        theNBT.func_74768_a("startX", this.startX);
        theNBT.func_74768_a("startY", this.startY);
        theNBT.func_74768_a("startZ", this.startZ);
    }

    public TravelingItem(NBTTagCompound theNBT) {
        this.stack = ItemStack.func_77949_a((NBTTagCompound)theNBT.func_74775_l("stack"));
        this.x = theNBT.func_74760_g("x");
        this.y = theNBT.func_74760_g("y");
        this.z = theNBT.func_74760_g("z");
        this.progress = theNBT.func_74771_c("progress");
        this.direction = theNBT.func_74762_e("direction");
        this.oldDirection = theNBT.func_74762_e("oldDir");
        this.goingToStuff = theNBT.func_74767_n("goingToStuff");
        if (theNBT.func_74764_b("destX")) {
            this.hasDest = true;
            this.destX = theNBT.func_74762_e("destX");
            this.destY = theNBT.func_74762_e("destY");
            this.destZ = theNBT.func_74762_e("destZ");
            this.mustGoToDest = theNBT.func_74767_n("mustGo");
        }
        this.startX = theNBT.func_74762_e("startX");
        this.startY = theNBT.func_74762_e("startY");
        this.startZ = theNBT.func_74762_e("startZ");
    }
}

