/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.plugins.cc;

import cofh.api.block.IDismantleable;
import cofh.entity.PlayerFake;
import cofh.util.BlockHelper;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.ITurtleUpgrade;
import dan200.turtle.api.TurtleSide;
import dan200.turtle.api.TurtleUpgradeType;
import dan200.turtle.api.TurtleVerb;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.util.Icon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.block.tank.BlockTank;
import thermalexpansion.plugins.cc.CCPlugin;

public class TurtleBucket
implements ITurtleUpgrade {
    private static final float DAMAGE_MULTIPLIER = 1.0f;
    private final int m_id;
    private final String m_adjective;
    protected ItemStack m_item;
    protected boolean m_secret;

    public TurtleBucket(int id, String adjective) {
        this.m_id = id;
        this.m_adjective = adjective;
        this.m_item = new ItemStack(Item.field_77788_aw);
        this.m_secret = false;
    }

    private boolean attack(ITurtleAccess turtle, int dir) {
        boolean result = turtle.attackWithItemStack(this.m_item.func_77946_l(), dir, 1.0f);
        if (!result) {
            return this.addFluid(turtle, dir);
        }
        return result;
    }

    private boolean dig(ITurtleAccess turtle, int dir) {
        World worldObj = turtle.getWorld();
        Vec3 position = turtle.getPosition();
        int newX = (int)position.field_72450_a + Facing.field_71586_b[dir];
        int newY = (int)position.field_72448_b + Facing.field_71587_c[dir];
        int newZ = (int)position.field_72449_c + Facing.field_71585_d[dir];
        if (newY < 0 || newY >= worldObj.func_72940_L()) {
            return false;
        }
        int bId = worldObj.func_72798_a(newX, newY, newZ);
        Block theBlock = Block.field_71973_m[bId];
        if (theBlock instanceof BlockTank) {
            PlayerFake player = new PlayerFake(worldObj);
            if (((IDismantleable)theBlock).canDismantle((EntityPlayer)player, worldObj, newX, newY, newZ)) {
                this.storeItem(turtle, ((IDismantleable)theBlock).dismantleBlock((EntityPlayer)player, worldObj, newX, newY, newZ, true));
            }
        } else if (CCPlugin.turtlesCanBreakBlocks) {
            if (!this.canBreakBlock(worldObj, newX, newY, newZ)) {
                return false;
            }
            if (this.canHarvestBlock(worldObj, newX, newY, newZ)) {
                ArrayList items = this.getBlockDropped(worldObj, newX, newY, newZ);
                for (ItemStack item : items) {
                    this.storeItem(turtle, item);
                }
            }
            int blockID = worldObj.func_72798_a(newX, newY, newZ);
            worldObj.func_72926_e(2001, newX, newY, newZ, blockID + worldObj.func_72798_a(newX, newY, newZ) * 4096);
            worldObj.func_94571_i(newX, newY, newZ);
        }
        return true;
    }

    public boolean addFluid(ITurtleAccess theTurtle, int dir) {
        ItemStack bucket = this.m_item.func_77946_l();
        theTurtle.deployWithItemStack(bucket, dir);
        World worldObj = theTurtle.getWorld();
        Vec3 position = theTurtle.getPosition();
        int newX = (int)position.field_72450_a + Facing.field_71586_b[dir];
        int newY = (int)position.field_72448_b + Facing.field_71587_c[dir];
        int newZ = (int)position.field_72449_c + Facing.field_71585_d[dir];
        if (newY < 0 || newY >= worldObj.func_72940_L()) {
            return false;
        }
        if (!FluidContainerRegistry.EMPTY_BUCKET.func_77969_a(bucket)) {
            if (!this.addFluid(theTurtle, bucket, null)) {
                theTurtle.deployWithItemStack(bucket, dir);
                return false;
            }
            return true;
        }
        if (theTurtle.getSlotContents(theTurtle.getSelectedSlot()) == null && this.removeFromTanks(theTurtle, worldObj, newX, newY, newZ, dir)) {
            return true;
        }
        if (theTurtle.getSlotContents(theTurtle.getSelectedSlot()) != null && this.addToTanks(theTurtle, worldObj, newX, newY, newZ, dir)) {
            return true;
        }
        return this.placeFluid(theTurtle, dir);
    }

    public boolean addFluid(ITurtleAccess theTurtle, ItemStack bucket, FluidStack myData) {
        if (bucket != null) {
            myData = FluidContainerRegistry.getFluidForFilledItem((ItemStack)bucket);
        }
        if (myData == null) {
            return false;
        }
        for (int i = 0; i < theTurtle.getInventorySize(); ++i) {
            IFluidContainerItem container;
            if (theTurtle.getSlotContents(i) == null || !(theTurtle.getSlotContents(i).func_77973_b() instanceof IFluidContainerItem) || (container = (IFluidContainerItem)theTurtle.getSlotContents(i).func_77973_b()).fill(theTurtle.getSlotContents(i), myData, false) != myData.amount) continue;
            container.fill(theTurtle.getSlotContents(i), myData, true);
            return true;
        }
        return false;
    }

    public boolean addToTanks(ITurtleAccess theTurtle, World worldObj, int x, int y, int z, int side) {
        TileEntity tile = worldObj.func_72796_p(x, y, z);
        if (tile instanceof IFluidHandler) {
            IFluidHandler theTank = (IFluidHandler)tile;
            ItemStack curItem = theTurtle.getSlotContents(theTurtle.getSelectedSlot());
            if (curItem != null && curItem.func_77973_b() instanceof IFluidContainerItem) {
                IFluidContainerItem theContainer = (IFluidContainerItem)curItem.func_77973_b();
                FluidStack theFluid = theContainer.getFluid(curItem);
                theContainer.drain(curItem, theTank.fill(ForgeDirection.VALID_DIRECTIONS[side ^ 1], theFluid, true), true);
                return true;
            }
        }
        return false;
    }

    public boolean removeFromTanks(ITurtleAccess theTurtle, World worldObj, int x, int y, int z, int side) {
        IFluidHandler theTank;
        FluidStack theFluid;
        TileEntity tile = worldObj.func_72796_p(x, y, z);
        if (tile instanceof IFluidHandler && (theFluid = (theTank = (IFluidHandler)tile).drain(ForgeDirection.VALID_DIRECTIONS[side ^ 1], 1000, false)) != null && theFluid.amount == 1000 && this.addFluid(theTurtle, null, theFluid)) {
            theTank.drain(ForgeDirection.VALID_DIRECTIONS[side ^ 1], 1000, true);
            return true;
        }
        return false;
    }

    private boolean placeFluid(ITurtleAccess theTurtle, int dir) {
        ItemStack curItem = theTurtle.getSlotContents(theTurtle.getSelectedSlot());
        if (curItem != null && curItem.field_77990_d != null && curItem.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem container = (IFluidContainerItem)curItem.func_77973_b();
            FluidStack theFluid = container.getFluid(curItem);
            if (theFluid.amount >= 1000) {
                ItemStack theBucket = FluidContainerRegistry.fillFluidContainer((FluidStack)theFluid, (ItemStack)FluidContainerRegistry.EMPTY_BUCKET);
                theTurtle.deployWithItemStack(theBucket, dir);
                if (FluidContainerRegistry.EMPTY_BUCKET.func_77969_a(theBucket)) {
                    curItem.field_77990_d.func_74768_a("Fluid.amount", curItem.field_77990_d.func_74762_e("Fluid.amount") - 1000);
                    if (curItem.field_77990_d.func_74762_e("Fluid.amount") <= 0) {
                        curItem.field_77990_d = null;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean canBreakBlock(World world, int x, int y, int z) {
        int bId = world.func_72798_a(x, y, z);
        Block block = Block.field_71973_m[bId];
        return bId != 0 && bId != Block.field_71986_z.field_71990_ca && !(block.func_71934_m(world, x, y, z) <= -1.0f);
    }

    protected boolean canHarvestBlock(World world, int x, int y, int z) {
        int bId = world.func_72798_a(x, y, z);
        Block block = Block.field_71973_m[bId];
        return block.field_72018_cp.func_76229_l();
    }

    private ArrayList getBlockDropped(World world, int x, int y, int z) {
        int bId = world.func_72798_a(x, y, z);
        Block block = Block.field_71973_m[bId];
        int metadata = world.func_72805_g(x, y, z);
        return block.getBlockDropped(world, x, y, z, metadata, 0);
    }

    public boolean rotateBlock(World worldObj, int block, int meta, int newX, int newY, int newZ) {
        if (!BlockHelper.canRotate((int)block)) {
            return false;
        }
        worldObj.func_72921_c(newX, newY, newZ, BlockHelper.rotateVanillaBlock((World)worldObj, (int)block, (int)meta, (int)newX, (int)newY, (int)newZ), 1);
        return true;
    }

    public void storeItem(ITurtleAccess turtle, ItemStack item) {
        if (item != null && !turtle.storeItemStack(item) && !turtle.dropItemStack(item, turtle.getFacingDir())) {
            turtle.dropItemStack(item, turtle.getFacingDir());
        }
    }

    public int getUpgradeID() {
        return this.m_id;
    }

    public String getAdjective() {
        return this.m_adjective;
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Tool;
    }

    public ItemStack getCraftingItem() {
        return this.m_item;
    }

    public boolean isSecret() {
        return this.m_secret;
    }

    public IHostedPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return null;
    }

    public boolean useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, int dir) {
        switch (verb.ordinal()) {
            case 1: {
                return this.attack(turtle, dir);
            }
            case 2: {
                return this.dig(turtle, dir);
            }
        }
        return this.dig(turtle, dir);
    }

    public Icon getIcon(ITurtleAccess turtle, TurtleSide side) {
        return this.m_item.func_77954_c();
    }
}

