/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util.crafting;

import cofh.util.ItemHelper;
import cofh.util.inventory.ComparableItemStackSafe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.core.TEProps;
import thermalexpansion.fluid.TEFluids;
import thermalexpansion.item.TEItems;

public class CrucibleManager {
    private static Map<ComparableItemStackSafe, RecipeCrucible> recipeMap = new HashMap<ComparableItemStackSafe, RecipeCrucible>();
    private static ComparableItemStackSafe query = new ComparableItemStackSafe(new ItemStack(Block.field_71981_t));
    private static boolean allowOverwrite = false;

    public static RecipeCrucible getRecipe(ItemStack input) {
        if (input == null) {
            return null;
        }
        return recipeMap.get(query.set(input));
    }

    public static boolean recipeExists(ItemStack input) {
        return CrucibleManager.getRecipe(input) != null;
    }

    public static RecipeCrucible[] getRecipeList() {
        return recipeMap.values().toArray(new RecipeCrucible[0]);
    }

    public static void addDefaultRecipes() {
        int defaultCost;
        boolean recipeNetherrack = ThermalExpansion.config.get("tweak", "Crucible.Netherrack", true);
        boolean recipeBlazeRod = ThermalExpansion.config.get("tweak", "Crucible.BlazeRod", true);
        int tweakNetherrackRF = ThermalExpansion.config.get("tweak", "Crucible.Netherrack.Energy", TEProps.lavaRF * 6 / 10);
        int tweakBlazeRodRF = ThermalExpansion.config.get("tweak", "Crucible.BlazeRod.Energy", TEProps.lavaRF / 10);
        if (recipeNetherrack) {
            if (tweakNetherrackRF >= TEProps.lavaRF / 10 && tweakNetherrackRF <= 400000) {
                CrucibleManager.addTERecipe(tweakNetherrackRF, new ItemStack(Block.field_72012_bb), new FluidStack(FluidRegistry.LAVA, 1000));
            } else {
                CrucibleManager.addTERecipe(TEProps.lavaRF * 6 / 10, new ItemStack(Block.field_72012_bb), new FluidStack(FluidRegistry.LAVA, 1000));
                ThermalExpansion.log.log(Level.INFO, "'Crucible.Netherrack.Energy' config value is out of acceptable range. Using default.");
            }
        }
        if (recipeBlazeRod) {
            if (tweakBlazeRodRF >= TEProps.lavaRF / 20 && tweakBlazeRodRF <= 400000) {
                CrucibleManager.addTERecipe(tweakBlazeRodRF, new ItemStack(Item.field_77731_bo), new FluidStack(FluidRegistry.LAVA, 250));
            } else {
                CrucibleManager.addTERecipe(TEProps.lavaRF / 10, new ItemStack(Item.field_77731_bo), new FluidStack(FluidRegistry.LAVA, 250));
                ThermalExpansion.log.log(Level.INFO, "'Crucible.BlazeRod.Energy' config value is out of acceptable range. Using default.");
            }
        }
        if ((defaultCost = TEProps.lavaRF * 6 / 5) > 400000) {
            defaultCost = 400000;
        }
        CrucibleManager.addTERecipe(defaultCost, new ItemStack(Block.field_71978_w), new FluidStack(FluidRegistry.LAVA, 1000));
        CrucibleManager.addTERecipe(defaultCost, new ItemStack(Block.field_71981_t), new FluidStack(FluidRegistry.LAVA, 1000));
        CrucibleManager.addTERecipe(defaultCost, new ItemStack(Block.field_72089_ap), new FluidStack(FluidRegistry.LAVA, 1000));
        CrucibleManager.addTERecipe(800, new ItemStack(Item.field_77768_aD, 4), new FluidStack(FluidRegistry.WATER, 500));
        CrucibleManager.addTERecipe(800, new ItemStack(Block.field_72039_aU), new FluidStack(FluidRegistry.WATER, 500));
        CrucibleManager.addTERecipe(1600, new ItemStack(Block.field_72036_aT), new FluidStack(FluidRegistry.WATER, 1000));
        CrucibleManager.addTERecipe(8000, new ItemStack(Item.field_77767_aC), new FluidStack(TEFluids.fluidRedstone, 100));
        CrucibleManager.addTERecipe(72000, new ItemStack(Block.field_94341_cq), new FluidStack(TEFluids.fluidRedstone, 900));
        CrucibleManager.addTERecipe(20000, new ItemStack(Item.field_77751_aT), new FluidStack(TEFluids.fluidGlowstone, 250));
        CrucibleManager.addTERecipe(80000, new ItemStack(Block.field_72014_bd), new FluidStack(TEFluids.fluidGlowstone, 1000));
        CrucibleManager.addTERecipe(20000, new ItemStack(Item.field_77730_bn), new FluidStack(TEFluids.fluidEnder, 250));
        CrucibleManager.addTERecipe(20000, TEItems.dustPyrotheum, new FluidStack(TEFluids.fluidPyrotheum, 250));
        CrucibleManager.addTERecipe(20000, TEItems.dustCryotheum, new FluidStack(TEFluids.fluidCryotheum, 250));
        CrucibleManager.addTERecipe(8000, TEItems.dustCoal, new FluidStack(TEFluids.fluidCoal, 100));
    }

    public static void loadRecipes() {
        CrucibleManager.addDefaultRecipes();
    }

    public static boolean addTERecipe(int energy, ItemStack input, FluidStack output) {
        if (input == null || output == null || output.amount <= 0 || energy <= 0) {
            return false;
        }
        RecipeCrucible recipe = new RecipeCrucible(input, output, energy);
        recipeMap.put(new ComparableItemStackSafe(input), recipe);
        return true;
    }

    public static boolean addRecipe(int energy, ItemStack input, FluidStack output, boolean overwrite) {
        if (input == null || output == null || output.amount <= 0 || energy <= 0 || !(allowOverwrite & overwrite) && CrucibleManager.recipeExists(input)) {
            return false;
        }
        RecipeCrucible recipe = new RecipeCrucible(input, output, energy);
        recipeMap.put(new ComparableItemStackSafe(input), recipe);
        return true;
    }

    public static void addOreDictionaryRecipe(int energy, String oreName, int stackSize, FluidStack output) {
        ArrayList registeredOres = OreDictionary.getOres((String)oreName);
        for (int i = 0; i < registeredOres.size(); ++i) {
            CrucibleManager.addTERecipe(energy, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredOres.get(i)), (int)stackSize), output);
        }
    }

    public static boolean addRecipe(int energy, ItemStack input, FluidStack output) {
        return CrucibleManager.addRecipe(energy, input, output, false);
    }

    static {
        allowOverwrite = ThermalExpansion.config.get("tweak.crafting", "Crucible.AllowRecipeOverwrite", false);
    }

    public static class RecipeCrucible {
        final ItemStack input;
        final FluidStack output;
        final int energy;

        RecipeCrucible(ItemStack input, FluidStack output, int energy) {
            this.input = input;
            this.output = output;
            this.energy = energy;
        }

        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        public FluidStack getOutput() {
            return this.output.copy();
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

