/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.tracks;

import java.util.List;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.ITrackItemIconProvider;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public final class TrackSpec {
    public static Block blockTrack;
    private final String tag;
    private final short trackId;
    private final List<String> tooltip;
    private final ITrackItemIconProvider iconProvider;
    private final Class<? extends ITrackInstance> instanceClass;

    public TrackSpec(short trackId, String tag, ITrackItemIconProvider iconProvider, Class<? extends ITrackInstance> instanceClass) {
        this(trackId, tag, iconProvider, instanceClass, null);
    }

    public TrackSpec(short trackId, String tag, ITrackItemIconProvider iconProvider, Class<? extends ITrackInstance> instanceClass, List<String> tooltip) {
        this.trackId = trackId;
        this.tag = tag;
        this.iconProvider = iconProvider;
        this.instanceClass = instanceClass;
        this.tooltip = tooltip;
    }

    public String getTrackTag() {
        return this.tag;
    }

    public short getTrackId() {
        return this.trackId;
    }

    public ItemStack getItem() {
        return this.getItem(1);
    }

    public ItemStack getItem(int qty) {
        if (blockTrack != null) {
            return new ItemStack(blockTrack, qty, (int)this.getTrackId());
        }
        return null;
    }

    public ITrackInstance createInstanceFromSpec() {
        try {
            return this.instanceClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Improper Track Instance Constructor");
        }
    }

    public Icon getIcon() {
        if (this.iconProvider == null) {
            return Block.field_72056_aG.func_71858_a(0, 0);
        }
        return this.iconProvider.getTrackItemIcon(this);
    }

    public List<String> getItemToolTip() {
        return this.tooltip;
    }
}

