/*
 * Decompiled with CFR 0.152.
 */
package src.train.client.core.helpers;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.util.ResourceLocation;
import src.train.client.core.handlers.ClientTickHandler;

public class CapesHelper
extends Thread {
    public String username;
    public boolean MCCape = true;
    public boolean isStatic = false;
    public boolean isAnimated = false;
    public String staticUrl;
    public ArrayList<String> animatedFrameUrls;
    public ResourceLocation staticRL;
    public ResourceLocation[] animatedFramesRL;
    public ThreadDownloadImageData staticImage;
    public ThreadDownloadImageData[] animatedFramesImages;
    public int currFrame;
    public long lastFrameTime;
    public int animInterval = 500;
    public static HashMap<String, CapesHelper> users = new HashMap();
    public static boolean isLoaded = false;

    public CapesHelper(String username) {
        this.username = username;
    }

    @Override
    public void run() {
        try {
            String line;
            URL url = new URL("https://dl.dropbox.com/u/25602663/Traincraft/Capes/" + this.username.toLowerCase() + "_cape.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            int sub = 3;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("SU")) {
                    this.isStatic = true;
                    this.staticUrl = line.substring(sub);
                    continue;
                }
                if (line.startsWith("AU")) {
                    this.isAnimated = true;
                    if (this.animatedFrameUrls == null) {
                        this.animatedFrameUrls = new ArrayList();
                    }
                    this.animatedFrameUrls.add(line.substring(sub));
                    continue;
                }
                if (!line.startsWith("AI")) continue;
                this.animInterval = Integer.parseInt(line.substring(sub));
            }
            reader.close();
            this.dlImages();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dlImages() {
        if (this.isAnimated) {
            this.animatedFramesRL = new ResourceLocation[this.animatedFrameUrls.size()];
            this.animatedFramesImages = new ThreadDownloadImageData[this.animatedFrameUrls.size()];
            for (int i = 0; i < this.animatedFrameUrls.size(); ++i) {
                this.animatedFramesRL[i] = ClientTickHandler.capeAnimatedRL(this.username, i + 1);
                this.animatedFramesImages[i] = ClientTickHandler.dlImage(this.animatedFramesRL[i], this.animatedFrameUrls.get(i));
            }
        } else if (this.isStatic) {
            this.staticRL = ClientTickHandler.capeStaticRL(this.username);
            this.staticImage = ClientTickHandler.dlImage(this.staticRL, this.staticUrl);
        } else {
            this.MCCape = false;
        }
        isLoaded = true;
    }

    public ThreadDownloadImageData getCurrentImage() {
        if (this.isAnimated) {
            long time = Minecraft.func_71386_F();
            if (time > this.lastFrameTime + (long)this.animInterval) {
                this.lastFrameTime = time;
                ++this.currFrame;
                if (this.currFrame >= this.animatedFramesImages.length) {
                    this.currFrame = 0;
                }
            }
            return this.animatedFramesImages[this.currFrame];
        }
        return this.staticImage;
    }

    public ResourceLocation getCurrentRL() {
        if (this.isAnimated) {
            return this.animatedFramesRL[this.currFrame];
        }
        return this.staticRL;
    }
}

