/*
 * Decompiled with CFR 0.152.
 */
package src.train.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import src.train.client.gui.GuiTCTextField;
import src.train.common.core.handlers.PacketHandler;
import src.train.common.entity.rollingStock.EntityJukeBoxCart;

public class GuiJukebox
extends GuiScreen {
    private GuiTCTextField streamTextBox;
    private EntityJukeBoxCart jukebox;
    private EntityPlayer player;
    public boolean exists = true;
    private GuiButton buttonLock;
    private int gui_width;
    private int gui_height;
    private int gui_inner_width;
    private int gui_inner_height;
    private int anim = 0;
    private String infoText;
    private boolean flash;
    private float volume = 1.0f;

    public GuiJukebox(EntityPlayer player, EntityJukeBoxCart jukebox) {
        this.jukebox = jukebox;
        this.player = player;
        this.gui_width = 352;
        this.gui_height = 120;
        this.gui_inner_width = this.gui_width - 40;
        this.gui_inner_height = 20;
        this.infoText = "Paste the link below. (Only .m3u and .pls radio streams)";
    }

    public void func_73866_w_() {
        this.field_73887_h.clear();
        this.field_73887_h.add(new GuiButton(0, this.field_73880_f / 2 - 45, this.field_73881_g / 2 + 30, 90, 20, "Play/Pause"));
        this.field_73887_h.add(new GuiButton(1, this.field_73880_f / 2 - 45 - 120, this.field_73881_g / 2 + 30, 90, 20, "Paste"));
        this.field_73887_h.add(new GuiButton(2, this.field_73880_f / 2 - 45 + 120, this.field_73881_g / 2 + 30, 90, 20, "Clear"));
        this.field_73887_h.add(new GuiButton(4, this.field_73880_f / 2 - 70, this.field_73881_g / 2 + 30, 20, 20, "+"));
        this.field_73887_h.add(new GuiButton(5, this.field_73880_f / 2 + 50, this.field_73881_g / 2 + 30, 20, 20, "-"));
        this.streamTextBox = new GuiTCTextField(this.field_73886_k, this.field_73880_f / 2 - this.gui_width / 2 + 10, this.field_73881_g / 2 - this.gui_height / 2 + 50, this.gui_width - 16, 16);
        this.streamTextBox.setMaxStringLength(1000);
        this.streamTextBox.setText(this.jukebox.streamURL);
        Keyboard.enableRepeatEvents((boolean)true);
        int var1 = (this.field_73880_f - this.gui_width) / 2;
        int var2 = (this.field_73881_g - this.gui_height) / 2;
        if (!this.jukebox.locked) {
            this.buttonLock = new GuiButton(3, var1 + this.gui_width - 350, var2 - 10, 51, 10, "Unlocked");
            this.field_73887_h.add(this.buttonLock);
        } else {
            this.buttonLock = new GuiButton(3, var1 + this.gui_width - 350, var2 - 10, 43, 10, "Locked");
            this.field_73887_h.add(this.buttonLock);
        }
    }

    public void func_73874_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        int var5 = this.field_73880_f / 2 - this.gui_width / 2;
        int var6 = this.field_73881_g / 2 - this.gui_height / 2;
        int var7 = this.field_73880_f / 2 + this.gui_width / 2;
        int var8 = this.field_73881_g / 2 + this.gui_height / 2;
        GuiJukebox.func_73734_a((int)(var5 + 2), (int)(var6 + 2), (int)(var7 + 2), (int)(var8 + 2), (int)-3750202);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_110577_a(new ResourceLocation("tc", "textures/gui/gui_jukebox.png"));
        this.drawSquareCorners(2, 2, var5, var6, var7, var8, 0, 0);
        this.drawSquareCorners(-6, -20, var5, var6 + 26, var7, var8 - this.gui_height / 2 + 26, 10, 0);
        this.drawSquareSides(this.gui_width, this.gui_height, 2, 2, var5, var6, var7, var8, 0, 0);
        this.drawSquareSides(this.gui_width - 16, 16, 2, 2, var5 + 8, var6 + 22 + 26, var7 - 8, var8 - this.gui_height / 2 - 32 + 36, 10, 0);
        this.func_73729_b(var5 + 6, var6 + 6, 20, 0, 7, 10);
        this.func_73729_b(var5 + 13, var6 + 6, 0 + this.anim / 100, 12, 28 * (this.gui_width / 28) / 2, 10);
        this.func_73729_b(var5 + 13 + 28 * (this.gui_width / 28) / 2, var6 + 6, 0 + this.anim / 100, 12, 28 * (this.gui_width / 28) / 2, 10);
        if (this.jukebox.isPlaying) {
            this.anim += 10;
            if (this.anim == 2800) {
                this.anim = 0;
            }
        }
        if (Minecraft.func_71410_x().field_71439_g != null && this.jukebox.player != null && !this.jukebox.isInvalid) {
            this.field_73886_k.func_78276_b("Volume: " + (int)Math.ceil(this.jukebox.volume * 100.0f), this.field_73880_f / 2 - 26, this.field_73881_g / 2 + 18, -15856114);
        } else {
            this.field_73886_k.func_78276_b("Volume: 0", this.field_73880_f / 2 - 26, this.field_73881_g / 2 + 18, -15856114);
        }
        this.setText(-15856114);
        super.func_73863_a(par1, par2, par3);
        this.streamTextBox.drawTextBox();
        if (this.intersectsWith(par1, par2)) {
            this.drawCreativeTabHoveringText("When a jukebox is locked,", par1, par2);
        }
    }

    private void setText(int color) {
        this.field_73886_k.func_78276_b(this.infoText, this.field_73880_f / 2 - this.gui_width / 2 + 10, this.field_73881_g / 2 - 30, color);
    }

    public void drawSquareCorners(int x, int y, int x0y0, int x1y0, int x0y1, int x1y1, int u, int v) {
        this.field_73882_e.field_71446_o.func_110577_a(new ResourceLocation("tc", "textures/gui/gui_jukebox.png"));
        this.func_73729_b(x0y0 - x, x1y0 - y, u, v, 4, 4);
        this.func_73729_b(x0y1 + x, x1y0 - y, u + 5, v, 4, 4);
        this.func_73729_b(x0y0 - x, x1y1 + y, u, v + 5, 4, 4);
        this.func_73729_b(x0y1 + x, x1y1 + y, u + 5, v + 5, 4, 4);
    }

    public void drawSquareSides(int width, int height, int x, int y, int x0y0, int x1y0, int x0y1, int x1y1, int u, int v) {
        this.field_73882_e.field_71446_o.func_110577_a(new ResourceLocation("tc", "textures/gui/gui_jukebox.png"));
        int sides = width >= height ? width : height;
        for (int i = 0; i < sides; ++i) {
            if (width > height) {
                if (i < height) {
                    this.func_73729_b(x0y0 - x, x1y0 + y + i, u, v + 4, 4, 1);
                    this.func_73729_b(x0y1 + x, x1y0 + y + i, u + 5, v + 4, 4, 1);
                }
                this.func_73729_b(x0y0 + x + i, x1y0 - y, u + 4, v, 1, 4);
                this.func_73729_b(x0y0 + x + i, x1y1 + y, u + 4, v + 5, 1, 4);
                continue;
            }
            if (i < width) {
                this.func_73729_b(x0y0 + x + i, x1y0 - y, u + 4, v, 1, 4);
                this.func_73729_b(x0y0 + x + i, x1y1 + y, u + 4, v + 5, 1, 4);
            }
            this.func_73729_b(x0y0 - x, x1y0 + y + i, u, v + 4, 4, 1);
            this.func_73729_b(x0y1 + x, x1y0 + y + i, u + 5, v + 4, 4, 1);
        }
    }

    public void func_73876_c() {
        this.streamTextBox.updateCursorCounter();
        if (this.jukebox.isInvalid) {
            this.field_73882_e.func_71373_a((GuiScreen)null);
            this.field_73882_e.func_71381_h();
        }
        super.func_73876_c();
    }

    public void customStop() {
        this.jukebox.stopStream();
    }

    protected void func_73869_a(char par1, int par2) {
        this.streamTextBox.textboxKeyTyped(par1, par2);
        if (par1 == '\u001c') {
            this.func_73875_a((GuiButton)this.field_73887_h.get(1));
        }
        if (!(par2 != 1 && par2 != this.field_73882_e.field_71474_y.field_74315_B.field_74512_d || this.streamTextBox.isFocused())) {
            this.field_73882_e.field_71439_g.func_71053_j();
        }
        super.func_73869_a(par1, par2);
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        this.streamTextBox.mouseClicked(par1, par2, par3);
        super.func_73864_a(par1, par2, par3);
    }

    @SideOnly(value=Side.CLIENT)
    protected void func_73875_a(GuiButton button) {
        if (button.field_73741_f == 0) {
            if (this.streamTextBox.getText() != null && this.streamTextBox.getText().length() > 0) {
                if (!this.jukebox.isPlaying()) {
                    this.jukebox.streamURL = this.streamTextBox.getText().toLowerCase().endsWith(".m3u") ? this.takeFirstEntryFromM3U(this.streamTextBox.getText()) : (this.streamTextBox.getText().toLowerCase().endsWith(".pls") ? this.parsePls(this.streamTextBox.getText()) : this.streamTextBox.getText());
                    PacketHandler.setJukeBoxStreamingUrl(this.player, (Entity)this.jukebox, this.jukebox.streamURL, true);
                    this.jukebox.startStream();
                } else {
                    PacketHandler.setJukeBoxStreamingUrl(this.player, (Entity)this.jukebox, this.jukebox.streamURL, false);
                    this.jukebox.stopStream();
                }
            } else if (this.jukebox.isPlaying) {
                PacketHandler.setJukeBoxStreamingUrl(this.player, (Entity)this.jukebox, this.jukebox.streamURL, false);
                this.jukebox.stopStream();
            }
        }
        if (button.field_73741_f == 1) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Clipboard clipboard = toolkit.getSystemClipboard();
            try {
                String result = (String)clipboard.getData(DataFlavor.stringFlavor);
                this.streamTextBox.setText(result);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (button.field_73741_f == 2) {
            this.streamTextBox.setText("");
            this.streamTextBox.setFocused(true);
        }
        if (button.field_73741_f == 4 && Minecraft.func_71410_x().field_71439_g != null && this.jukebox.player != null && !this.jukebox.isInvalid && this.jukebox.volume < 1.0f) {
            this.jukebox.volume += 0.1f;
        }
        if (button.field_73741_f == 5 && Minecraft.func_71410_x().field_71439_g != null && this.jukebox.player != null && !this.jukebox.isInvalid && this.jukebox.volume > 0.0f) {
            this.jukebox.volume -= 0.1f;
        }
        if (button.field_73741_f == 3) {
            if (this.player != null && this.player instanceof EntityPlayer && this.player.field_71092_bJ.toLowerCase().equals(this.jukebox.trainOwner.toLowerCase())) {
                List lis3;
                AxisAlignedBB box;
                if (!this.jukebox.locked) {
                    box = this.jukebox.field_70121_D.func_72314_b(5.0, 5.0, 5.0);
                    lis3 = this.jukebox.field_70170_p.func_72839_b((Entity)this.jukebox, box);
                    if (lis3 != null && lis3.size() > 0) {
                        for (int j1 = 0; j1 < lis3.size(); ++j1) {
                            Entity entity = (Entity)lis3.get(j1);
                            if (!(entity instanceof EntityPlayer)) continue;
                            this.jukebox.sendTrainLockedPacket((EntityPlayer)entity, true);
                        }
                    }
                    this.jukebox.locked = true;
                    button.field_73744_e = "Locked";
                    this.func_73866_w_();
                } else {
                    box = this.jukebox.field_70121_D.func_72314_b(5.0, 5.0, 5.0);
                    lis3 = this.jukebox.field_70170_p.func_72839_b((Entity)this.jukebox, box);
                    if (lis3 != null && lis3.size() > 0) {
                        for (int j1 = 0; j1 < lis3.size(); ++j1) {
                            Entity entity = (Entity)lis3.get(j1);
                            if (!(entity instanceof EntityPlayer)) continue;
                            this.jukebox.sendTrainLockedPacket((EntityPlayer)entity, false);
                        }
                    }
                    this.jukebox.locked = false;
                    button.field_73744_e = "UnLocked";
                    this.func_73866_w_();
                }
            } else if (this.player != null && this.player instanceof EntityPlayer) {
                this.player.func_71035_c("You are not the owner");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getState() {
        return this.jukebox.isPlaying();
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void drawCreativeTabHoveringText(String str, int t, int g) {
        String state = "";
        if (this.jukebox.locked) {
            state = "Locked";
        }
        if (!this.jukebox.locked) {
            state = "Unlocked";
        }
        int textWidth = this.field_73886_k.func_78256_a("When a jukebox is unlocked,") + 2;
        int i4 = -267386864;
        this.func_73733_a(t + 15 - 3, g - 40 - 4, t + textWidth + 3, g + 8 + 4, i4, i4);
        this.func_73733_a(t + 15 - 4, g - 40 - 3, t + textWidth + 4, g + 8 + 3, i4, i4);
        int colour1 = 0x505000FF;
        int colour2 = (colour1 & 0xFEFEFE) >> 1 | colour1 & 0xFF000000;
        this.func_73733_a(t + 15 - 3, g - 40 - 3, t + textWidth + 3, g + 8 + 3, colour1, colour2);
        this.func_73733_a(t + 15 - 2, g - 40 - 2, t + textWidth + 2, g + 8 + 2, i4, i4);
        this.field_73886_k.func_78261_a(str, t + 15, g - 40, -1);
        this.field_73886_k.func_78261_a("only its owner can open", t + 15, g + 10 - 40, -1);
        this.field_73886_k.func_78261_a("the GUI and destroy it.", t + 15, g + 20 - 40, -1);
        this.field_73886_k.func_78261_a("Current state: " + state, t + 15, g + 30 - 40, -1);
        this.field_73886_k.func_78261_a("Owner: " + this.jukebox.trainOwner.trim(), t + 15, g + 40 - 40, -1);
    }

    public boolean intersectsWith(int mouseX, int mouseY) {
        int j = (this.field_73880_f - this.gui_width) / 2;
        int k = (this.field_73881_g - this.gui_height) / 2;
        return mouseX >= j + this.gui_width - 350 && mouseX <= j + this.gui_width - 300 && mouseY >= k - 10 && mouseY <= k;
    }

    public String takeFirstEntryFromM3U(String m3uurl) {
        String out = "";
        try {
            String mp3;
            URL m3u = new URL(m3uurl);
            URLConnection con = m3u.openConnection();
            BufferedReader i = new BufferedReader(new InputStreamReader(con.getInputStream()));
            while ((mp3 = i.readLine()) != null && mp3.startsWith("#")) {
            }
            out = mp3;
        }
        catch (IOException e) {
            this.infoText = "Not a valid stream, only .m3u and .pls";
        }
        return out;
    }

    public String parsePls(String plsurl) {
        String out = "";
        try {
            String mp3;
            URL pls = new URL(plsurl);
            URLConnection con = pls.openConnection();
            BufferedReader i = new BufferedReader(new InputStreamReader(con.getInputStream()));
            while ((mp3 = i.readLine()) != null) {
                String f = mp3.trim();
                if (!f.contains("http://")) continue;
                out = f.substring(f.indexOf("http://"));
                break;
            }
        }
        catch (IOException e) {
            this.infoText = "Not a valid stream, only .m3u and .pls";
        }
        return out;
    }
}

