/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.api;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mods.railcraft.api.carts.IMinecart;
import mods.railcraft.api.carts.IRoutableCart;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import src.train.common.Traincraft;
import src.train.common.api.AbstractWorkCart;
import src.train.common.api.EntityRollingStock;
import src.train.common.api.IPassenger;
import src.train.common.api.Locomotive;
import src.train.common.core.handlers.ChunkHandler;
import src.train.common.core.handlers.ConfigHandler;
import src.train.common.core.handlers.PacketHandler;
import src.train.common.core.handlers.RollingStockStatsEventHandler;
import src.train.common.core.handlers.TraincraftSaveHandler;
import src.train.common.items.ItemChunkLoaderActivator;
import src.train.common.library.EnumTrains;

public abstract class AbstractTrains
extends EntityMinecart
implements IMinecart,
IRoutableCart {
    protected int color = -1;
    private float trainSpeed = 1.2f;
    public boolean isAttached = false;
    public boolean isAttaching = false;
    public int ID;
    public static int numberOfTrains;
    public EntityPlayer playerEntity;
    public double Link1;
    public double Link2;
    public EntityRollingStock cartLinked1;
    public EntityRollingStock cartLinked2;
    private Set chunks;
    protected float renderYaw;
    protected float renderPitch;
    protected EnumTrains trainSpec;
    public String trainName = "";
    public double accelerate = 0.7;
    public double brake = 0.96;
    public double mass = 1.0;
    public double defaultMass = 1.0;
    public int power = 0;
    public boolean locked = false;
    public String trainOwner = "";
    public String trainCreator = "";
    public String trainType = "";
    protected String trainDestroyer = "";
    public int uniqueID = -1;
    public static int uniqueIDs;
    public double trainDistanceTraveled = 0.0;
    public String destination = "";
    protected ForgeChunkManager.Ticket ticket;
    public ArrayList<Integer> acceptedColors;
    protected RollingStockStatsEventHandler statsEventHandler = new RollingStockStatsEventHandler(this);

    public String getTrainOwner() {
        return this.trainOwner;
    }

    public void setTrainOwner(String trainOwner) {
        this.trainOwner = trainOwner;
    }

    public AbstractTrains(World world) {
        super(world);
        this.field_70180_af.func_75682_a(12, (Object)this.color);
        this.acceptedColors = new ArrayList();
        if (!world.field_72995_K) {
            this.ID = ++numberOfTrains;
        }
        this.field_70180_af.func_75682_a(5, (Object)this.ID);
        this.field_70180_af.func_75682_a(6, (Object)String.valueOf(this.trainType));
        this.field_70180_af.func_75682_a(7, (Object)String.valueOf(this.trainOwner));
        this.field_70180_af.func_75682_a(8, (Object)String.valueOf(this.trainDestroyer));
        this.field_70180_af.func_75682_a(9, (Object)String.valueOf(this.trainName));
        this.field_70180_af.func_75682_a(10, (Object)numberOfTrains);
        this.field_70180_af.func_75682_a(11, (Object)this.uniqueID);
        this.field_70180_af.func_75682_a(13, (Object)String.valueOf(this.trainCreator));
        for (EnumTrains trains : EnumTrains.values()) {
            if (!trains.getEntityClass().equals(this.getClass())) continue;
            this.setDefaultMass(trains.getMass());
            this.trainSpec = trains;
            if (trains.getColors() != null) {
                for (int i = 0; i < trains.getColors().length; ++i) {
                    this.acceptedColors.add(AbstractTrains.getColorFromString(trains.getColors()[i]));
                }
            }
            this.func_70105_a((float)this.trainSpec.getWidth(), (float)this.trainSpec.getHeight());
        }
    }

    public abstract boolean isLocomotive();

    public abstract boolean isPassenger();

    public abstract boolean isFreightCart();

    public abstract boolean isFreightOrPassenger();

    public abstract boolean isBuilder();

    public abstract boolean isTender();

    public abstract boolean isWorkCart();

    public abstract boolean isElectricTrain();

    public abstract boolean isLinked();

    protected abstract boolean canOverheat();

    protected abstract int getOverheatTime();

    public abstract float getLinkageDistance(EntityMinecart var1);

    public abstract int getID();

    public abstract boolean canBeAdjusted(EntityMinecart var1);

    public abstract float getOptimalDistance(EntityMinecart var1);

    public abstract List<ItemStack> getItemsDropped();

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.uniqueID == -1 && FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
            TraincraftSaveHandler.createFile(FMLCommonHandler.instance().getMinecraftServerInstance());
            int readID = TraincraftSaveHandler.readInt(FMLCommonHandler.instance().getMinecraftServerInstance(), "numberOfTrains:");
            int newID = this.setNewUniqueID(readID);
            TraincraftSaveHandler.writeValue(FMLCommonHandler.instance().getMinecraftServerInstance(), "numberOfTrains:", new String("" + newID));
            this.statsEventHandler.trainPlace(newID, this.trainName, this.trainType, this.trainOwner, this.trainOwner, new String((int)this.field_70165_t + ";" + (int)this.field_70163_u + ";" + (int)this.field_70161_v));
        }
        this.statsEventHandler.trainDistance();
        if (!this.func_70083_f(7)) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.func_70083_f(6) && this.chunks == null) {
                this.setupChunks(this.field_70176_ah, this.field_70164_aj);
            }
        } else if (!ConfigHandler.CHUNK_LOADING) {
            this.releaseTicket();
        } else if (this.ticket == null) {
            this.requestTicket();
        }
    }

    public int setNewUniqueID(int numberOfTrains) {
        if (numberOfTrains <= 0) {
            numberOfTrains = uniqueIDs++;
        } else {
            uniqueIDs = numberOfTrains++;
        }
        this.uniqueID = numberOfTrains;
        this.getEntityData().func_74768_a("uniqueID", numberOfTrains);
        return numberOfTrains;
    }

    public boolean func_130002_c(EntityPlayer entityplayer) {
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (!this.field_70170_p.field_72995_K && ConfigHandler.CHUNK_LOADING && itemstack != null && itemstack.func_77973_b() instanceof ItemChunkLoaderActivator) {
            if (this.func_70083_f(7)) {
                this.func_70052_a(7, false);
                entityplayer.func_71035_c("Stop loading chunks");
            } else if (!this.func_70083_f(7)) {
                this.func_70052_a(7, true);
                entityplayer.func_71035_c("Start loading chunks");
            }
            itemstack.func_77972_a(1, (EntityLivingBase)entityplayer);
            return true;
        }
        return false;
    }

    public void setColor(int color) {
        this.field_70180_af.func_75692_b(12, (Object)color);
    }

    public void setRenderYaw(float yaw) {
        this.renderYaw = yaw;
    }

    public void setRenderPitch(float pitch) {
        this.renderPitch = pitch;
    }

    public int getColor() {
        return this.field_70180_af.func_75679_c(12);
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("color", this.getColor());
        nbttagcompound.func_74757_a("chunkLoadingState", this.func_70083_f(7));
        nbttagcompound.func_74780_a("trainDistanceTraveled", this.trainDistanceTraveled);
        nbttagcompound.func_74778_a("theOwner", this.trainOwner);
        nbttagcompound.func_74757_a("Locked", this.locked);
        nbttagcompound.func_74778_a("theCreator", this.trainCreator);
        nbttagcompound.func_74778_a("theName", this.trainName);
        nbttagcompound.func_74778_a("theType", this.trainType);
        nbttagcompound.func_74768_a("uniqueID", this.uniqueID);
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        this.setColor(nbttagcompound.func_74762_e("color"));
        this.func_70052_a(7, nbttagcompound.func_74767_n("chunkLoadingState"));
        this.trainDistanceTraveled = nbttagcompound.func_74769_h("trainDistanceTraveled");
        this.trainOwner = nbttagcompound.func_74779_i("theOwner");
        this.locked = nbttagcompound.func_74767_n("Locked");
        this.func_70052_a(8, this.locked);
        this.trainCreator = nbttagcompound.func_74779_i("theCreator");
        this.trainName = nbttagcompound.func_74779_i("theName");
        this.trainType = nbttagcompound.func_74779_i("theType");
        this.uniqueID = nbttagcompound.func_74762_e("uniqueID");
        ((EntityRollingStock)this).setInformation(this.trainType, this.trainOwner, this.trainCreator, this.trainName, this.uniqueID);
    }

    protected ForgeChunkManager.Ticket getTicketFromForge() {
        return ForgeChunkManager.requestTicket((Object)Traincraft.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
    }

    protected void releaseTicket() {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        this.ticket = null;
        this.func_70052_a(6, false);
    }

    private boolean requestTicket() {
        ForgeChunkManager.Ticket var1 = this.getTicketFromForge();
        if (var1 != null) {
            var1.getModData();
            var1.setChunkListDepth(12);
            var1.bindEntity((Entity)this);
            this.setChunkTicket(var1);
            return true;
        }
        return false;
    }

    public void setChunkTicket(ForgeChunkManager.Ticket var1) {
        if (this.ticket != var1) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        }
        this.ticket = var1;
        this.func_70052_a(6, this.ticket != null);
    }

    public void forceChunkLoading(int var1, int var2) {
        if (this.ticket != null) {
            this.setupChunks(var1, var2);
            for (ChunkCoordIntPair var4 : this.chunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)var4);
            }
            ChunkCoordIntPair var5 = new ChunkCoordIntPair(var1, var2);
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)var5);
            ForgeChunkManager.reorderChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)var5);
        }
    }

    public void setupChunks(int var1, int var2) {
        this.chunks = this.func_70083_f(6) ? ChunkHandler.getInstance().getChunksAround(var1, var2, 1) : null;
    }

    public static String getColorAsString(int i) {
        switch (i) {
            case 0: {
                return "Black";
            }
            case 1: {
                return "Red";
            }
            case 2: {
                return "Green";
            }
            case 3: {
                return "Brown";
            }
            case 4: {
                return "Blue";
            }
            case 5: {
                return "Purple";
            }
            case 6: {
                return "Cyan";
            }
            case 7: {
                return "LightGrey";
            }
            case 8: {
                return "Grey";
            }
            case 13: {
                return "Magenta";
            }
            case 10: {
                return "LightGreen";
            }
            case 11: {
                return "Yellow";
            }
            case 12: {
                return "LightBlue";
            }
            case 9: {
                return "Pink";
            }
            case 14: {
                return "Orange";
            }
            case 15: {
                return "White";
            }
            case 100: {
                return "Empty";
            }
            case 101: {
                return "Full";
            }
        }
        return "" + i;
    }

    public String getColorAsString() {
        switch (this.getColor()) {
            case 0: {
                return "Black";
            }
            case 1: {
                return "Red";
            }
            case 2: {
                return "Green";
            }
            case 3: {
                return "Brown";
            }
            case 4: {
                return "Blue";
            }
            case 5: {
                return "Purple";
            }
            case 6: {
                return "Cyan";
            }
            case 7: {
                return "LightGrey";
            }
            case 8: {
                return "Grey";
            }
            case 13: {
                return "Magenta";
            }
            case 10: {
                return "LightGreen";
            }
            case 11: {
                return "Yellow";
            }
            case 12: {
                return "LightBlue";
            }
            case 9: {
                return "Pink";
            }
            case 14: {
                return "Orange";
            }
            case 15: {
                return "White";
            }
            case 100: {
                return "Empty";
            }
            case 101: {
                return "Full";
            }
        }
        return "" + this.getColor();
    }

    public static int getColorFromString(String color) {
        if (color.equals("Black")) {
            return 0;
        }
        if (color.equals("Red")) {
            return 1;
        }
        if (color.equals("Green")) {
            return 2;
        }
        if (color.equals("Brown")) {
            return 3;
        }
        if (color.equals("Blue")) {
            return 4;
        }
        if (color.equals("Purple")) {
            return 5;
        }
        if (color.equals("Cyan")) {
            return 6;
        }
        if (color.equals("LightGrey")) {
            return 7;
        }
        if (color.equals("Grey")) {
            return 8;
        }
        if (color.equals("Magenta")) {
            return 13;
        }
        if (color.equals("LightGreen")) {
            return 10;
        }
        if (color.equals("Yellow")) {
            return 11;
        }
        if (color.equals("LightBlue")) {
            return 12;
        }
        if (color.equals("Pink")) {
            return 9;
        }
        if (color.equals("Orange")) {
            return 14;
        }
        if (color.equals("White")) {
            return 15;
        }
        if (color.equals("Empty")) {
            return 100;
        }
        if (color.equals("Full")) {
            return 101;
        }
        return -1;
    }

    public void dropCartAsItem() {
        for (ItemStack item : this.getItemsDropped()) {
            this.setUniqueIDToItem(item);
            this.func_70099_a(item, 0.0f);
        }
    }

    protected void setUniqueIDToItem(ItemStack stack) {
        NBTTagCompound var3 = stack.func_77978_p();
        if (var3 == null) {
            var3 = new NBTTagCompound();
            stack.func_77982_d(var3);
        }
        if (this.uniqueID != -1) {
            stack.func_77978_p().func_74768_a("uniqueID", this.uniqueID);
        }
        if (this.trainCreator != null && this.trainCreator.length() > 0) {
            stack.func_77978_p().func_74778_a("trainCreator", this.trainCreator);
        }
        if (this.getColor() != -1) {
            stack.func_77978_p().func_74768_a("trainColor", this.getColor());
        }
    }

    protected void setDefaultMass(double def) {
        this.mass = def;
        this.defaultMass = def;
    }

    protected double getDefaultMass() {
        return this.defaultMass;
    }

    public void setTrainLockedFromPacket(boolean set) {
        this.locked = set;
    }

    public void setTrainLockedFromPacket(boolean set, String owner) {
        this.locked = set;
        this.trainOwner = owner;
    }

    public boolean getTrainLockedFromPacket() {
        return this.locked;
    }

    public void sendTrainLockedPacket(EntityPlayer entity, boolean locked) {
        PacketHandler.setTrainLocked((Entity)entity, (Entity)this, locked);
    }

    protected boolean lockThisCart(ItemStack itemstack, EntityPlayer entityplayer) {
        if (itemstack != null && itemstack.func_77973_b() instanceof IToolWrench) {
            if (entityplayer.field_71092_bJ.toLowerCase().equals(this.trainOwner.toLowerCase())) {
                if (this.locked) {
                    this.locked = false;
                    entityplayer.func_71035_c("unlocked");
                } else if (!this.locked) {
                    this.locked = true;
                    entityplayer.func_71035_c("locked");
                }
            } else {
                entityplayer.func_71035_c("You are not the owner!");
            }
            return true;
        }
        return false;
    }

    protected boolean canBeRiddenWhileLocked(AbstractTrains train) {
        return train instanceof Locomotive || train instanceof IPassenger || train instanceof AbstractWorkCart;
    }

    protected boolean canBeDestroyedByPlayer(DamageSource damagesource) {
        if (this.getTrainLockedFromPacket()) {
            if (damagesource.func_76346_g() instanceof EntityPlayer) {
                if (damagesource.func_76346_g() instanceof EntityPlayerMP && MinecraftServer.func_71276_C() != null && MinecraftServer.func_71276_C().func_71203_ab() != null && MinecraftServer.func_71276_C().func_71203_ab().func_72353_e(((EntityPlayer)damagesource.func_76346_g()).field_71092_bJ) && ((EntityPlayer)damagesource.func_76346_g()).field_71071_by.func_70448_g() != null && ((EntityPlayer)damagesource.func_76346_g()).field_71071_by.func_70448_g().func_77973_b() instanceof IToolWrench) {
                    ((EntityPlayer)damagesource.func_76346_g()).func_71035_c("Removing the train using OP permission");
                } else if (!((EntityPlayer)damagesource.func_76346_g()).field_71092_bJ.toLowerCase().equals(this.trainOwner.toLowerCase())) {
                    ((EntityPlayer)damagesource.func_76346_g()).func_71035_c("You are not the owner!");
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doesCartMatchFilter(ItemStack stack, EntityMinecart cart) {
        if (stack == null || cart == null) {
            return false;
        }
        ItemStack cartItem = cart.getCartItem();
        return cartItem != null && stack.func_77969_a(cartItem);
    }

    @Override
    public String getDestination() {
        return this.destination;
    }

    @Override
    public boolean setDestination(ItemStack ticket) {
        return false;
    }

    public static String getTicketDestination(ItemStack ticket) {
        if (ticket == null) {
            return "";
        }
        NBTTagCompound nbt = ticket.func_77978_p();
        if (nbt == null) {
            return "";
        }
        return nbt.func_74779_i("dest");
    }

    static {
        uniqueIDs = 1;
    }
}

