/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.api;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import src.train.common.Traincraft;
import src.train.common.api.EntityRollingStock;
import src.train.common.core.handlers.ConfigHandler;

public abstract class AbstractWorkCart
extends EntityRollingStock
implements IInventory {
    protected ItemStack[] furnaceItemStacks;
    public int furnaceBurnTime = 0;
    public int currentItemBurnTime = 0;
    public int furnaceCookTime = 0;
    private static int KEY_INV;
    private static int KEY_FURN;

    public AbstractWorkCart(World world) {
        super(world);
        try {
            if (Class.forName("org.lwjgl.input.Keyboard") != null && Keyboard.isCreated()) {
                KEY_FURN = ConfigHandler.Key_Furn;
                KEY_INV = ConfigHandler.Key_Invent;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void func_70071_h_() {
        this.pressKeyClient();
        super.func_70071_h_();
    }

    @Override
    public void pressKeyClient() {
        if (Traincraft.proxy.getCurrentScreen() == null && this.field_70153_n != null && this.field_70153_n.field_70154_o != null && this.field_70153_n.field_70154_o == this) {
            try {
                if (Class.forName("org.lwjgl.input.Keyboard") != null && Keyboard.isCreated()) {
                    if (Keyboard.isKeyDown((int)KEY_INV)) {
                        this.pressKeyTrain(7);
                    }
                    if (Keyboard.isKeyDown((int)KEY_FURN)) {
                        this.pressKeyTrain(9);
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        nbttagcompound.func_74777_a("CookTime", (short)this.furnaceCookTime);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.furnaceItemStacks.length; ++var3) {
            if (this.furnaceItemStacks[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.furnaceItemStacks[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)var2);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        NBTTagList var2 = nbttagcompound.func_74761_m("Items");
        this.furnaceItemStacks = new ItemStack[this.getSizeInventoryWork()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.furnaceItemStacks.length) continue;
            this.furnaceItemStacks[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.furnaceBurnTime = nbttagcompound.func_74765_d("BurnTime");
        this.furnaceCookTime = nbttagcompound.func_74765_d("CookTime");
        this.currentItemBurnTime = AbstractWorkCart.getItemBurnTime(this.furnaceItemStacks[1]);
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int par1) {
        return this.furnaceCookTime * par1 / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int par1) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.furnaceBurnTime * par1 / this.currentItemBurnTime;
    }

    public boolean isBurningFurnace() {
        return this.furnaceBurnTime > 0;
    }

    public void updateBurning() {
        boolean var1 = this.furnaceBurnTime > 0;
        boolean var2 = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.furnaceBurnTime = AbstractWorkCart.getItemBurnTime(this.furnaceItemStacks[1]);
                if (this.furnaceBurnTime > 0) {
                    var2 = true;
                    if (this.furnaceItemStacks[1] != null) {
                        --this.furnaceItemStacks[1].field_77994_a;
                        if (this.furnaceItemStacks[1].field_77994_a == 0) {
                            this.furnaceItemStacks[1] = this.furnaceItemStacks[1].func_77973_b().getContainerItemStack(this.furnaceItemStacks[1]);
                        }
                    }
                }
            }
            if (this.isBurningFurnace() && this.canSmelt()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime == 200) {
                    this.furnaceCookTime = 0;
                    this.smeltItem();
                    var2 = true;
                }
            } else {
                this.furnaceCookTime = 0;
            }
            if (var1 != this.furnaceBurnTime > 0) {
                var2 = true;
            }
        }
    }

    private boolean canSmelt() {
        if (this.furnaceItemStacks[0] == null) {
            return false;
        }
        ItemStack var1 = FurnaceRecipes.func_77602_a().getSmeltingResult(this.furnaceItemStacks[0]);
        if (var1 == null) {
            return false;
        }
        if (this.furnaceItemStacks[2] == null) {
            return true;
        }
        if (!this.furnaceItemStacks[2].func_77969_a(var1)) {
            return false;
        }
        int result = this.furnaceItemStacks[2].field_77994_a + var1.field_77994_a;
        return result <= this.func_70297_j_() && result <= var1.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack var1 = FurnaceRecipes.func_77602_a().getSmeltingResult(this.furnaceItemStacks[0]);
            if (this.furnaceItemStacks[2] == null) {
                this.furnaceItemStacks[2] = var1.func_77946_l();
            } else if (this.furnaceItemStacks[2].func_77969_a(var1)) {
                this.furnaceItemStacks[2].field_77994_a += var1.field_77994_a;
            }
            --this.furnaceItemStacks[0].field_77994_a;
            if (this.furnaceItemStacks[0].field_77994_a <= 0) {
                this.furnaceItemStacks[0] = null;
            }
        }
    }

    public static int getItemBurnTime(ItemStack par0ItemStack) {
        if (par0ItemStack == null) {
            return 0;
        }
        int var1 = par0ItemStack.func_77973_b().field_77779_bT;
        Item var2 = par0ItemStack.func_77973_b();
        if (par0ItemStack.func_77973_b() instanceof ItemBlock && Block.field_71973_m[var1] != null) {
            Block var3 = Block.field_71973_m[var1];
            if (var3 == Block.field_72092_bO) {
                return 150;
            }
            if (var3.field_72018_cp == Material.field_76245_d) {
                return 300;
            }
        }
        if (var2 instanceof ItemTool && ((ItemTool)var2).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (var2 instanceof ItemSword && ((ItemSword)var2).func_77825_f().equals("WOOD")) {
            return 200;
        }
        if (var1 == Item.field_77669_D.field_77779_bT) {
            return 100;
        }
        if (var1 == Item.field_77705_m.field_77779_bT) {
            return 1600;
        }
        if (var1 == Item.field_77775_ay.field_77779_bT) {
            return 20000;
        }
        if (var1 == Block.field_71987_y.field_71990_ca) {
            return 100;
        }
        if (var1 == Item.field_77731_bo.field_77779_bT) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)par0ItemStack);
    }

    public static boolean isItemFuel(ItemStack par0ItemStack) {
        return AbstractWorkCart.getItemBurnTime(par0ItemStack) > 0;
    }

    public int getSizeInventoryWork() {
        return this.furnaceItemStacks.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.furnaceItemStacks[i];
    }

    public ItemStack func_70304_b(int par1) {
        if (this.furnaceItemStacks[par1] != null) {
            ItemStack var2 = this.furnaceItemStacks[par1];
            this.furnaceItemStacks[par1] = null;
            return var2;
        }
        return null;
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.furnaceItemStacks[par1] != null) {
            if (this.furnaceItemStacks[par1].field_77994_a <= par2) {
                ItemStack var3 = this.furnaceItemStacks[par1];
                this.furnaceItemStacks[par1] = null;
                return var3;
            }
            ItemStack var3 = this.furnaceItemStacks[par1].func_77979_a(par2);
            if (this.furnaceItemStacks[par1].field_77994_a == 0) {
                this.furnaceItemStacks[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.furnaceItemStacks[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int func_70302_i_() {
        return 0;
    }

    public void func_70296_d() {
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        if (this.canBeDestroyedByPlayer(damagesource)) {
            return false;
        }
        super.func_70097_a(damagesource, i);
        this.func_70494_i(-this.func_70493_k());
        this.func_70497_h(10);
        this.func_70018_K();
        this.func_70492_c(this.func_70491_i() + i * 10.0f);
        if (this.func_70491_i() > 40.0f) {
            boolean flag;
            if (this.field_70153_n != null) {
                this.field_70153_n.func_70078_a((Entity)this);
            }
            this.func_70106_y();
            boolean bl = flag = damagesource.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)damagesource.func_76346_g()).field_71075_bZ.field_75098_d;
            if (!flag) {
                this.dropCartAsItem();
            }
        }
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }
}

