/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.api;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.railcraft.api.carts.IMinecart;
import mods.railcraft.api.carts.IRoutableCart;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import src.train.common.api.AbstractTrains;
import src.train.common.api.EntityBogieUtility;
import src.train.common.api.EntityRollingStock;

public class EntityBogie
extends EntityMinecart
implements IMinecart,
IRoutableCart {
    public boolean isOnRail = false;
    public float prevDpdx = 0.0f;
    public float prevDpdz = 0.0f;
    public World field_70170_p;
    public int meta;
    public EntityRollingStock entityMainTrain;
    private int updateTicks;
    public int entityMainTrainID;
    protected int bogieIndex;
    public double bogieShift;

    public EntityBogie(World world) {
        super(world);
        this.field_70170_p = world;
        if (this.entityMainTrain != null) {
            this.func_70105_a(this.entityMainTrain.field_70130_N, this.entityMainTrain.field_70131_O);
        } else {
            this.func_70105_a(0.98f, 1.98f);
        }
        EntityBogie.setCollisionHandler(null);
    }

    public EntityBogie(World world, double d, double d1, double d2, EntityRollingStock mainTrain, int id, int index, double bogieShift) {
        this(world);
        this.entityMainTrain = mainTrain;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
        this.entityMainTrainID = id;
        this.bogieIndex = index;
        this.bogieShift = bogieShift;
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
    }

    public boolean func_70104_M() {
        return false;
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return null;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.entityMainTrain != null) {
            return this.entityMainTrain.func_70097_a(par1DamageSource, par2);
        }
        return false;
    }

    public void func_70108_f(Entity par1Entity) {
        if (this.entityMainTrain != null && par1Entity != this.entityMainTrain) {
            this.entityMainTrain.func_70108_f(par1Entity);
        }
    }

    public void func_70071_h_() {
        this.setCurrentCartSpeedCapOnRail(1.8f);
        this.setMaxSpeedAirLateral(1.8f);
        super.func_70071_h_();
        if (this instanceof EntityBogieUtility) {
            return;
        }
        ++this.updateTicks;
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB box;
            List list;
            Entity entity;
            int j1;
            if (this.entityMainTrain == null) {
                AxisAlignedBB box2 = null;
                box2 = this.field_70121_D.func_72314_b(20.0, 20.0, 20.0);
                List lis = this.field_70170_p.func_72839_b((Entity)this, box2);
                if (lis != null && lis.size() > 0) {
                    for (j1 = 0; j1 < lis.size(); ++j1) {
                        entity = (Entity)lis.get(j1);
                        if (!(entity instanceof AbstractTrains) || ((AbstractTrains)entity).getID() != this.entityMainTrainID) continue;
                        this.entityMainTrain = (EntityRollingStock)entity;
                        this.entityMainTrain.bogieLoco[this.bogieIndex] = this;
                    }
                }
                if (this.entityMainTrain == null && this.updateTicks > 200) {
                    this.func_70106_y();
                }
            }
            if ((list = this.field_70170_p.func_72839_b((Entity)this, box = EntityBogie.getCollisionHandler() != null ? EntityBogie.getCollisionHandler().getMinecartCollisionBox((EntityMinecart)this) : this.field_70121_D.func_72314_b(0.2, 0.0, 0.2))) != null && !list.isEmpty()) {
                for (j1 = 0; j1 < list.size(); ++j1) {
                    entity = (Entity)list.get(j1);
                    if (entity == this.field_70153_n) continue;
                    this.func_70108_f(entity);
                }
            }
        }
    }

    public void updateDistance() {
        double d = this.entityMainTrain.field_70165_t - this.field_70165_t;
        double d1 = this.entityMainTrain.field_70161_v - this.field_70161_v;
        double d2 = MathHelper.func_76133_a((double)(d * d + d1 * d1));
        double vecX = this.entityMainTrain.field_70165_t - this.field_70165_t;
        double vecZ = this.entityMainTrain.field_70161_v - this.field_70161_v;
        double vecNorm = MathHelper.func_76133_a((double)(vecX * vecX + vecZ * vecZ));
        double unitX = vecX / vecNorm;
        double unitZ = vecZ / vecNorm;
        float optDist = (float)(-this.bogieShift);
        double stretch = d2 - (double)optDist;
        double div = this.spring();
        if (Math.sqrt(this.entityMainTrain.field_70159_w * this.entityMainTrain.field_70159_w + this.entityMainTrain.field_70179_y * this.entityMainTrain.field_70179_y) < 0.17) {
            div = 0.049;
        }
        double springX = div * stretch * vecX * -1.0;
        double springZ = div * stretch * vecZ * -1.0;
        springX = this.limitForce(springX);
        springZ = this.limitForce(springZ);
        this.field_70159_w -= springX;
        this.field_70179_y -= springZ;
        double speedVecX = this.entityMainTrain.field_70159_w - this.field_70159_w;
        double speedVecZ = this.entityMainTrain.field_70179_y - this.field_70179_y;
        double dot = speedVecX * unitX + speedVecZ * unitZ;
        double divider = this.damp();
        if (Math.sqrt(this.entityMainTrain.field_70159_w * this.entityMainTrain.field_70159_w + this.entityMainTrain.field_70179_y * this.entityMainTrain.field_70179_y) < 0.017) {
            divider = 0.2;
        }
        double dampX = divider * dot * unitX * -1.0;
        double dampZ = divider * dot * unitZ * -1.0;
        dampX = this.limitForce(dampX);
        dampZ = this.limitForce(dampZ);
        this.field_70159_w -= dampX;
        this.field_70179_y -= dampZ;
    }

    protected double spring() {
        return 0.2499999761581421;
    }

    protected double damp() {
        return 0.4f;
    }

    protected double limitForce(double force) {
        return Math.copySign(Math.abs(Math.min(Math.abs(force), 6.0)), force);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return this.field_70131_O / 2.0f;
    }

    public boolean func_130002_c(EntityPlayer entityplayer) {
        if (this.entityMainTrain != null) {
            this.entityMainTrain.func_130002_c(entityplayer);
        }
        return true;
    }

    public void setPosition(float px, float py, float pz) {
        this.field_70165_t = px;
        this.field_70163_u = py;
        this.field_70161_v = pz;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        this.entityMainTrainID = nbttagcompound.func_74762_e("trainID");
        this.bogieIndex = nbttagcompound.func_74762_e("bogieIndex");
        this.bogieShift = nbttagcompound.func_74769_h("bogieShift");
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("trainID", this.entityMainTrainID);
        nbttagcompound.func_74768_a("bogieIndex", this.bogieIndex);
        nbttagcompound.func_74780_a("bogieShift", this.bogieShift);
    }

    public int func_94087_l() {
        return -1;
    }

    @Override
    public String getDestination() {
        if (this.entityMainTrain != null) {
            return this.entityMainTrain.getDestination();
        }
        return null;
    }

    @Override
    public boolean setDestination(ItemStack ticket) {
        if (this.entityMainTrain != null) {
            return this.entityMainTrain.setDestination(ticket);
        }
        return false;
    }

    @Override
    public boolean doesCartMatchFilter(ItemStack stack, EntityMinecart cart) {
        return false;
    }

    public boolean shouldDoRailFunctions() {
        return false;
    }

    public double getSlopeAdjustment() {
        return 0.0;
    }

    public float getMaxCartSpeedOnRail() {
        return 1.8f;
    }

    protected void func_94091_a(int par1, int par2, int par3, double par4, double par6, int par8, int par9) {
        par4 = 1.8;
        super.func_94091_a(par1, par2, par3, par4, par6, par8, par9);
    }
}

