/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.api;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import src.train.common.api.Locomotive;
import src.train.common.entity.rollingStock.EntityLocoElectricHighSpeedZeroED;
import src.train.common.entity.rollingStock.EntityLocoElectricNewHighSpeed;
import src.train.common.entity.rollingStock.EntityLocoElectricTramNY;
import src.train.common.entity.rollingStock.EntityLocoElectricVL10;

public class SpeedHandler {
    public double handleSpeed(double railMaxSpeed, float maxSpeed, Entity entity) {
        if (railMaxSpeed >= 0.4 && railMaxSpeed <= 0.45 && entity instanceof Locomotive) {
            return this.convertSpeed(entity);
        }
        if (railMaxSpeed < 0.4 && entity instanceof Locomotive) {
            if (this.convertSpeed(entity) < railMaxSpeed) {
                return this.convertSpeed(entity);
            }
            return railMaxSpeed;
        }
        if (railMaxSpeed > 0.45 && entity instanceof Locomotive) {
            return this.convertSpeed(entity) + 0.2;
        }
        if (entity instanceof Locomotive) {
            return railMaxSpeed;
        }
        return 1.1;
    }

    private boolean isSpeedRail(Entity entity) {
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)entity.field_70163_u);
        int k = MathHelper.func_76128_c((double)entity.field_70161_v);
        return SpeedHandler.isSpeedRailAt(entity.field_70170_p, i, j, k);
    }

    public static boolean isSpeedRailAt(World world, int i, int j, int k) {
        int id = world.func_72798_a(i, j, k);
        Block block = Block.field_71973_m[id];
        if (block != null && block.getClass().getName() == "IRailSpeed") {
            return true;
        }
        TileEntity tile = world.func_72796_p(i, j, k);
        return tile != null && tile.getClass().getName() == "IRailSpeed";
    }

    private boolean canGoFaster(Entity entity) {
        return entity instanceof EntityLocoElectricNewHighSpeed || entity instanceof EntityLocoElectricHighSpeedZeroED || entity instanceof EntityLocoElectricTramNY || entity instanceof EntityLocoElectricVL10;
    }

    public double speedXFromPitch(EntityPlayer player, double var3) {
        return (double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI))) * var3 * (double)MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * var3;
    }

    public double speedZFromPitch(EntityPlayer player, double var3) {
        return (double)MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * var3 * (double)MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * var3;
    }

    private double convertSpeed(Entity entity) {
        double speed = ((Locomotive)entity).getCustomSpeed();
        speed /= 6.0;
        speed /= 10.0;
        if (entity instanceof Locomotive && speed > 0.695 && ((Locomotive)entity).isAttached) {
            double max = 0.695;
            return max;
        }
        return speed;
    }
}

