/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.tracks.ITrackEmitter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import src.train.common.blocks.tracks.TrackBaseTraincraft;
import src.train.common.library.TrackIDs;

public class BlockDetectorTrack
extends TrackBaseTraincraft
implements ITrackEmitter {
    private byte delay = 0;

    @Override
    public TrackIDs getTrackType() {
        return null;
    }

    @Override
    public void updateEntity() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        if (this.delay > 0) {
            this.delay = (byte)(this.delay - 1);
            if (this.delay == 0) {
                this.notifyNeighbors();
            }
        }
    }

    @Override
    public Icon getIcon() {
        if (this.delay > 0) {
            return this.getIcon(1);
        }
        return this.getIcon(0);
    }

    protected void notifyNeighbors() {
        int id = this.getWorld().func_72798_a(this.getX(), this.getY(), this.getZ());
        this.getWorld().func_72898_h(this.getX(), this.getY(), this.getZ(), id);
        this.getWorld().func_72898_h(this.getX(), this.getY() - 1, this.getZ(), id);
        this.markBlockNeedsUpdate();
    }

    protected void setTrackPowering() {
        boolean notify = this.delay == 0;
        this.delay = (byte)3;
        if (notify) {
            this.notifyNeighbors();
        }
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74774_a("delay", this.delay);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.delay = nbttagcompound.func_74771_c("delay");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.delay);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.delay = data.readByte();
        this.markBlockNeedsUpdate();
    }

    @Override
    public int getPowerOutput() {
        return this.delay > 0 ? 15 : 0;
    }
}

