/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.blocks.tracks;

import cpw.mods.fml.common.FMLCommonHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.api.tracks.ITrackPowered;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import src.train.common.api.ElectricTrain;
import src.train.common.api.EntityRollingStock;
import src.train.common.blocks.tracks.SpeedControllerSteel;
import src.train.common.blocks.tracks.TrackBaseTraincraft;
import src.train.common.library.TrackIDs;

public class BlockEnergyTrack
extends TrackBaseTraincraft
implements ITrackPowered {
    private byte delay = 0;
    public double energy = 0.0;
    public int maxEnergy = 1000;
    public int maxInput = 1000;
    public int output = 500;
    private int transmitDistance = 2;
    public boolean isProvider = false;
    public boolean addedToEnergyNet = false;
    private Block thisBlock;
    private int updateTicks = 0;
    protected boolean powered = false;

    public BlockEnergyTrack() {
        this.speedController = SpeedControllerSteel.getInstance();
    }

    @Override
    public TrackIDs getTrackType() {
        return TrackIDs.ENERGY_TRACK;
    }

    private Block getThisBlock() {
        if (this.thisBlock == null) {
            int id = this.getWorld().func_72798_a(this.getX(), this.getY(), this.getZ());
            this.thisBlock = Block.field_71973_m[id];
        }
        return this.thisBlock;
    }

    public boolean isSimulating() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    @Override
    public void updateEntity() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        ++this.updateTicks;
        if (this.isPowered() && this.updateTicks % 2 == 0 && this.getEnergy() < this.getMaxEnergy()) {
            this.energy += 1.0;
        }
        if (this.updateTicks % 50 == 0) {
            this.markBlockNeedsUpdate();
        }
    }

    @Override
    public Icon getIcon() {
        int meta = this.tileEntity.func_70322_n();
        if (meta >= 6) {
            if (this.energy > 0.0) {
                return this.getIcon(3);
            }
            return this.getIcon(2);
        }
        if (this.energy > 0.0) {
            return this.getIcon(1);
        }
        return this.getIcon(0);
    }

    @Override
    public boolean isFlexibleRail() {
        return true;
    }

    private void notifyNeighbors() {
        int id = this.getWorld().func_72798_a(this.getX(), this.getY(), this.getZ());
        this.getWorld().func_72898_h(this.getX(), this.getY(), this.getZ(), id);
        this.getWorld().func_72898_h(this.getX(), this.getY() - 1, this.getZ(), id);
        this.markBlockNeedsUpdate();
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        if (this.getWorld().field_72995_K) {
            return false;
        }
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() instanceof IToolCrowbar) {
            IToolCrowbar crowbar = (IToolCrowbar)current.func_77973_b();
            player.func_71035_c("stored: " + (int)this.energy + "/" + (int)this.getMaxEnergy() + " EU");
            this.markBlockNeedsUpdate();
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            this.sendUpdateToClient();
            return true;
        }
        return false;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        if (!(cart instanceof ElectricTrain)) {
            return;
        }
        if (this.energy > 0.0 && ((ElectricTrain)cart).fuelTrain < ((ElectricTrain)cart).maxEnergy) {
            double transfered = this.energy * 0.05;
            ((EntityRollingStock)cart).fuelTrain = (int)((double)((EntityRollingStock)cart).fuelTrain + transfered);
            this.energy -= transfered;
        }
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
        nbttagcompound.func_74757_a("powered", this.powered);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.energy = nbttagcompound.func_74769_h("energy");
        this.powered = nbttagcompound.func_74767_n("powered");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeDouble(this.energy);
        data.writeBoolean(this.powered);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.energy = data.readDouble();
        this.powered = data.readBoolean();
        this.markBlockNeedsUpdate();
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public int getPowerPropagation() {
        return this.transmitDistance;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getMaxEnergy() {
        return this.maxEnergy;
    }

    public void setEnergy(double joules) {
        this.energy = (int)Math.max(Math.min(joules, this.getMaxEnergy()), 0.0);
    }
}

