/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.core.handlers;

import java.io.File;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import src.train.common.Traincraft;
import src.train.common.library.BlockIDs;
import src.train.common.library.ItemIDs;

public class ConfigHandler {
    public static boolean ORE_GEN;
    public static boolean COPPER_ORE_GEN;
    public static boolean ENABLE_ZEPPELIN;
    public static boolean SOUNDS;
    public static boolean FLICKERING;
    public static boolean ENABLE_STEAM;
    public static boolean ENABLE_DIESEL;
    public static boolean ENABLE_ELECTRIC;
    public static boolean ENABLE_BUILDER;
    public static boolean ENABLE_TENDER;
    public static boolean CHUNK_LOADING;
    public static boolean SHOW_POSSIBLE_COLORS;
    public static boolean MYSQL_ENABLE;
    public static int TRAINCRAFT_VILLAGER_ID;
    public static int Key_Acc;
    public static int Key_Dec;
    public static int Key_Left;
    public static int Key_Right;
    public static int Key_Horn;
    public static int Key_Invent;
    public static int Key_Up;
    public static int Key_Down;
    public static int Key_Idle;
    public static int Key_Furn;
    public static String MYSQL_URL;
    public static String MYSQL_USER;
    public static String MYSQL_PASSWORD;
    private static final String CATEGORY_KEYS = "Keys";
    private static final String CATEGORY_MYSQL = "MYSQL";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File configFile) {
        Configuration cf = new Configuration(configFile);
        try {
            cf.load();
            SOUNDS = cf.get("general", "ENABLE_SOUNDS", true).getBoolean(true);
            FLICKERING = cf.get("general", "DISABLE_FLICKERING", true).getBoolean(true);
            ORE_GEN = cf.get("general", "ENABLE_FUEL_ORES_SPAWN", true).getBoolean(true);
            COPPER_ORE_GEN = cf.get("general", "ENABLE_COPPER_SPAWN", true).getBoolean(true);
            ENABLE_ZEPPELIN = cf.get("general", "ENABLE_ZEPPELIN", true).getBoolean(true);
            ENABLE_STEAM = cf.get("general", "ENABLE_STEAM_TRAINS", true).getBoolean(true);
            ENABLE_DIESEL = cf.get("general", "ENABLE_DIESEL_TRAINS", true).getBoolean(true);
            ENABLE_ELECTRIC = cf.get("general", "ENABLE_ELECTRIC_TRAINS", true).getBoolean(true);
            ENABLE_BUILDER = cf.get("general", "ENABLE_TRACKS_BUILDER", true).getBoolean(true);
            ENABLE_TENDER = cf.get("general", "ENABLE_TENDERS", true).getBoolean(true);
            CHUNK_LOADING = cf.get("general", "ENABLE_CHUNK_LOADING", true).getBoolean(true);
            TRAINCRAFT_VILLAGER_ID = cf.get("general", "TRAINCRAFT_VILLAGER_ID", 86).getInt();
            Property SHOW_POSSIBLE_COLORS_PROP = cf.get("general", "SHOW_POSSIBLE_TRAINS_COLORS_IN_CHAT", true);
            SHOW_POSSIBLE_COLORS_PROP.comment = "This will disable the chat messages telling you the possible colors when spawning new trains and when coloring them with dye";
            SHOW_POSSIBLE_COLORS = SHOW_POSSIBLE_COLORS_PROP.getBoolean(true);
            Property mysqlEnable = cf.get(CATEGORY_MYSQL, "MYSQL_ENABLE", false);
            mysqlEnable.comment = "MySQL logger is ment to log train place, destroy, color, create and explode events to your local MYSQL server. \nThis will NOT send any information elsewhere. \nLogged events can be used on webpage (if you know how to program in PhP or any other WEB scripting language) \nto track history of every train or just track, who has done something recently. \nThis ONLY works on dedicated servers, ONLY the OWNER of the SERVER must setup the url, the username and password for his mysql server where stats will be sent \nThat means this system DOESN'T have access to ANY of the CLIENT informations \nThe url will be handled like so in the code: String url ='jdbc:mysql://' +ConfigHandler.MYSQL_URL; \nIf you have questions about this code please contact \nSpitfire4466 and/or DragonBornSR (author of the mysql part and owner of thesociety.eu Traincraft server: http://forum.thesociety.eu)";
            MYSQL_ENABLE = mysqlEnable.getBoolean(false);
            MYSQL_URL = cf.get(CATEGORY_MYSQL, "MYSQL_URL", "some url").getString();
            MYSQL_USER = cf.get(CATEGORY_MYSQL, "MYSQL_USER", "your username").getString();
            MYSQL_PASSWORD = cf.get(CATEGORY_MYSQL, "MYSQL_PASSWORD", "your password").getString();
            Traincraft.proxy.setKeyBinding("Horn", cf.get(CATEGORY_KEYS, "KEY_HORN", Key_Horn).getInt());
            Traincraft.proxy.setKeyBinding("Invent", cf.get(CATEGORY_KEYS, "KEY_INVENT", Key_Invent).getInt());
            Traincraft.proxy.setKeyBinding("Up", cf.get(CATEGORY_KEYS, "KEY_UP", Key_Up).getInt());
            Traincraft.proxy.setKeyBinding("Down", cf.get(CATEGORY_KEYS, "KEY_DOWN", Key_Down).getInt());
            Traincraft.proxy.setKeyBinding("Idle", cf.get(CATEGORY_KEYS, "KEY_IDLE", Key_Idle).getInt());
            Traincraft.proxy.setKeyBinding("Furnace", cf.get(CATEGORY_KEYS, "KEY_FURN", Key_Furn).getInt());
            BlockIDs.assemblyTableI.blockID = cf.getBlock("block", "block_assemblytableI", 350).getInt(350);
            BlockIDs.assemblyTableII.blockID = cf.getBlock("block", "block_assemblytableII", 351).getInt(351);
            BlockIDs.assemblyTableIII.blockID = cf.getBlock("block", "block_assemblytableIII", 352).getInt(352);
            BlockIDs.distilIdle.blockID = cf.getBlock("block", "block_distil", 353).getInt(353);
            BlockIDs.distilActive.blockID = cf.getBlock("block", "block_distil_active", 354).getInt(354);
            BlockIDs.trainWorkbench.blockID = cf.getBlock("block", "block_train_workbench", 361).getInt(361);
            BlockIDs.stopper.blockID = cf.getBlock("block", "block_train_buffer", 362).getInt(362);
            BlockIDs.oreTC.blockID = cf.getTerrainBlock("block", "block_traincraft_ores", 365, "TC Ores generation (Copper)").getInt(365);
            BlockIDs.openFurnaceIdle.blockID = cf.getBlock("block", "block_open_furnace", 363).getInt(363);
            BlockIDs.openFurnaceActive.blockID = cf.getBlock("block", "block_open_furnace_active", 364).getInt(364);
            BlockIDs.lantern.blockID = cf.getBlock("block", "block_lantern", 365).getInt(365);
            BlockIDs.waterWheel.blockID = cf.getBlock("block", "block_water_wheel", 366).getInt(366);
            BlockIDs.windMill.blockID = cf.getBlock("block", "block_wind_mill", 367).getInt(367);
            BlockIDs.generatorDiesel.blockID = cf.getBlock("block", "block_diesel_generator", 368).getInt(368);
            BlockIDs.diesel.blockID = cf.getBlock("block", "block_diesel", 369).getInt(369);
            BlockIDs.refinedFuel.blockID = cf.getBlock("block", "block_refinedFuel", 370).getInt(370);
            int id = 29000;
            for (ItemIDs items : ItemIDs.values()) {
                items.itemID = cf.getItem("item", "item_" + items.name(), id).getInt(id);
                ++id;
            }
        }
        catch (Exception e) {
            Traincraft.tcLog.severe("Traincraft had a problem loading its configuration\n" + e);
        }
        finally {
            if (cf.hasChanged()) {
                cf.save();
            }
        }
    }

    static {
        Key_Acc = 17;
        Key_Dec = 31;
        Key_Left = 30;
        Key_Right = 32;
        Key_Horn = 35;
        Key_Invent = 19;
        Key_Up = 44;
        Key_Down = 45;
        Key_Idle = 46;
        Key_Furn = 33;
    }
}

