/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.core.plugins;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.oredict.OreDictionary;
import src.train.client.gui.GuiTrainCraftingBlock;
import src.train.common.inventory.TrainCraftingManager;
import src.train.common.recipes.ShapedTrainRecipes;
import src.train.common.recipes.ShapelessTrainRecipe;

public class NEITraincraftWorkbenchRecipePlugin
extends ShapedRecipeHandler {
    private List<ShapedTrainRecipes> recipeListWB = NEITraincraftWorkbenchRecipePlugin.workbenchListCleaner(TrainCraftingManager.getInstance().getShapedRecipes());

    private CachedShapedRecipe getShape(ShapedTrainRecipes recipe) {
        CachedShapedRecipe shape = new CachedShapedRecipe(0, 0, null, recipe.getRecipeOutput());
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                if (recipe.recipeItems[y * 3 + x] == null) continue;
                PositionedStack stack = new PositionedStack((Object)recipe.recipeItems[y * 3 + x], 25 + x * 18, 6 + y * 18);
                stack.setMaxSize(1);
                shape.ingredients.add(stack);
            }
        }
        shape.result.relx = 119;
        shape.result.rely = 25;
        return shape;
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (ShapedTrainRecipes recipe : this.recipeListWB) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)recipe.getRecipeOutput(), (ItemStack)result)) continue;
            this.arecipes.add(this.getShape(recipe));
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiTrainCraftingBlock.class;
    }

    public String getRecipeName() {
        return "Train Workbench";
    }

    public String getGuiTexture() {
        return "tc:textures/gui/crafting_table.png";
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return false;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), "train workbench", new Object[0]));
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        block0: for (ShapedTrainRecipes recipe : this.recipeListWB) {
            for (ItemStack source : recipe.recipeItems) {
                if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)source, (ItemStack)ingredient)) continue;
                this.arecipes.add(this.getShape(recipe));
                continue block0;
            }
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("train workbench") && ((Object)((Object)this)).getClass() == NEITraincraftWorkbenchRecipePlugin.class) {
            for (ShapedTrainRecipes recipe : this.recipeListWB) {
                this.arecipes.add(this.getShape(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public static List workbenchListCleaner(List recipeList) {
        ArrayList<Integer> outputList = new ArrayList<Integer>();
        ArrayList cleanedList = new ArrayList();
        for (int i = 0; i < recipeList.size(); ++i) {
            if (recipeList.get(i) instanceof ShapedTrainRecipes) {
                if (outputList != null) {
                    if (!outputList.contains(((ShapedTrainRecipes)recipeList.get((int)i)).getRecipeOutput().func_77973_b().field_77779_bT)) {
                        cleanedList.add(recipeList.get(i));
                    }
                } else {
                    cleanedList.add(recipeList.get(i));
                }
                outputList.add(((ShapedTrainRecipes)recipeList.get((int)i)).getRecipeOutput().func_77973_b().field_77779_bT);
            }
            if (!(recipeList.get(i) instanceof ShapelessTrainRecipe)) continue;
            if (outputList != null) {
                if (!outputList.contains(((ShapelessTrainRecipe)recipeList.get((int)i)).getRecipeOutput().func_77973_b().field_77779_bT)) {
                    cleanedList.add(recipeList.get(i));
                }
            } else {
                cleanedList.add(recipeList.get(i));
            }
            outputList.add(((ShapelessTrainRecipe)recipeList.get((int)i)).getRecipeOutput().func_77973_b().field_77779_bT);
        }
        return cleanedList;
    }

    public class CachedShapedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;
        private int cycleTicks;

        public CachedShapedRecipe(int width, int height, Object[] items, ItemStack out) {
            super((TemplateRecipeHandler)NEITraincraftWorkbenchRecipePlugin.this);
            this.cycleTicks = 0;
            this.result = new PositionedStack((Object)out, 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(width, height, items);
        }

        public CachedShapedRecipe(ShapedRecipes recipe) {
            this(recipe.field_77576_b, recipe.field_77577_c, recipe.field_77574_d, recipe.func_77571_b());
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items[y * width + x] == null) continue;
                    PositionedStack stack = new PositionedStack(items[y * width + x], 25 + x * 18, 6 + y * 18, false);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEITraincraftWorkbenchRecipePlugin.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
            this.result.generatePermutations();
        }

        public List<PositionedStack> getCycledIngredients(int cycle, List<PositionedStack> ingredients) {
            ++this.cycleTicks;
            for (int itemIndex = 0; itemIndex < ingredients.size(); ++itemIndex) {
                String oreName = OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)ingredients.get((int)itemIndex).item));
                if (oreName.equals("ingotSteel") || oreName.equals("ingotIron") || oreName.equals("ingotCopper") || oreName.equals("dustPlastic") || oreName.equals("dustCoal")) {
                    ArrayList list = OreDictionary.getOres((String)OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)ingredients.get((int)itemIndex).item)));
                    Random rand = new Random((long)cycle + System.currentTimeMillis());
                    if (this.cycleTicks % 15 != 0) continue;
                    int stackSize = ingredients.get((int)itemIndex).item.field_77994_a;
                    ingredients.get((int)itemIndex).item = (ItemStack)list.get(Math.abs(rand.nextInt()) % list.size());
                    ingredients.get((int)itemIndex).item.field_77994_a = stackSize;
                    continue;
                }
                this.randomRenderPermutation(ingredients.get(itemIndex), cycle + itemIndex);
            }
            return ingredients;
        }
    }
}

