/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.core.plugins;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import src.train.common.Traincraft;
import src.train.common.core.TrainModCore;
import src.train.common.core.interfaces.IPlugin;
import src.train.common.items.ItemTrain;
import src.train.common.library.ItemIDs;
import src.train.common.library.TrackIDs;

public class PluginRailcraft
implements IPlugin {
    public static PluginRailcraft instance = new PluginRailcraft();
    private static HashMap<String, ItemStack> items = new HashMap();
    private static String[] names = new String[]{"fuel.coke", "part.ingot.steel", "part.rail.advanced", "part.rail.reinforced", "part.rail.speed", "part.rail.standard", "part.rail.wood", "part.railbed.stone", "part.railbed.wood"};

    @Override
    public boolean isAvailable() {
        return TrainModCore.isPresent("Railcraft");
    }

    @Override
    public void initialize() {
        this.initItems();
        this.checkItems();
        this.addTrackNames();
        this.addTrackRecipes();
    }

    public void registerTracks() {
        PluginRailcraft.registerTrack(TrackIDs.COUPLER_TRACK);
        PluginRailcraft.registerTrack(TrackIDs.DETECTOR_ALL_LOCOMOTIVES);
        PluginRailcraft.registerTrack(TrackIDs.DETECTOR_DIESEL_LOCOMOTIVES);
        PluginRailcraft.registerTrack(TrackIDs.DETECTOR_FREIGHT);
        PluginRailcraft.registerTrack(TrackIDs.DETECTOR_PASSENGER);
        PluginRailcraft.registerTrack(TrackIDs.DETECTOR_STEAM_LOCOMOTIVES);
        PluginRailcraft.registerTrack(TrackIDs.ENERGY_TRACK);
        PluginRailcraft.registerTrack(TrackIDs.DETECTOR_TANK_CARTS);
        PluginRailcraft.registerTrack(TrackIDs.COPPER_TRACK);
        PluginRailcraft.registerTrack(TrackIDs.STEEL_TRACK);
        PluginRailcraft.registerTrack(TrackIDs.ANIMAL_BOARDING_TRACK);
        PluginRailcraft.registerTrack(TrackIDs.DISEMBARK_TRACK);
        PluginRailcraft.registerTrack(TrackIDs.MOB_BOARDING_TRACK);
        PluginRailcraft.registerTrack(TrackIDs.LOCO_SPEED_CONTROLLER);
        PluginRailcraft.registerTrack(TrackIDs.LOCO_HOLDING_TRACK);
        PluginRailcraft.registerTrack(TrackIDs.STATION_TRACK);
        PluginRailcraft.registerTrack(TrackIDs.HORN_ALL_LOCOMOTIVES);
        PluginRailcraft.registerTrack(TrackIDs.VANILLA_SNOWY_TRACK);
        PluginRailcraft.registerTrack(TrackIDs.SNOWY_STEEL_TRACK);
        PluginRailcraft.registerTrack(TrackIDs.SNOWY_COPPER_TRACK);
    }

    private static void registerTrack(TrackIDs rail) {
    }

    private void initItems() {
        ItemIDs.steelRail.item = new ItemTrain(ItemIDs.steelRail.itemID);
        ItemIDs.copperRail.item = new ItemTrain(ItemIDs.copperRail.itemID);
        ItemIDs.steelRail.item.func_77655_b(ItemIDs.steelRail.name());
        ItemIDs.copperRail.item.func_77655_b(ItemIDs.copperRail.name());
        for (int i = 0; i < names.length; ++i) {
            if (GameRegistry.findItemStack((String)"Railcraft", (String)names[i], (int)1) == null) continue;
            items.put(names[i], GameRegistry.findItemStack((String)"Railcraft", (String)names[i], (int)1));
        }
    }

    private void addTrackNames() {
        if (TrackIDs.COUPLER_TRACK.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.COUPLER_TRACK.getTrackSpec().getItem(), (String)"[TC] Coupler Track");
        }
        if (TrackIDs.ANIMAL_BOARDING_TRACK.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.ANIMAL_BOARDING_TRACK.getTrackSpec().getItem(), (String)"[TC] Animal Boarding Track (Stock Car only)");
        }
        if (TrackIDs.COPPER_TRACK.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.COPPER_TRACK.getTrackSpec().getItem(), (String)"[TC] Copper Track");
        }
        if (TrackIDs.DETECTOR_ALL_LOCOMOTIVES.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.DETECTOR_ALL_LOCOMOTIVES.getTrackSpec().getItem(), (String)"[TC] Locomotive Detector Track");
        }
        if (TrackIDs.DETECTOR_DIESEL_LOCOMOTIVES.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.DETECTOR_DIESEL_LOCOMOTIVES.getTrackSpec().getItem(), (String)"[TC] Diesel Lcomotive Detector Track");
        }
        if (TrackIDs.DETECTOR_FREIGHT.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.DETECTOR_FREIGHT.getTrackSpec().getItem(), (String)"[TC] Freight Cart Detector Track");
        }
        if (TrackIDs.DETECTOR_PASSENGER.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.DETECTOR_PASSENGER.getTrackSpec().getItem(), (String)"[TC] Passenger Cart Detector Track");
        }
        if (TrackIDs.DETECTOR_STEAM_LOCOMOTIVES.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.DETECTOR_STEAM_LOCOMOTIVES.getTrackSpec().getItem(), (String)"[TC] Steam Locomotive Detector Track");
        }
        if (TrackIDs.DETECTOR_TANK_CARTS.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.DETECTOR_TANK_CARTS.getTrackSpec().getItem(), (String)"[TC] Tank Cart Detector Track");
        }
        if (TrackIDs.DISEMBARK_TRACK.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.DISEMBARK_TRACK.getTrackSpec().getItem(), (String)"[TC] Disembarking Track (Stock Car only)");
        }
        if (TrackIDs.ENERGY_TRACK.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.ENERGY_TRACK.getTrackSpec().getItem(), (String)"[TC] Electric Track");
        }
        if (TrackIDs.MOB_BOARDING_TRACK.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.MOB_BOARDING_TRACK.getTrackSpec().getItem(), (String)"[TC] Mob Boarding Track (Stock Car only)");
        }
        if (TrackIDs.STEEL_TRACK.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.STEEL_TRACK.getTrackSpec().getItem(), (String)"[TC] Steel Track");
        }
        if (TrackIDs.LOCO_SPEED_CONTROLLER.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.LOCO_SPEED_CONTROLLER.getTrackSpec().getItem(), (String)"[TC] Locomotive Speed Controller Track");
        }
        if (TrackIDs.LOCO_HOLDING_TRACK.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.LOCO_HOLDING_TRACK.getTrackSpec().getItem(), (String)"[TC] Locomotive Holding Track");
        }
        if (TrackIDs.STATION_TRACK.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.STATION_TRACK.getTrackSpec().getItem(), (String)"[TC] Station Track");
        }
        if (TrackIDs.HORN_ALL_LOCOMOTIVES.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.HORN_ALL_LOCOMOTIVES.getTrackSpec().getItem(), (String)"[TC] Whistle Track");
        }
        if (TrackIDs.VANILLA_SNOWY_TRACK.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.VANILLA_SNOWY_TRACK.getTrackSpec().getItem(), (String)"[TC] Snowy track");
        }
        if (TrackIDs.SNOWY_STEEL_TRACK.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.SNOWY_STEEL_TRACK.getTrackSpec().getItem(), (String)"[TC] Snowy steel track");
        }
        if (TrackIDs.SNOWY_COPPER_TRACK.getTrackSpec() != null) {
            LanguageRegistry.addName((Object)TrackIDs.SNOWY_COPPER_TRACK.getTrackSpec().getItem(), (String)"[TC] Snowy copper track");
        }
    }

    private void addTrackRecipes() {
        ArrayList steel;
        ArrayList copper;
        if (items.containsKey(names[2]) && items.containsKey(names[3]) && items.containsKey(names[4]) && items.containsKey(names[5]) && items.containsKey(names[6]) && items.containsKey(names[7]) && items.containsKey(names[8])) {
            if (TrackIDs.COUPLER_TRACK.getTrackSpec() != null) {
                GameRegistry.addRecipe((ItemStack)TrackIDs.COUPLER_TRACK.getTrackSpec().getItem(TrackIDs.COUPLER_TRACK.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "# #", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), ItemIDs.stake.item});
            }
            if (TrackIDs.ANIMAL_BOARDING_TRACK.getTrackSpec() != null) {
                GameRegistry.addRecipe((ItemStack)TrackIDs.ANIMAL_BOARDING_TRACK.getTrackSpec().getItem(TrackIDs.ANIMAL_BOARDING_TRACK.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "#P#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), Item.field_82798_bP, Character.valueOf('P'), Item.field_77730_bn});
            }
            if (TrackIDs.DISEMBARK_TRACK.getTrackSpec() != null) {
                GameRegistry.addRecipe((ItemStack)TrackIDs.DISEMBARK_TRACK.getTrackSpec().getItem(TrackIDs.DISEMBARK_TRACK.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "# #", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), Item.field_77745_be});
            }
            if (TrackIDs.MOB_BOARDING_TRACK.getTrackSpec() != null) {
                GameRegistry.addRecipe((ItemStack)TrackIDs.MOB_BOARDING_TRACK.getTrackSpec().getItem(TrackIDs.MOB_BOARDING_TRACK.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "#P#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), Item.field_77755_aX, Character.valueOf('P'), Item.field_77730_bn});
            }
            if (TrackIDs.DETECTOR_ALL_LOCOMOTIVES.getTrackSpec() != null) {
                GameRegistry.addRecipe((ItemStack)TrackIDs.DETECTOR_ALL_LOCOMOTIVES.getTrackSpec().getItem(TrackIDs.DETECTOR_ALL_LOCOMOTIVES.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "#E#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), ItemIDs.controls.item, Character.valueOf('E'), ItemIDs.electronicCircuit.item});
            }
            if (TrackIDs.DETECTOR_DIESEL_LOCOMOTIVES.getTrackSpec() != null) {
                GameRegistry.addRecipe((ItemStack)TrackIDs.DETECTOR_DIESEL_LOCOMOTIVES.getTrackSpec().getItem(TrackIDs.DETECTOR_DIESEL_LOCOMOTIVES.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "#E#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), ItemIDs.diesel.item, Character.valueOf('E'), ItemIDs.electronicCircuit.item});
            }
            if (TrackIDs.DETECTOR_FREIGHT.getTrackSpec() != null) {
                GameRegistry.addRecipe((ItemStack)TrackIDs.DETECTOR_FREIGHT.getTrackSpec().getItem(TrackIDs.DETECTOR_FREIGHT.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "#E#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), Block.field_72077_au, Character.valueOf('E'), ItemIDs.electronicCircuit.item});
            }
            if (TrackIDs.DETECTOR_PASSENGER.getTrackSpec() != null) {
                GameRegistry.addRecipe((ItemStack)TrackIDs.DETECTOR_PASSENGER.getTrackSpec().getItem(TrackIDs.DETECTOR_PASSENGER.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "#E#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), ItemIDs.seats.item, Character.valueOf('E'), ItemIDs.electronicCircuit.item});
            }
            if (TrackIDs.DETECTOR_STEAM_LOCOMOTIVES.getTrackSpec() != null) {
                GameRegistry.addRecipe((ItemStack)TrackIDs.DETECTOR_STEAM_LOCOMOTIVES.getTrackSpec().getItem(TrackIDs.DETECTOR_STEAM_LOCOMOTIVES.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "#E#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), ItemIDs.ironFirebox.item, Character.valueOf('E'), ItemIDs.electronicCircuit.item});
            }
            if (TrackIDs.DETECTOR_TANK_CARTS.getTrackSpec() != null) {
                GameRegistry.addRecipe((ItemStack)TrackIDs.DETECTOR_TANK_CARTS.getTrackSpec().getItem(TrackIDs.DETECTOR_TANK_CARTS.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "#E#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), Item.field_77786_ax, Character.valueOf('E'), ItemIDs.electronicCircuit.item});
            }
            if (TrackIDs.ENERGY_TRACK.getTrackSpec() != null) {
                GameRegistry.addRecipe((ItemStack)TrackIDs.ENERGY_TRACK.getTrackSpec().getItem(TrackIDs.ENERGY_TRACK.getRecipeOutput()), (Object[])new Object[]{"#X#", "#R#", "#P#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[7]), Character.valueOf('X'), ItemIDs.copperWireFine.item, Character.valueOf('P'), Item.field_77730_bn});
            }
            if (TrackIDs.STEEL_TRACK.getTrackSpec() != null) {
                GameRegistry.addRecipe((ItemStack)TrackIDs.STEEL_TRACK.getTrackSpec().getItem(TrackIDs.STEEL_TRACK.getRecipeOutput()), (Object[])new Object[]{"# #", "#R#", "# #", Character.valueOf('#'), ItemIDs.steelRail.item, Character.valueOf('R'), items.get(names[7])});
            }
            if (TrackIDs.COPPER_TRACK.getTrackSpec() != null) {
                GameRegistry.addRecipe((ItemStack)TrackIDs.COPPER_TRACK.getTrackSpec().getItem(TrackIDs.COPPER_TRACK.getRecipeOutput()), (Object[])new Object[]{"# #", "#R#", "# #", Character.valueOf('#'), ItemIDs.copperRail.item, Character.valueOf('R'), items.get(names[7])});
            }
            if (TrackIDs.LOCO_SPEED_CONTROLLER.getTrackSpec() != null) {
                GameRegistry.addRecipe((ItemStack)TrackIDs.LOCO_SPEED_CONTROLLER.getTrackSpec().getItem(TrackIDs.LOCO_SPEED_CONTROLLER.getRecipeOutput()), (Object[])new Object[]{"#R#", "#X#", "#X#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), ItemIDs.controls.item});
            }
            if (TrackIDs.LOCO_HOLDING_TRACK.getTrackSpec() != null) {
                GameRegistry.addRecipe((ItemStack)TrackIDs.LOCO_HOLDING_TRACK.getTrackSpec().getItem(TrackIDs.LOCO_HOLDING_TRACK.getRecipeOutput()), (Object[])new Object[]{"#R#", "#P#", "#X#", Character.valueOf('#'), ItemIDs.steelRail.item, Character.valueOf('R'), items.get(names[8]), Character.valueOf('X'), ItemIDs.controls.item, Character.valueOf('P'), Block.field_72044_aK});
            }
            if (TrackIDs.STATION_TRACK.getTrackSpec() != null) {
                GameRegistry.addRecipe((ItemStack)TrackIDs.STATION_TRACK.getTrackSpec().getItem(TrackIDs.STATION_TRACK.getRecipeOutput()), (Object[])new Object[]{"#R#", "#C#", "#R#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('C'), Item.field_77752_aS});
            }
            if (TrackIDs.HORN_ALL_LOCOMOTIVES.getTrackSpec() != null) {
                GameRegistry.addRecipe((ItemStack)TrackIDs.HORN_ALL_LOCOMOTIVES.getTrackSpec().getItem(TrackIDs.HORN_ALL_LOCOMOTIVES.getRecipeOutput()), (Object[])new Object[]{"#R#", "#S#", "#E#", Character.valueOf('#'), items.get(names[2]), Character.valueOf('R'), items.get(names[8]), Character.valueOf('S'), Item.field_77792_au, Character.valueOf('E'), ItemIDs.electronicCircuit.item});
            }
            if (TrackIDs.SNOWY_STEEL_TRACK.getTrackSpec() != null && TrackIDs.STEEL_TRACK.getTrackSpec() != null) {
                GameRegistry.addShapelessRecipe((ItemStack)TrackIDs.SNOWY_STEEL_TRACK.getTrackSpec().getItem(TrackIDs.SNOWY_STEEL_TRACK.getRecipeOutput()), (Object[])new Object[]{TrackIDs.STEEL_TRACK.getTrackSpec().getItem(1), Item.field_77768_aD});
            }
            if (TrackIDs.SNOWY_COPPER_TRACK.getTrackSpec() != null && TrackIDs.COPPER_TRACK.getTrackSpec() != null) {
                GameRegistry.addShapelessRecipe((ItemStack)TrackIDs.SNOWY_COPPER_TRACK.getTrackSpec().getItem(TrackIDs.SNOWY_COPPER_TRACK.getRecipeOutput()), (Object[])new Object[]{TrackIDs.COPPER_TRACK.getTrackSpec().getItem(1), Item.field_77768_aD});
            }
            if (TrackIDs.VANILLA_SNOWY_TRACK.getTrackSpec() != null) {
                GameRegistry.addShapelessRecipe((ItemStack)TrackIDs.VANILLA_SNOWY_TRACK.getTrackSpec().getItem(TrackIDs.VANILLA_SNOWY_TRACK.getRecipeOutput()), (Object[])new Object[]{Block.field_72056_aG, Item.field_77768_aD});
            }
        }
        if ((copper = OreDictionary.getOres((String)"ingotCopper")) != null && copper.size() >= 0) {
            for (int i = 0; i < copper.size(); ++i) {
                RailcraftCraftingManager.rollingMachine.addRecipe(new ItemStack(ItemIDs.copperRail.item, 8), "X X", "X X", "X X", Character.valueOf('X'), copper.get(i));
            }
        }
        if ((steel = OreDictionary.getOres((String)"ingotSteel")) != null && steel.size() >= 0) {
            for (int t = 0; t < steel.size(); ++t) {
                RailcraftCraftingManager.rollingMachine.addRecipe(new ItemStack(ItemIDs.steelRail.item, 16), "X X", "I I", "X X", Character.valueOf('X'), steel.get(t), Character.valueOf('I'), Item.field_77703_o);
            }
        }
    }

    private void checkItems() {
        String missing = "";
        for (int i = 0; i < names.length; ++i) {
            if (items.containsKey(names[i])) continue;
            missing = missing + " " + names[i];
        }
        if (missing.equals("")) {
            Traincraft.tcLog.fine("Railcraft items loaded");
        } else {
            Traincraft.tcLog.log(Level.WARNING, "Railcraft items not loaded: " + missing);
        }
    }

    private void initRecipes() {
    }

    public static HashMap<String, ItemStack> getItems() {
        return items;
    }

    public static String[] getNames() {
        return names;
    }
}

