/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.entity.rollingStock;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import src.train.common.Traincraft;
import src.train.common.api.EntityRollingStock;
import src.train.common.core.CommonProxy;
import src.train.common.core.util.MP3Player;
import src.train.common.library.ItemIDs;

public class EntityJukeBoxCart
extends EntityRollingStock {
    public MP3Player player = null;
    public boolean isPlaying = false;
    public boolean isInvalid = false;
    public String streamURL = "";
    private boolean streamWasStopped = false;
    Side side;
    public float volume = 1.0f;

    public EntityJukeBoxCart(World world) {
        super(world);
        this.field_70180_af.func_75682_a(22, (Object)new String(this.streamURL));
        this.field_70180_af.func_75682_a(23, (Object)new Integer(0));
        this.side = FMLCommonHandler.instance().getEffectiveSide();
    }

    public EntityJukeBoxCart(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.0 - (double)0.3f;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        if (this.canBeDestroyedByPlayer(damagesource)) {
            return true;
        }
        super.func_70097_a(damagesource, i);
        this.func_70494_i(-this.func_70493_k());
        this.func_70497_h(10);
        this.func_70018_K();
        this.func_70492_c(this.func_70491_i() + i * 10.0f);
        if (this.func_70491_i() > 40.0f) {
            boolean flag;
            if (this.field_70153_n != null) {
                this.field_70153_n.func_70078_a((Entity)this);
            }
            this.func_70106_y();
            boolean bl = flag = damagesource.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)damagesource.func_76346_g()).field_71075_bZ.field_75098_d;
            if (!flag) {
                this.dropCartAsItem();
            }
        }
        return true;
    }

    @Override
    public void func_70106_y() {
        this.stopStream();
        super.func_70106_y();
        this.field_70128_L = true;
        if (this.side == Side.CLIENT) {
            String string = "entity_" + this.field_70157_k;
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.updateTicks;
        if (!this.field_70170_p.field_72995_K && this.updateTicks % 10 == 0) {
            this.field_70180_af.func_75692_b(22, (Object)this.streamURL);
            if (this.isPlaying) {
                this.field_70180_af.func_75692_b(23, (Object)1);
            } else {
                this.field_70180_af.func_75692_b(23, (Object)0);
            }
        }
        if (this.side == Side.CLIENT) {
            if (this.updateTicks % 10 == 0 && !this.isPlaying() && this.field_70180_af.func_75679_c(23) != 0) {
                this.streamURL = this.field_70180_af.func_75681_e(22);
                this.startStream();
            }
            if (Minecraft.func_71410_x().field_71439_g != null && this.player != null && !this.isInvalid) {
                float vol = (float)this.func_70092_e(Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v);
                if (vol > 1000.0f) {
                    this.player.setVolume(0.0f);
                } else {
                    float v2 = 10000.0f / vol / 100.0f;
                    if (v2 > 1.0f) {
                        this.player.setVolume(this.volume);
                    } else {
                        float v1 = 1.0f - this.volume;
                        v2 = v2 - v1 > 0.0f ? (v2 -= v1) : 0.0f;
                        this.player.setVolume(v2);
                    }
                }
                if (vol == 0.0f) {
                    this.invalidate();
                }
                if (this.isPlaying && this.field_70146_Z.nextInt(5) == 0 && this.player != null && this.player.isPlaying()) {
                    int random2 = this.field_70146_Z.nextInt(24) + 1;
                    this.field_70170_p.func_72869_a("note", this.field_70165_t, this.field_70163_u + 1.2, this.field_70161_v, (double)random2 / 24.0, 0.0, 0.0);
                }
            }
        }
    }

    public void recievePacket(String url, boolean playing) {
        this.streamURL = url;
        this.isPlaying = playing;
    }

    @SideOnly(value=Side.CLIENT)
    public void invalidate() {
        this.isInvalid = true;
        this.stopStream();
    }

    public void startStream() {
        if (!this.isPlaying) {
            this.isPlaying = true;
            if (this.side == Side.CLIENT) {
                this.player = new MP3Player(this.streamURL, this.field_70170_p, this.field_70157_k);
                CommonProxy.playerList.add(this.player);
            }
        }
    }

    public void stopStream() {
        if (this.isPlaying) {
            if (this.side == Side.CLIENT && this.player != null) {
                this.player.stop();
                CommonProxy.playerList.remove(this.player);
            }
            this.isPlaying = false;
        }
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    @Override
    public boolean func_130002_c(EntityPlayer entityplayer) {
        ItemStack var2 = entityplayer.field_71071_by.func_70448_g();
        this.playerEntity = entityplayer;
        if (super.func_130002_c(entityplayer)) {
            return false;
        }
        if (this.locked && !entityplayer.field_71092_bJ.toLowerCase().equals(this.trainOwner.toLowerCase())) {
            if (!this.field_70170_p.field_72995_K) {
                entityplayer.func_71035_c("this train is locked");
            }
            return true;
        }
        entityplayer.openGui((Object)Traincraft.instance, 102, this.field_70170_p, this.field_70157_k, -1, (int)this.field_70161_v);
        return true;
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(new ItemStack(ItemIDs.minecartJukeBoxCart.item));
        return items;
    }

    @Override
    public boolean isStorageCart() {
        return false;
    }

    @Override
    public boolean isPoweredCart() {
        return false;
    }

    @Override
    public float getOptimalDistance(EntityMinecart cart) {
        float dist = 1.85f;
        return dist;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74768_a("numberOfTrains", numberOfTrains);
        nbttagcompound.func_74768_a("ID", this.ID);
        nbttagcompound.func_74757_a("isAttached", this.isAttached);
        nbttagcompound.func_74757_a("linked", this.linked);
        nbttagcompound.func_74780_a("motionX", this.field_70159_w);
        nbttagcompound.func_74780_a("motionZ", this.field_70179_y);
        nbttagcompound.func_74780_a("Link1", this.Link1);
        nbttagcompound.func_74780_a("Link2", this.Link2);
        nbttagcompound.func_74778_a("StreamUrl", this.streamURL);
        nbttagcompound.func_74757_a("isPlaying", this.isPlaying());
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.ID = nbttagcompound.func_74762_e("ID");
        numberOfTrains = nbttagcompound.func_74762_e("numberOfTrains");
        this.isAttached = nbttagcompound.func_74767_n("isAttached");
        this.linked = nbttagcompound.func_74767_n("linked");
        this.field_70159_w = nbttagcompound.func_74769_h("motionX");
        this.field_70179_y = nbttagcompound.func_74769_h("motionZ");
        this.Link1 = nbttagcompound.func_74769_h("Link1");
        this.Link2 = nbttagcompound.func_74769_h("Link2");
        this.streamURL = nbttagcompound.func_74779_i("StreamUrl");
        this.isPlaying = nbttagcompound.func_74767_n("isPlaying");
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(22, (Object)this.streamURL);
            if (this.isPlaying) {
                this.field_70180_af.func_75692_b(23, (Object)1);
            } else {
                this.field_70180_af.func_75692_b(23, (Object)0);
            }
        }
    }
}

