/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.tile;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import src.train.common.core.handlers.PacketHandler;
import src.train.common.core.interfaces.ITier;
import src.train.common.core.managers.TierRecipe;
import src.train.common.core.managers.TierRecipeManager;

public class TileCrafterTierIII
extends TileEntity
implements IInventory,
ITier {
    private Random rand;
    private ItemStack[] crafterInventory = new ItemStack[26];
    private ForgeDirection facing;
    private final int Tier = 3;
    private static List<ItemStack> resultList;
    private static List<ItemStack> knownRecipes;
    private static int[] slotSelected;

    public TileCrafterTierIII() {
        this.rand = new Random();
        resultList = new ArrayList<ItemStack>();
        slotSelected = new int[8];
    }

    public int func_70302_i_() {
        return this.crafterInventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.crafterInventory[i];
    }

    @Override
    public List<ItemStack> getResultList() {
        return resultList;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.crafterInventory[i] != null) {
            if (this.crafterInventory[i].field_77994_a <= j) {
                ItemStack itemstack = this.crafterInventory[i];
                this.crafterInventory[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.crafterInventory[i].func_77979_a(j);
            if (this.crafterInventory[i].field_77994_a == 0) {
                this.crafterInventory[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.crafterInventory[par1] != null) {
            ItemStack var2 = this.crafterInventory[par1];
            this.crafterInventory[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.crafterInventory[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return "TierIII";
    }

    public void func_70307_a(NBTTagCompound nbtTag) {
        super.func_70307_a(nbtTag);
        this.facing = ForgeDirection.getOrientation((int)nbtTag.func_74771_c("Orientation"));
        slotSelected = nbtTag.func_74759_k("Selected");
        NBTTagList nbttaglist = nbtTag.func_74761_m("Items");
        this.crafterInventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
            byte byte0 = nbttagcompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.crafterInventory.length) continue;
            this.crafterInventory[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        NBTTagList nbttaglist2 = nbtTag.func_74761_m("Known");
        for (int i = 0; i < nbttaglist2.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbttaglist2.func_74743_b(i);
            byte byte1 = nbttagcompound2.func_74771_c("Recipe");
            if (byte1 < 0 || this.listContains(knownRecipes, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound2))) continue;
            knownRecipes.add(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound2));
        }
    }

    public void func_70310_b(NBTTagCompound nbtTag) {
        super.func_70310_b(nbtTag);
        if (this.facing != null) {
            nbtTag.func_74774_a("Orientation", (byte)this.facing.ordinal());
        } else {
            nbtTag.func_74774_a("Orientation", (byte)ForgeDirection.NORTH.ordinal());
        }
        nbtTag.func_74783_a("Selected", slotSelected);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.crafterInventory.length; ++i) {
            if (this.crafterInventory[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.crafterInventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbtTag.func_74782_a("Items", (NBTBase)nbttaglist);
        NBTTagList nbttaglist2 = new NBTTagList();
        if (knownRecipes != null) {
            for (int i = 0; i < knownRecipes.size(); ++i) {
                NBTTagCompound nbttagcompound2 = new NBTTagCompound();
                nbttagcompound2.func_74774_a("Recipe", (byte)i);
                knownRecipes.get(i).func_77955_b(nbttagcompound2);
                nbttaglist2.func_74742_a((NBTBase)nbttagcompound2);
            }
            nbtTag.func_74782_a("Known", (NBTBase)nbttaglist2);
        }
    }

    public void func_70296_d() {
        resultList.clear();
        for (int i = 10; i < this.crafterInventory.length - 8; ++i) {
            this.crafterInventory[i] = null;
        }
        List recipes = TierRecipeManager.getInstance().getTierRecipeList(3);
        int count = 0;
        for (int j = 0; j < recipes.size(); ++j) {
            ItemStack stack = ((TierRecipe)recipes.get(j)).hasComponents(this.crafterInventory[0], this.crafterInventory[1], this.crafterInventory[2], this.crafterInventory[3], this.crafterInventory[4], this.crafterInventory[5], this.crafterInventory[6], this.crafterInventory[7], this.crafterInventory[8], this.crafterInventory[9]);
            if (stack == null) continue;
            resultList.add(stack);
            this.crafterInventory[count + 10] = new ItemStack(stack.field_77993_c, 1, 0);
            ++count;
        }
        for (int i = 0; i < resultList.size(); ++i) {
            if (this.listContains(knownRecipes, resultList.get(i))) continue;
            knownRecipes.add(resultList.get(i));
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_70331_k == null) {
            return true;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public ForgeDirection getFacing() {
        if (this.facing != null) {
            return this.facing;
        }
        return ForgeDirection.NORTH;
    }

    public void setFacing(ForgeDirection face) {
        this.facing = face;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public Packet func_70319_e() {
        return PacketHandler.getTEPClient(this);
    }

    public void handlePacketDataFromServer(byte orientation) {
        this.facing = ForgeDirection.getOrientation((int)orientation);
    }

    private boolean listContains(List<ItemStack> list, ItemStack stack) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get((int)i).field_77993_c != stack.field_77993_c) continue;
            return true;
        }
        return false;
    }

    @Override
    public int Tier() {
        return 3;
    }

    @Override
    public List<ItemStack> knownRecipes() {
        return knownRecipes;
    }

    @Override
    public int[] getSlotSelected() {
        return slotSelected;
    }

    @Override
    public void setSlotSelected(int[] selected) {
        slotSelected = selected;
    }

    @Override
    public String getGUIName() {
        return "Advanced age";
    }

    @Override
    public String getGUITexture() {
        return "textures/gui/gui_tierIII_advancedAge.png";
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    static {
        knownRecipes = new ArrayList<ItemStack>();
    }
}

