/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.tile;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import src.train.common.blocks.BlockOpenHearthFurnace;
import src.train.common.core.handlers.PacketHandler;
import src.train.common.library.BlockIDs;
import src.train.common.library.ItemIDs;
import src.train.common.recipes.OpenHearthFurnaceRecipes;

public class TileEntityOpenHearthFurnace
extends TileEntity
implements IInventory {
    public ItemStack[] furnaceItemStacks = new ItemStack[4];
    private ForgeDirection facing;
    public int furnaceBurnTime = 0;
    public int currentItemBurnTime = 0;
    public int furnaceCookTime = 0;
    private int cookDuration = 600;
    private Random random = new Random();

    public int func_70302_i_() {
        return this.furnaceItemStacks.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.furnaceItemStacks[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.furnaceItemStacks[i] != null) {
            if (this.furnaceItemStacks[i].field_77994_a <= j) {
                ItemStack itemstack = this.furnaceItemStacks[i];
                this.furnaceItemStacks[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.furnaceItemStacks[i].func_77979_a(j);
            if (this.furnaceItemStacks[i].field_77994_a == 0) {
                this.furnaceItemStacks[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.furnaceItemStacks[par1] != null) {
            ItemStack var2 = this.furnaceItemStacks[par1];
            this.furnaceItemStacks[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.furnaceItemStacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return "Open Hearth Furnace";
    }

    public void func_70307_a(NBTTagCompound nbtTag) {
        super.func_70307_a(nbtTag);
        this.facing = ForgeDirection.getOrientation((int)nbtTag.func_74771_c("Orientation"));
        NBTTagList nbttaglist = nbtTag.func_74761_m("Items");
        this.furnaceItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
            byte byte0 = nbttagcompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.furnaceItemStacks.length) continue;
            this.furnaceItemStacks[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.furnaceBurnTime = nbtTag.func_74765_d("BurnTime");
        this.furnaceCookTime = nbtTag.func_74765_d("CookTime");
        this.currentItemBurnTime = this.getItemBurnTime(this.furnaceItemStacks[3]);
    }

    public void func_70310_b(NBTTagCompound nbtTag) {
        super.func_70310_b(nbtTag);
        nbtTag.func_74774_a("Orientation", (byte)this.facing.ordinal());
        nbtTag.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        nbtTag.func_74777_a("CookTime", (short)this.furnaceCookTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.length; ++i) {
            if (this.furnaceItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.furnaceItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbtTag.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int i) {
        return this.furnaceCookTime * i / this.cookDuration;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int i) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = this.cookDuration;
        }
        return this.furnaceBurnTime * i / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void func_70316_g() {
        Side side;
        boolean flag = this.furnaceBurnTime > 0;
        boolean flag1 = false;
        this.cookDuration = OpenHearthFurnaceRecipes.smelting().getCookTime(this.furnaceItemStacks[0], this.furnaceItemStacks[1]);
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_70331_k.field_72995_K) {
            if (this.furnaceBurnTime == 0 && this.canSmelt() && this.furnaceItemStacks[2] != null) {
                this.currentItemBurnTime = this.furnaceBurnTime = this.getItemBurnTime(this.furnaceItemStacks[2]);
                if (this.furnaceBurnTime > 0) {
                    flag1 = true;
                    if (this.furnaceItemStacks[2].func_77973_b().func_77634_r()) {
                        this.furnaceItemStacks[2] = new ItemStack(this.furnaceItemStacks[2].func_77973_b().func_77668_q());
                    } else {
                        --this.furnaceItemStacks[2].field_77994_a;
                    }
                    if (this.furnaceItemStacks[2].field_77994_a == 0) {
                        this.furnaceItemStacks[2] = null;
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime == this.cookDuration) {
                    this.furnaceCookTime = 0;
                    this.smeltItem();
                    flag1 = true;
                }
            } else {
                this.furnaceCookTime = 0;
            }
            if (flag != this.furnaceBurnTime > 0) {
                flag1 = true;
                BlockOpenHearthFurnace.updateHearthFurnaceBlockState(this.furnaceBurnTime > 0, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.random);
            }
        }
        if ((side = FMLCommonHandler.instance().getEffectiveSide()) == Side.CLIENT && this.furnaceBurnTime > 0) {
            this.smoke(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.random);
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void smoke(World world, int i, int j, int k, Random random) {
        ForgeDirection side = this.getFacing();
        float var7 = (float)i + 0.5f;
        float var8 = (float)j + 0.0f + random.nextFloat() * 6.0f / 16.0f;
        float var9 = (float)k + 0.5f;
        float var10 = 0.52f;
        float var11 = random.nextFloat() * 0.6f - 0.3f;
        float f3 = 0.009f;
        double gaussian = random.nextGaussian() * (double)f3;
        for (int t = 0; t < 50; ++t) {
            world.func_72869_a("smoke", (double)var7, (double)j + (double)1.2f, (double)var9, gaussian, gaussian * (double)0.002f, gaussian);
        }
        world.func_72869_a("flame", (double)var7, (double)j + (double)1.03f, (double)var9, 0.0, 0.0, 0.0);
        world.func_72869_a("flame", (double)var7 + 0.06, (double)j + (double)1.03f, (double)var9 + 0.06, 0.0, 0.0, 0.0);
        world.func_72869_a("flame", (double)var7 - 0.06, (double)j + (double)1.03f, (double)var9 - 0.06, 0.0, 0.0, 0.0);
        world.func_72869_a("flame", (double)var7 + 0.06, (double)j + (double)1.03f, (double)var9 - 0.06, 0.0, 0.0, 0.0);
        world.func_72869_a("flame", (double)var7 - 0.06, (double)j + (double)1.03f, (double)var9 + 0.06, 0.0, 0.0, 0.0);
    }

    private boolean canSmelt() {
        if (this.furnaceItemStacks[0] == null) {
            return false;
        }
        if (this.furnaceItemStacks[1] == null) {
            return false;
        }
        ItemStack itemstack = OpenHearthFurnaceRecipes.smelting().getSmeltingResultFromItem1(this.furnaceItemStacks[0].func_77973_b().field_77779_bT);
        if (!OpenHearthFurnaceRecipes.smelting().areItemPartOfRecipe(this.furnaceItemStacks[0].func_77946_l(), this.furnaceItemStacks[1].func_77946_l())) {
            return false;
        }
        if (this.furnaceItemStacks[3] == null) {
            return true;
        }
        if (!this.furnaceItemStacks[3].func_77969_a(itemstack)) {
            return false;
        }
        return this.furnaceItemStacks[3].field_77994_a < itemstack.func_77976_d();
    }

    public void smeltItem() {
        if (!this.canSmelt()) {
            return;
        }
        ItemStack itemstack = OpenHearthFurnaceRecipes.smelting().getSmeltingResultFromItem1(this.furnaceItemStacks[0].func_77973_b().field_77779_bT);
        if (this.furnaceItemStacks[3] == null) {
            this.furnaceItemStacks[3] = itemstack.func_77946_l();
        } else if (this.furnaceItemStacks[3].field_77993_c == itemstack.field_77993_c) {
            this.furnaceItemStacks[3].field_77994_a += itemstack.field_77994_a;
        }
        if (this.furnaceItemStacks[0].func_77973_b().func_77634_r()) {
            this.furnaceItemStacks[0] = new ItemStack(this.furnaceItemStacks[0].func_77973_b().func_77668_q());
        } else {
            --this.furnaceItemStacks[0].field_77994_a;
        }
        if (this.furnaceItemStacks[0].field_77994_a <= 0) {
            this.furnaceItemStacks[0] = null;
        }
        if (this.furnaceItemStacks[1].func_77973_b().func_77634_r()) {
            this.furnaceItemStacks[1] = new ItemStack(this.furnaceItemStacks[1].func_77973_b().func_77668_q());
        } else {
            --this.furnaceItemStacks[1].field_77994_a;
        }
        if (this.furnaceItemStacks[1].field_77994_a <= 0) {
            this.furnaceItemStacks[1] = null;
        }
    }

    private int getItemBurnTime(ItemStack it) {
        if (it == null) {
            return 0;
        }
        int var1 = it.func_77973_b().field_77779_bT;
        if (var1 < 256 && Block.field_71973_m[var1].field_72018_cp == Material.field_76245_d) {
            return 300;
        }
        if (var1 == Item.field_77669_D.field_77779_bT) {
            return 100;
        }
        if (var1 == Item.field_77705_m.field_77779_bT) {
            return 2600;
        }
        if (var1 == Item.field_77775_ay.field_77779_bT) {
            return 20000;
        }
        if (var1 == Block.field_71987_y.field_71990_ca) {
            return 100;
        }
        if (var1 == Item.field_77731_bo.field_77779_bT) {
            return 2500;
        }
        if (var1 == BlockIDs.oreTC.blockID && it.func_77960_j() == 1) {
            return 2500;
        }
        if (var1 == BlockIDs.oreTC.blockID && it.func_77960_j() == 2) {
            return 2500;
        }
        if (var1 == ItemIDs.diesel.itemID) {
            return 4000;
        }
        if (var1 == ItemIDs.refinedFuel.itemID) {
            return 6000;
        }
        int ret = GameRegistry.getFuelValue((ItemStack)it);
        return ret;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_70331_k == null) {
            return true;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public ForgeDirection getFacing() {
        if (this.facing != null) {
            return this.facing;
        }
        return ForgeDirection.NORTH;
    }

    public void setFacing(ForgeDirection face) {
        this.facing = face;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public Packet func_70319_e() {
        return PacketHandler.getTEPClient(this);
    }

    public void handlePacketDataFromServer(byte orientation, short cookTime, short burnTime) {
        this.facing = ForgeDirection.getOrientation((int)orientation);
        this.furnaceBurnTime = burnTime;
        this.furnaceCookTime = cookTime;
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }
}

