/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.tile;

import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import src.train.common.api.LiquidManager;
import src.train.common.core.handlers.PacketHandler;

public class TileGeneratorDiesel
extends TileEntity
implements IPowerReceptor,
IPowerEmitter,
IFluidHandler,
IInventory,
IEnergySource {
    private int facingMeta;
    public float energy;
    private boolean powered = false;
    public float extraEnergy;
    private int update;
    public float currentOutput = 0.0f;
    private static final float OUTPUT_MJ = 8.0f;
    private ForgeDirection direction = ForgeDirection.UNKNOWN;
    private PowerHandler provider = new PowerHandler(this, PowerHandler.Type.ENGINE);
    private int maxTank = 0;
    private LiquidManager.StandardTank theTank;
    private IFluidTank[] tankArray = new IFluidTank[1];
    private FluidStack liquid;
    public int amount;
    public int liquidItemID;
    public Side side = FMLCommonHandler.instance().getEffectiveSide();
    private boolean producing = false;
    private int liquidItemIDClient;
    private int amountClient;
    public ItemStack[] dieselItemStacks;
    public boolean addedToEnergyNet = false;
    public int IC2production = 0;

    public TileGeneratorDiesel() {
        this.facingMeta = this.field_70325_p;
        this.provider.configure(2.0f, this.maxEnergyReceived(), 1.0f, this.maxEnergy());
        this.provider.configurePowerPerdition(1, 100);
        this.liquid = new FluidStack(0, 0);
        this.maxTank = 30000;
        LiquidManager liquidManager = LiquidManager.getInstance();
        liquidManager.getClass();
        LiquidManager.getInstance();
        this.theTank = liquidManager.new LiquidManager.FilteredTank(this.maxTank, LiquidManager.dieselFilter(), 1);
        this.tankArray[0] = this.theTank;
        this.dieselItemStacks = new ItemStack[2];
    }

    public int getFacing() {
        return this.facingMeta;
    }

    public void setFacing(int facing) {
        this.facingMeta = facing;
        this.direction = ForgeDirection.getOrientation((int)facing);
    }

    public void onChunkUnload() {
        if (this.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
    }

    public int getMaxEnergyOutput() {
        return 10;
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    @Override
    public double getOfferedEnergy() {
        return this.IC2production;
    }

    @Override
    public void drawEnergy(double amount) {
        this.extractEnergy((float)amount, (float)amount, true);
    }

    public void func_70316_g() {
        if (this.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
        if (!this.field_70331_k.field_72995_K) {
            this.IC2production = (int)((double)this.currentOutput * 2.5);
            this.provider.update();
            ArrayList<TileEntity> tile = new ArrayList<TileEntity>();
            tile.add(0, this.field_70331_k.func_72796_p(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n));
            tile.add(1, this.field_70331_k.func_72796_p(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n));
            tile.add(2, this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n));
            tile.add(3, this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n));
            tile.add(4, this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1));
            tile.add(5, this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1));
            for (int t = 0; t < tile.size(); ++t) {
                if (tile.get(t) == null || !(tile.get(t) instanceof IPowerReceptor)) continue;
                IPowerReceptor receptor = (IPowerReceptor)tile.get(t);
                ForgeDirection dir = ForgeDirection.UNKNOWN;
                if (t == 0) {
                    dir = ForgeDirection.EAST;
                }
                if (t == 1) {
                    dir = ForgeDirection.WEST;
                }
                if (t == 2) {
                    dir = ForgeDirection.DOWN;
                }
                if (t == 3) {
                    dir = ForgeDirection.UP;
                }
                if (t == 4) {
                    dir = ForgeDirection.NORTH;
                }
                if (t == 5) {
                    dir = ForgeDirection.SOUTH;
                }
                if (!this.isPoweredTile((TileEntity)receptor, dir)) continue;
                PowerHandler.PowerReceiver receptor1 = ((IPowerReceptor)tile.get(t)).getPowerReceiver(dir.getOpposite());
                float extracted = this.getPowerToExtract((TileEntity)receptor, dir);
                if (!(extracted > 0.0f)) continue;
                float needed = receptor1.receiveEnergy(PowerHandler.Type.ENGINE, extracted, dir.getOpposite());
                this.extractEnergy(receptor1.getMinEnergyReceived(), needed, true);
                this.IC2production = 0;
            }
            this.burn();
        }
    }

    private float getPowerToExtract(TileEntity tile, ForgeDirection dir) {
        PowerHandler.PowerReceiver receptor = ((IPowerReceptor)tile).getPowerReceiver(dir.getOpposite());
        return this.extractEnergy(receptor.getMinEnergyReceived(), receptor.getMaxEnergyReceived(), false);
    }

    public boolean isPoweredTile(TileEntity tile, ForgeDirection side) {
        if (tile instanceof IPowerReceptor) {
            return ((IPowerReceptor)tile).getPowerReceiver(side.getOpposite()) != null;
        }
        return false;
    }

    public void burn() {
        ++this.update;
        if (this.update % 8 == 0) {
            ItemStack result;
            if (this.dieselItemStacks[0] != null && (result = LiquidManager.getInstance().processContainer(this, 0, this.theTank, this.dieselItemStacks[0], 0)) != null && this.placeInInvent(result, 1, false)) {
                this.placeInInvent(result, 1, true);
            }
            if (this.theTank.getFluid() != null) {
                this.amount = this.theTank.getFluid().amount;
                this.liquidItemID = this.theTank.getFluid().fluidID;
            } else {
                this.amount = 0;
                this.liquidItemID = 0;
            }
            if (this.side.isServer()) {
                PacketHandler.sendPacketToClients(TileGeneratorDiesel.setGeneratorLiquid(this), this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 12.0);
            }
        }
        float output = 0.0f;
        if (this.isPowered() && this.theTank.getFluid() != null && this.theTank.getFluid().amount > this.dieselUsedPerTick() && this.energy < (float)this.maxEnergy()) {
            if (this.update % 8 == 0) {
                this.setIsProducing(true);
            }
            output = this.getMaxOutputMJ();
            this.addEnergy(this.getMaxOutputMJ());
            this.theTank.drain(this.dieselUsedPerTick(), true);
        } else if (this.update % 8 == 0) {
            this.setIsProducing(false);
        }
        this.currentOutput = (this.currentOutput * 74.0f + output) / 75.0f;
    }

    public static Packet setGeneratorLiquid(TileEntity te) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            if (te != null && te instanceof TileGeneratorDiesel) {
                TileGeneratorDiesel tem = (TileGeneratorDiesel)te;
                dos.writeInt(7);
                dos.writeInt(tem.field_70329_l);
                dos.writeInt(tem.field_70330_m);
                dos.writeInt(tem.field_70327_n);
                dos.writeBoolean(tem.isProducing());
                dos.writeShort(tem.amount);
                dos.writeShort(tem.liquidItemID);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload("Traincraft", bos.toByteArray());
        packet.field_73628_b = bos.size();
        return packet;
    }

    public void handlePacketDataFromServer(boolean isProducing, short amount, short liquidID) {
        this.setIsProducing(isProducing);
        this.amountClient = amount;
        this.liquidItemIDClient = liquidID;
    }

    public void func_70307_a(NBTTagCompound nbtTag) {
        super.func_70307_a(nbtTag);
        this.facingMeta = nbtTag.func_74771_c("Orientation");
        this.energy = nbtTag.func_74760_g("Energy");
        this.direction = ForgeDirection.getOrientation((int)nbtTag.func_74762_e("direction"));
        this.theTank.readFromNBT(nbtTag);
        this.powered = nbtTag.func_74767_n("powered");
    }

    public void func_70310_b(NBTTagCompound nbtTag) {
        super.func_70310_b(nbtTag);
        nbtTag.func_74774_a("Orientation", (byte)this.facingMeta);
        nbtTag.func_74776_a("Energy", this.energy);
        nbtTag.func_74768_a("direction", this.facingMeta);
        this.theTank.writeToNBT(nbtTag);
        nbtTag.func_74757_a("powered", this.powered);
    }

    public Packet func_70319_e() {
        return PacketHandler.getTEPClient(this);
    }

    public void handlePacketDataFromServer(byte orientation) {
        this.facingMeta = orientation;
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.provider.getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        if (TileGeneratorDiesel.isNotHost(this.field_70331_k)) {
            return;
        }
        float e = this.provider.useEnergy(1.0f, this.maxEnergyReceived(), true) * 0.95f;
        this.extraEnergy += e;
        this.addEnergy(e);
    }

    public static boolean isNotHost(World world) {
        return world.field_72995_K;
    }

    public float getEnergy() {
        return this.energy;
    }

    public float getCurrentOutput() {
        return this.currentOutput;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setIsPowered(boolean power) {
        this.powered = power;
    }

    public boolean isProducing() {
        return this.producing;
    }

    public void setIsProducing(boolean producing) {
        this.producing = producing;
    }

    public void addEnergy(float addition) {
        this.energy += addition;
        if (this.energy > (float)this.maxEnergy()) {
            this.energy = this.maxEnergy();
        }
    }

    public void subtractEnergy(float subtraction) {
        this.energy -= subtraction;
        if (this.energy < 0.0f) {
            this.energy = 0.0f;
        }
    }

    public float extractEnergy(float min, float max, boolean doExtract) {
        float extracted;
        if (this.energy < min) {
            return 0.0f;
        }
        float combinedMax = (float)this.maxEnergyExtracted() + this.extraEnergy * 0.5f;
        float actualMax = max > combinedMax ? combinedMax : max;
        if (this.energy >= actualMax) {
            extracted = actualMax;
            if (doExtract) {
                this.energy -= actualMax;
                this.extraEnergy -= Math.min(actualMax, this.extraEnergy);
            }
        } else {
            extracted = this.energy;
            if (doExtract) {
                this.energy = 0.0f;
                this.extraEnergy = 0.0f;
            }
        }
        return extracted;
    }

    public boolean isSimulating() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public float getMaxOutputMJ() {
        return 8.0f;
    }

    public int dieselUsedPerTick() {
        return 1;
    }

    public int maxEnergy() {
        return 30000;
    }

    public int maxEnergyReceived() {
        return 1200;
    }

    public int maxEnergyExtracted() {
        return 160;
    }

    public int getLiquidAmount() {
        return this.amountClient;
    }

    public int getLiquidItemIDClient() {
        return this.liquidItemIDClient;
    }

    public LiquidManager.StandardTank getTank() {
        return this.theTank;
    }

    public int getTankCapacity() {
        return this.maxTank;
    }

    private boolean placeInInvent(ItemStack itemstack1, int i, boolean doAdd) {
        if (this.dieselItemStacks[i] == null) {
            if (doAdd) {
                this.dieselItemStacks[i] = itemstack1;
            }
            return true;
        }
        if (this.dieselItemStacks[i] != null && this.dieselItemStacks[i].field_77993_c == itemstack1.field_77993_c && itemstack1.func_77985_e() && (!itemstack1.func_77981_g() || this.dieselItemStacks[i].func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)this.dieselItemStacks[i], (ItemStack)itemstack1)) {
            int var9 = this.dieselItemStacks[i].field_77994_a + itemstack1.field_77994_a;
            if (var9 <= itemstack1.func_77976_d()) {
                if (doAdd) {
                    this.dieselItemStacks[i].field_77994_a = var9;
                }
            } else if (this.dieselItemStacks[i].field_77994_a < itemstack1.func_77976_d() && doAdd) {
                ++this.dieselItemStacks[i].field_77994_a;
            }
            return true;
        }
        return false;
    }

    public int func_70302_i_() {
        return this.dieselItemStacks.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.dieselItemStacks[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.dieselItemStacks[i] != null) {
            if (this.dieselItemStacks[i].field_77994_a <= j) {
                ItemStack itemstack = this.dieselItemStacks[i];
                this.dieselItemStacks[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.dieselItemStacks[i].func_77979_a(j);
            if (this.dieselItemStacks[i].field_77994_a == 0) {
                this.dieselItemStacks[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.dieselItemStacks[par1] != null) {
            ItemStack var2 = this.dieselItemStacks[par1];
            this.dieselItemStacks[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.dieselItemStacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return "Diesel Generator";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_70331_k == null) {
            return true;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public World getWorld() {
        return this.field_70331_k;
    }

    public FluidStack getFluid() {
        return this.theTank.getFluid();
    }

    public int getFluidAmount() {
        return this.theTank.getFluidAmount();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.theTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.theTank.getFluid())) {
            return null;
        }
        return this.theTank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.theTank.drain(maxDrain, doDrain);
    }

    public int getCapacity() {
        return this.maxTank;
    }

    @Override
    public boolean canEmitPowerFrom(ForgeDirection side) {
        return true;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.theTank.getInfo()};
    }
}

