/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.tile;

import cpw.mods.fml.common.FMLCommonHandler;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import src.train.common.core.TrainModBlockUtil;
import src.train.common.core.handlers.PacketHandler;

public class TileWaterWheel
extends TileEntity
implements IEnergySource {
    private int facingMeta;
    private int waterDirection;
    Material blockMaterial;
    private int updateTicks = 0;
    public boolean addedToEnergyNet = false;
    public int production = (int)(120.0 * TrainModBlockUtil.TO_IC2_RATIO);
    public static final int MAX_GENERATE_WATTS = 120;
    public static final int MIN_GENERATE_WATTS = 100;
    public double prevGenerateWatts;
    public double generateWatts = 0.0;

    private int connectDirection() {
        int l = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (l == 3 || l == 1) {
            return 4;
        }
        return 3;
    }

    public TileWaterWheel() {
        this.facingMeta = this.field_70325_p;
    }

    public int getFacing() {
        return this.facingMeta;
    }

    public void setFacing(int facing) {
        this.facingMeta = facing;
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.facingMeta = nbt.func_74771_c("Orientation");
        this.generateWatts = nbt.func_74769_h("generateRate");
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74774_a("Orientation", (byte)this.facingMeta);
        nbt.func_74780_a("generateRate", this.generateWatts);
    }

    public Packet func_70319_e() {
        return PacketHandler.getTEPClient(this);
    }

    public void handlePacketDataFromServer(byte orientation) {
        this.facingMeta = orientation;
        if (orientation != -1) {
            this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, (int)orientation, 2);
        }
    }

    public boolean isSimulating() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public void onChunkUnload() {
        if (this.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
    }

    public void func_70316_g() {
        super.func_70316_g();
        ++this.updateTicks;
        if (this.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
        if (!this.isSimulating()) {
            double dir = 0.0;
            Block blockXP = Block.field_71973_m[this.field_70331_k.func_72798_a(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n)];
            Block blockXN = Block.field_71973_m[this.field_70331_k.func_72798_a(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n)];
            Block blockZP = Block.field_71973_m[this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1)];
            Block blockZN = Block.field_71973_m[this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1)];
            Block blockTop = Block.field_71973_m[this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n)];
            Block blockBottom = Block.field_71973_m[this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n)];
            if (blockXP instanceof BlockFluid && this.field_70331_k.func_72803_f(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n).func_76224_d() && this.field_70331_k.func_72805_g(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n) != 0) {
                if (this.func_70322_n() != 2) {
                    this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 2, 2);
                }
                this.blockMaterial = this.field_70331_k.func_72803_f(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n);
                dir = -1.0;
                if (this.blockMaterial != Material.field_76256_h) {
                    this.setWaterDir((int)dir);
                }
            } else if (blockXN instanceof BlockFluid && this.field_70331_k.func_72803_f(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n).func_76224_d() && this.field_70331_k.func_72805_g(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n) != 0) {
                if (this.func_70322_n() != 0) {
                    this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 2);
                }
                this.blockMaterial = this.field_70331_k.func_72803_f(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n);
                dir = 1.0;
                if (this.blockMaterial != Material.field_76256_h) {
                    this.setWaterDir((int)dir);
                }
            } else if (blockZN instanceof BlockFluid && this.field_70331_k.func_72803_f(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1).func_76224_d() && this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1) != 0) {
                if (this.func_70322_n() != 1) {
                    this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, 2);
                }
                this.blockMaterial = this.field_70331_k.func_72803_f(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1);
                dir = -3.0;
                if (this.blockMaterial != Material.field_76256_h) {
                    this.setWaterDir((int)dir);
                }
            } else if (blockZP instanceof BlockFluid && this.field_70331_k.func_72803_f(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1).func_76224_d() && this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1) != 0) {
                if (this.func_70322_n() != 3) {
                    this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 3, 2);
                }
                this.blockMaterial = this.field_70331_k.func_72803_f(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1);
                dir = 0.0;
                if (this.blockMaterial != Material.field_76256_h) {
                    this.setWaterDir((int)dir);
                }
            } else if (blockTop instanceof BlockFluid && this.field_70331_k.func_72803_f(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n).func_76224_d() && this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n) != 0) {
                this.blockMaterial = this.field_70331_k.func_72803_f(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
                BlockFluid cfr_ignored_0 = (BlockFluid)blockTop;
                dir = BlockFluid.func_72204_a((IBlockAccess)this.field_70331_k, (int)this.field_70329_l, (int)(this.field_70330_m + 1), (int)this.field_70327_n, (Material)this.blockMaterial);
                if (this.blockMaterial != Material.field_76256_h) {
                    this.setWaterDir((int)dir);
                }
            } else if (blockBottom instanceof BlockFluid && this.field_70331_k.func_72803_f(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n).func_76224_d() && this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) != 0) {
                this.blockMaterial = this.field_70331_k.func_72803_f(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
                BlockFluid cfr_ignored_1 = (BlockFluid)blockBottom;
                dir = BlockFluid.func_72204_a((IBlockAccess)this.field_70331_k, (int)this.field_70329_l, (int)(this.field_70330_m - 1), (int)this.field_70327_n, (Material)this.blockMaterial);
                if ((int)dir == -3 || (int)dir == -2) {
                    dir = 0.0;
                } else if ((int)dir == 0) {
                    dir = -3.0;
                } else if ((int)dir == -1) {
                    dir = 1.0;
                } else if ((int)dir == 1) {
                    dir = -1.0;
                }
                if (this.blockMaterial != Material.field_76256_h) {
                    this.setWaterDir((int)dir);
                }
            } else {
                this.setWaterDir(-1001);
            }
            if (this.getWaterDir() == 0 && this.func_70322_n() != 3) {
                this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 3, 2);
                this.sendPacketToServer(TileWaterWheel.getTEPClient(this, 3));
            }
            if ((this.getWaterDir() == -3 || this.getWaterDir() == -2) && this.func_70322_n() != 1) {
                this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, 2);
                this.sendPacketToServer(TileWaterWheel.getTEPClient(this, 1));
            }
            if (this.getWaterDir() == -1 && this.func_70322_n() != 2) {
                this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 2, 2);
                this.sendPacketToServer(TileWaterWheel.getTEPClient(this, 2));
            }
            if (this.getWaterDir() == 1 && this.func_70322_n() != 0) {
                this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 3);
                this.sendPacketToServer(TileWaterWheel.getTEPClient(this, 0));
            }
            if (this.updateTicks % 60 == 0) {
                this.sendPacketToServer(TileWaterWheel.getTEPClient(this, this.func_70322_n()));
            }
        }
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        this.prevGenerateWatts = this.generateWatts;
        if (this.isSimulating()) {
            // empty if block
        }
    }

    private void sendPacketToServer(Packet packet) {
        List list = this.field_70331_k.func_72872_a(EntityPlayer.class, this.func_70311_o().func_71872_e(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n).func_72314_b(10.0, 10.0, 10.0));
        if (list != null && list.size() > 0) {
            for (int j1 = 0; j1 < list.size(); ++j1) {
                Entity entity = (Entity)list.get(j1);
                if (!(entity instanceof EntityPlayer) || !(entity instanceof EntityClientPlayerMP)) continue;
                EntityClientPlayerMP playerMP = (EntityClientPlayerMP)entity;
                playerMP.field_71174_a.func_72552_c(packet);
            }
        }
    }

    private static Packet getTEPClient(TileEntity te, int meta) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            if (te != null && te instanceof TileWaterWheel) {
                TileWaterWheel tem = (TileWaterWheel)te;
                dos.writeInt(0);
                dos.writeInt(tem.field_70329_l);
                dos.writeInt(tem.field_70330_m);
                dos.writeInt(tem.field_70327_n);
                dos.writeByte(meta);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload("Traincraft", bos.toByteArray());
        packet.field_73628_b = bos.size();
        return packet;
    }

    private void setWaterDir(int i) {
        this.waterDirection = i;
    }

    public int getWaterDir() {
        return this.waterDirection;
    }

    public boolean canUpdate() {
        return true;
    }

    public int getMaxEnergyOutput() {
        return this.production;
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        block6: {
            block7: {
                block4: {
                    block5: {
                        if (this.func_70322_n() != 1 && this.func_70322_n() != 3) break block4;
                        if (direction == ForgeDirection.WEST) break block5;
                        if (direction != ForgeDirection.EAST) break block4;
                    }
                    return true;
                }
                if (this.func_70322_n() != 0 && this.func_70322_n() != 2) break block6;
                if (direction == ForgeDirection.NORTH) break block7;
                if (direction != ForgeDirection.SOUTH) break block6;
            }
            return true;
        }
        return false;
    }

    @Override
    public double getOfferedEnergy() {
        if (this.getWaterDir() > -1001) {
            return this.production;
        }
        return 0.0;
    }

    @Override
    public void drawEnergy(double amount) {
    }
}

