/*
 * Decompiled with CFR 0.152.
 */
package src.train.common.tile;

import cpw.mods.fml.common.FMLCommonHandler;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import src.train.common.core.TrainModBlockUtil;
import src.train.common.core.handlers.PacketHandler;
import src.train.common.core.handlers.ServerTickHandler;

public class TileWindMill
extends TileEntity
implements IEnergySource {
    private int facingMeta;
    private int waterDirection;
    Material blockMaterial;
    private int updateTicks = 0;
    private static Random rand = new Random();
    public int windClient = 0;
    public boolean addedToEnergyNet = false;
    public int IC2production = (int)(60.0 * TrainModBlockUtil.TO_IC2_RATIO);
    public static final int MAX_GENERATE_WATTS = 60;

    public TileWindMill() {
        this.facingMeta = this.field_70325_p;
    }

    public int getFacing() {
        return this.facingMeta;
    }

    public void setFacing(int facing) {
        this.facingMeta = facing;
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.facingMeta = nbt.func_74771_c("Orientation");
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74774_a("Orientation", (byte)this.facingMeta);
    }

    public Packet func_70319_e() {
        return PacketHandler.getTEPClient(this);
    }

    public void handlePacketDataFromServer(byte orientation, int wind) {
        this.facingMeta = orientation;
        if (orientation != -1) {
            this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, (int)orientation, 2);
        }
        this.windClient = wind;
    }

    public boolean isSimulating() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public void onChunkUnload() {
        if (this.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
    }

    public void func_70316_g() {
        super.func_70316_g();
        ++this.updateTicks;
        if (this.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
        if (this.updateTicks % 20 == 0 && !this.field_70331_k.field_72995_K && !this.field_70331_k.func_72799_c(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n)) {
            Block block = Block.field_71973_m[this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n)];
            if (block != null) {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(TrainModBlockUtil.getItemStackFromBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m + 1, this.field_70327_n));
                for (ItemStack s : stacks) {
                    EntityItem entityitem = new EntityItem(this.field_70331_k, (double)this.field_70329_l, (double)(this.field_70330_m + 1), (double)this.field_70327_n, s);
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)rand.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)rand.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)rand.nextGaussian() * f3;
                    this.field_70331_k.func_72838_d((Entity)entityitem);
                }
            }
            this.field_70331_k.func_94571_i(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
        }
        if (this.isSimulating() && this.updateTicks % 128 == 0) {
            this.IC2production = (int)((double)ServerTickHandler.windStrength + (double)this.field_70330_m / 256.0 * 10.0);
            if ((double)this.IC2production <= 0.0) {
                this.IC2production = 0;
            }
            if (this.field_70331_k.func_72911_I()) {
                this.IC2production = (int)((double)this.IC2production * 3.5);
            } else if (this.field_70331_k.func_72896_J()) {
                this.IC2production = (int)((double)this.IC2production * 2.2);
            }
            this.IC2production /= 4;
            if (this.IC2production > this.getMaxEnergyOutput()) {
                this.IC2production = this.getMaxEnergyOutput();
            }
            PacketHandler.sendPacketToClients(this.func_70319_e(), this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 40.0);
        }
    }

    public boolean canUpdate() {
        return true;
    }

    public int getMaxEnergyOutput() {
        return 10;
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    @Override
    public double getOfferedEnergy() {
        return this.IC2production;
    }

    @Override
    public void drawEnergy(double amount) {
    }
}

