/*
 * Decompiled with CFR 0.152.
 */
package calclavia.api.mffs.fortron;

import calclavia.api.mffs.fortron.IFortronFrequency;
import calclavia.api.mffs.fortron.IServerThread;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.server.ServerListenThread;
import net.minecraft.server.ThreadMinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import resonant.api.blocks.IBlockFrequency;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class FrequencyGrid {
    private static FrequencyGrid CLIENT_INSTANCE = new FrequencyGrid();
    private static FrequencyGrid SERVER_INSTANCE = new FrequencyGrid();
    private final Set<IBlockFrequency> frequencyGrid = Collections.newSetFromMap(new WeakHashMap());

    public static void reinitiate() {
        CLIENT_INSTANCE = new FrequencyGrid();
        SERVER_INSTANCE = new FrequencyGrid();
    }

    public static FrequencyGrid instance() {
        Thread thr = Thread.currentThread();
        if (thr instanceof ThreadMinecraftServer || thr instanceof ServerListenThread || thr instanceof IServerThread) {
            return SERVER_INSTANCE;
        }
        return CLIENT_INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(IBlockFrequency tileEntity) {
        Set<IBlockFrequency> set = this.frequencyGrid;
        synchronized (set) {
            this.cleanUp();
            this.frequencyGrid.add(tileEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(IBlockFrequency tileEntity) {
        Set<IBlockFrequency> set = this.frequencyGrid;
        synchronized (set) {
            this.frequencyGrid.remove(tileEntity);
            this.cleanUp();
        }
    }

    public Set<IBlockFrequency> get() {
        return this.frequencyGrid;
    }

    public Set<IBlockFrequency> get(int frequency) {
        HashSet<IBlockFrequency> set = new HashSet<IBlockFrequency>();
        for (IBlockFrequency tile : this.get()) {
            if (tile == null || ((TileEntity)tile).func_70320_p() || tile.getFrequency() != frequency) continue;
            set.add(tile);
        }
        return set;
    }

    public void cleanUp() {
        Iterator<IBlockFrequency> it = this.frequencyGrid.iterator();
        while (it.hasNext()) {
            IBlockFrequency frequency = it.next();
            if (frequency == null) {
                it.remove();
                continue;
            }
            if (((TileEntity)frequency).func_70320_p()) {
                it.remove();
                continue;
            }
            if (((TileEntity)frequency).field_70331_k.func_72796_p(((TileEntity)frequency).field_70329_l, ((TileEntity)frequency).field_70330_m, ((TileEntity)frequency).field_70327_n) == (TileEntity)frequency) continue;
            it.remove();
        }
    }

    public Set<IBlockFrequency> get(World world, Vector3 position, int radius, int frequency) {
        HashSet<IBlockFrequency> set = new HashSet<IBlockFrequency>();
        for (IBlockFrequency tileEntity : this.get(frequency)) {
            if (((TileEntity)tileEntity).field_70331_k != world) continue;
            Vector3 vector3 = new Vector3((TileEntity)tileEntity);
            if (!(Vector3.distance((Vector3)vector3, (IVector3)position) <= (double)radius)) continue;
            set.add(tileEntity);
        }
        return set;
    }

    public Set<IFortronFrequency> getFortronTiles(World world) {
        HashSet<IFortronFrequency> set = new HashSet<IFortronFrequency>();
        for (IBlockFrequency tileEntity : this.get()) {
            if (((TileEntity)tileEntity).field_70331_k != world || !(tileEntity instanceof IFortronFrequency)) continue;
            set.add((IFortronFrequency)tileEntity);
        }
        return set;
    }

    public Set<IFortronFrequency> getFortronTiles(World world, Vector3 position, int radius, int frequency) {
        HashSet<IFortronFrequency> set = new HashSet<IFortronFrequency>();
        for (IBlockFrequency tileEntity : this.get(frequency)) {
            if (((TileEntity)tileEntity).field_70331_k != world || !(tileEntity instanceof IFortronFrequency)) continue;
            Vector3 vector3 = new Vector3((TileEntity)tileEntity);
            if (!(Vector3.distance((Vector3)vector3, (IVector3)position) <= (double)radius)) continue;
            set.add((IFortronFrequency)tileEntity);
        }
        return set;
    }
}

