/*
 * Decompiled with CFR 0.152.
 */
package resonant.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import resonant.api.IBoilHandler;
import resonant.core.content.BlockBase;
import resonant.core.content.ComponentRegistry;
import resonant.core.content.ItemBase;
import resonant.core.content.ItemIngot;
import resonant.core.content.ItemPlate;
import resonant.core.content.ItemScrewdriver;
import resonant.core.content.debug.BlockCreativeBuilder;
import resonant.core.content.debug.BlockInfiniteBlock;
import resonant.core.content.tool.ToolMode;
import resonant.core.content.tool.ToolModeGeneral;
import resonant.core.content.tool.ToolModeRotation;
import resonant.lib.References;
import resonant.lib.compat.waila.Waila;
import resonant.lib.config.Config;
import resonant.lib.config.ConfigHandler;
import resonant.lib.config.ConfigScanner;
import resonant.lib.content.ContentRegistry;
import resonant.lib.content.IDManager;
import resonant.lib.flag.CommandFlag;
import resonant.lib.flag.FlagRegistry;
import resonant.lib.flag.ModFlag;
import resonant.lib.grid.UECommand;
import resonant.lib.grid.UpdateTicker;
import resonant.lib.modproxy.ProxyHandler;
import resonant.lib.multiblock.BlockMultiBlockPart;
import resonant.lib.multiblock.TileMultiBlockPart;
import resonant.lib.network.PacketHandler;
import resonant.lib.prefab.ProxyBase;
import resonant.lib.prefab.item.ItemBlockMetadata;
import resonant.lib.prefab.ore.OreGenBase;
import resonant.lib.prefab.ore.OreGenReplaceStone;
import resonant.lib.prefab.ore.OreGenerator;
import resonant.lib.recipe.RecipeUtility;
import resonant.lib.schematic.SchematicTestRoom;
import resonant.lib.thermal.BoilEvent;
import resonant.lib.thermal.EventThermal;
import resonant.lib.thermal.ThermalGrid;
import resonant.lib.utility.LanguageUtility;
import resonant.lib.utility.PlayerInteractionHandler;
import resonant.lib.utility.PotionUtility;
import resonant.lib.utility.nbt.NBTUtility;
import resonant.lib.utility.nbt.SaveManager;
import universalelectricity.api.net.IUpdate;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorWorld;
import universalelectricity.core.net.NetworkTickHandler;

@Mod(modid="ResonantEngine", name="ResonantEngine", version="@MAJOR@.@MINOR@.@REVIS@", dependencies="required-after:UniversalElectricity")
@NetworkMod(channels={"resonantengine"}, clientSideRequired=true, serverSideRequired=false, packetHandler=PacketHandler.class)
public class ResonantEngine {
    public static final IDManager idManager = new IDManager(3970, 13970);
    public static final ContentRegistry contentRegistry = new ContentRegistry(References.CONFIGURATION, idManager, "ResonantEngine").setPrefix("resonant:").setTab(CreativeTabs.field_78040_i);
    @SidedProxy(clientSide="resonant.core.ClientProxy", serverSide="resonant.lib.prefab.ProxyBase")
    public static ProxyBase proxy;
    @Mod.Metadata(value="ResonantEngine")
    public static ModMetadata metadata;
    @Mod.Instance(value="ResonantEngine")
    public static ResonantEngine INSTANCE;
    public static final int idBlockOreCopper;
    public static final int idBlockOreTin;
    public static final int idItemWrench;
    public static final int idItemMotor;
    public static final int idItemCircuitBasic;
    public static final int idItemCircuitAdvanced;
    public static final int idItemCircuitElite;
    public static final int idItemPlateCopper;
    public static final int idItemPlateTin;
    public static final int idItemPlateBronze;
    public static final int idItemPlateSteel;
    public static final int idItemPlateIron;
    public static final int idItemPlateGold;
    public static final int idItemIngotCopper;
    public static final int idItemIngotTin;
    public static final int idItemIngotSteel;
    public static final int idItemIngotBronze;
    public static final int idItemDustSteel;
    public static final int idItemDustBronze;
    public static boolean runningAsDev;
    public static Block blockOreCopper;
    public static Block blockOreTin;
    public static Item itemWrench;
    public static Item itemMotor;
    public static Item itemCircuitBasic;
    public static Item itemCircuitAdvanced;
    public static Item itemCircuitElite;
    public static Item itemPlateCopper;
    public static Item itemPlateTin;
    public static Item itemPlateBronze;
    public static Item itemPlateSteel;
    public static Item itemPlateIron;
    public static Item itemPlateGold;
    public static Item itemIngotCopper;
    public static Item itemIngotTin;
    public static Item itemIngotSteel;
    public static Item itemIngotBronze;
    public static Item itemDustSteel;
    public static Item itemDustBronze;
    public static OreGenBase generationOreCopper;
    public static OreGenBase generationOreTin;
    public static BlockMultiBlockPart blockMulti;
    public static BlockCreativeBuilder blockCreativeBuilder;
    public static Block blockInfinite;
    @Config
    public static double steamMultiplier;
    private ProxyHandler modproxies = new ProxyHandler();
    private static ThermalGrid thermalGrid;

    public ResonantEngine() {
        thermalGrid = new ThermalGrid();
    }

    @Deprecated
    public static Item requireItem(String fieldName, int id) {
        try {
            String name = fieldName.replace("item", "");
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            Field field = ReflectionHelper.findField(ResonantEngine.class, (String[])new String[]{fieldName});
            Item f = (Item)field.get(null);
            Field idField = ReflectionHelper.findField(ResonantEngine.class, (String[])new String[]{"id" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1)});
            int n = id = id <= 0 ? (Integer)idField.get(null) : id;
            if (f == null) {
                Item item;
                if (name.contains("ingot")) {
                    ItemIngot ingot = new ItemIngot(name, id);
                    field.set(null, (Object)ingot);
                    OreDictionary.registerOre((String)name, (Item)ingot);
                } else if (name.contains("plate")) {
                    field.set(null, (Object)new ItemPlate(name, id));
                    item = (Item)field.get(null);
                    String ingotName = name.replaceAll("plate", "ingot");
                    Item itemIngot = null;
                    if (OreDictionary.getOres((String)ingotName).size() > 0) {
                        itemIngot = ((ItemStack)OreDictionary.getOres((String)ingotName).get(0)).func_77973_b();
                    }
                    if (name.equals("plateIron")) {
                        itemIngot = Item.field_77703_o;
                    } else if (name.equals("plateGold")) {
                        itemIngot = Item.field_77717_p;
                    }
                    if (itemIngot != null && OreDictionary.getOres((String)ingotName).size() == 0) {
                        RecipeUtility.addRecipe((IRecipe)new ShapedOreRecipe(item, new Object[]{"II", "II", Character.valueOf('I'), itemIngot}), References.CONFIGURATION, true);
                    }
                    RecipeUtility.addRecipe((IRecipe)new ShapedOreRecipe(item, new Object[]{"II", "II", Character.valueOf('I'), ingotName}), References.CONFIGURATION, true);
                } else if (name.contains("dust")) {
                    field.set(null, new ItemBase(name, id).func_77637_a(CreativeTabs.field_78035_l));
                    item = (Item)field.get(null);
                    if (name.equals("dustBronze")) {
                        RecipeUtility.addRecipe((IRecipe)new ShapedOreRecipe(item, new Object[]{"!#!", Character.valueOf('!'), "ingotCopper", Character.valueOf('#'), "ingotTin"}), References.CONFIGURATION, true);
                        if (OreDictionary.getOres((String)"ingotBronze").size() > 0) {
                            GameRegistry.addSmelting((int)item.field_77779_bT, (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotBronze").get(0)), (float)0.6f);
                        }
                    } else if (name.equals("dustSteel")) {
                        RecipeUtility.addShaplessRecipe(new ItemStack(item), new Object[]{new ItemStack(Item.field_77705_m, 1), new ItemStack(Item.field_77705_m, 1), new ItemStack(Item.field_77703_o)}, References.CONFIGURATION, true);
                        RecipeUtility.addShaplessRecipe(new ItemStack(item), new Object[]{new ItemStack(Item.field_77705_m, 1, 1), new ItemStack(Item.field_77705_m, 1, 1), new ItemStack(Item.field_77703_o)}, References.CONFIGURATION, true);
                        RecipeUtility.addShaplessRecipe(new ItemStack(item), new Object[]{new ItemStack(Item.field_77705_m, 1, 1), new ItemStack(Item.field_77705_m, 1), new ItemStack(Item.field_77703_o)}, References.CONFIGURATION, true);
                        if (OreDictionary.getOres((String)"ingotSteel").size() > 0) {
                            GameRegistry.addSmelting((int)item.field_77779_bT, (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotSteel").get(0)), (float)0.8f);
                        }
                    }
                } else if (name.equals("wrench")) {
                    field.set(null, new ItemScrewdriver(id));
                    item = (Item)field.get(null);
                    if (OreDictionary.getOres((String)"ingotSteel").size() > 0) {
                        RecipeUtility.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{" S ", "W  ", Character.valueOf('S'), "ingotSteel", Character.valueOf('W'), Block.field_71951_J}), References.CONFIGURATION, true);
                    } else {
                        RecipeUtility.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{" S ", "W  ", Character.valueOf('S'), Item.field_77703_o, Character.valueOf('W'), Block.field_71951_J}), References.CONFIGURATION, true);
                    }
                } else {
                    field.set(null, new ItemBase(name, id).func_77637_a(CreativeTabs.field_78035_l));
                    item = (Item)field.get(null);
                    if (name.equals("circuitBasic")) {
                        if (OreDictionary.getOres((String)"plateBronze").size() > 0) {
                            if (OreDictionary.getOres((String)"copperWire").size() > 0) {
                                RecipeUtility.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{"!#!", "#@#", "!#!", Character.valueOf('@'), "plateBronze", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('!'), "copperWire"}), References.CONFIGURATION, true);
                                RecipeUtility.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{"!#!", "#@#", "!#!", Character.valueOf('@'), "plateSteel", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('!'), "copperWire"}), References.CONFIGURATION, true);
                            } else {
                                RecipeUtility.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{"!#!", "#@#", "!#!", Character.valueOf('@'), "plateBronze", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('!'), Item.field_94585_bY}), References.CONFIGURATION, true);
                                RecipeUtility.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{"!#!", "#@#", "!#!", Character.valueOf('@'), "plateSteel", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('!'), Item.field_94585_bY}), References.CONFIGURATION, true);
                            }
                        } else {
                            RecipeUtility.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{"!#!", "#@#", "!#!", Character.valueOf('@'), Block.field_72083_ai, Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('!'), Item.field_94585_bY}), References.CONFIGURATION, true);
                        }
                    } else if (name.equals("circuitAdvanced")) {
                        RecipeUtility.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{"@@@", "#?#", "@@@", Character.valueOf('@'), Item.field_77767_aC, Character.valueOf('?'), Item.field_77702_n, Character.valueOf('#'), "circuitBasic"}), References.CONFIGURATION, true);
                    } else if (name.equals("circuitElite")) {
                        RecipeUtility.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{"@@@", "?#?", "@@@", Character.valueOf('@'), Item.field_77717_p, Character.valueOf('?'), "circuitAdvanced", Character.valueOf('#'), Block.field_71948_O}), References.CONFIGURATION, true);
                    } else if (name.equals("motor")) {
                        if (OreDictionary.getOres((String)"copperWire").size() > 0) {
                            RecipeUtility.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{"@!@", "!#!", "@!@", Character.valueOf('!'), "ingotSteel", Character.valueOf('#'), Item.field_77703_o, Character.valueOf('@'), "copperWire"}), References.CONFIGURATION, true);
                        } else {
                            RecipeUtility.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{"@!@", "!#!", "@!@", Character.valueOf('!'), "ingotSteel", Character.valueOf('#'), Item.field_77703_o, Character.valueOf('@'), Item.field_94585_bY}), References.CONFIGURATION, true);
                        }
                    }
                }
                item = (Item)field.get(null);
                GameRegistry.registerItem((Item)item, (String)name);
                OreDictionary.registerOre((String)name, (Item)item);
                FMLLog.info((String)("Resonant Engine: Successfully requested item: " + name), (Object[])new Object[0]);
                return item;
            }
            return f;
        }
        catch (Exception e) {
            FMLLog.severe((String)("Resonant Engine: Failed to require item: " + fieldName), (Object[])new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static Item requestItem(String name, int id) {
        if (OreDictionary.getOres((String)name).size() <= 0) {
            return ResonantEngine.requireItem(name, id);
        }
        FMLLog.info((String)("Resonant Engine: " + name + " already exists in Ore Dictionary, using the ore instead."), (Object[])new Object[0]);
        if (OreDictionary.getOres((String)name).size() > 0) {
            return ((ItemStack)OreDictionary.getOres((String)name).get(0)).func_77973_b();
        }
        return null;
    }

    @Deprecated
    public static Block requireBlock(String fieldName, int id) {
        try {
            String name = fieldName.replace("block", "");
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            Field field = ReflectionHelper.findField(ResonantEngine.class, (String[])new String[]{fieldName});
            Block f = (Block)field.get(null);
            Field idField = ReflectionHelper.findField(ResonantEngine.class, (String[])new String[]{"id" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1)});
            int n = id = id <= 0 ? (Integer)idField.get(null) : id;
            if (f == null) {
                Block block;
                if (name.contains("ore")) {
                    field.set(null, (Object)new BlockBase(name, id));
                    block = (Block)field.get(null);
                    GameRegistry.registerBlock((Block)block, (String)name);
                    OreDictionary.registerOre((String)name, (Block)block);
                    String ingotName = name.replaceAll("ore", "ingot");
                    if (OreDictionary.getOres((String)ingotName).size() > 0) {
                        GameRegistry.addSmelting((int)block.field_71990_ca, (ItemStack)((ItemStack)OreDictionary.getOres((String)ingotName).get(0)), (float)0.6f);
                    }
                    Field generationField = ReflectionHelper.findField(ResonantEngine.class, (String[])new String[]{"generation" + Character.toUpperCase(name.charAt(0)) + name.substring(1)});
                    generationField.set(null, new OreGenReplaceStone(name, name, new ItemStack(block), 60, 25, 4).enable(References.CONFIGURATION));
                    OreGenerator.addOre((OreGenReplaceStone)generationField.get(null));
                }
                block = (Block)field.get(null);
                FMLLog.info((String)("Resonant Engine: Successfully requested block: " + name), (Object[])new Object[0]);
                return block;
            }
            return f;
        }
        catch (Exception e) {
            FMLLog.severe((String)("Resonant Engine: Failed to require block: " + fieldName), (Object[])new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    public static Block requestBlock(String name, int id) {
        if (OreDictionary.getOres((String)name).size() <= 0) {
            return ResonantEngine.requireBlock(name, id);
        }
        FMLLog.info((String)("Resonant Engine: " + name + " already exists in Ore Dictionary, using the ore instead."), (Object[])new Object[0]);
        if (((ItemStack)OreDictionary.getOres((String)name).get(0)).func_77973_b() instanceof ItemBlock) {
            return Block.field_71973_m[((ItemBlock)((ItemStack)OreDictionary.getOres((String)name).get(0)).func_77973_b()).func_77883_f()];
        }
        return null;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        References.LOGGER.setParent(FMLLog.getLogger());
        ConfigScanner.instance().generateSets(evt.getAsmData());
        String inEclipse = System.getProperty("uedev");
        if (inEclipse != null && inEclipse.equals("true")) {
            References.LOGGER.fine("\n######Running mod as a dev IDE######\n");
            runningAsDev = true;
        }
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)proxy);
        this.modproxies.applyModule(Waila.class, true);
        PotionUtility.resizePotionArray();
        SaveManager.registerClass("ModFlag", ModFlag.class);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)SaveManager.instance());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerInteractionHandler());
        ToolMode.REGISTRY.add(new ToolModeGeneral());
        ToolMode.REGISTRY.add(new ToolModeRotation());
        blockMulti = (BlockMultiBlockPart)contentRegistry.createTile(BlockMultiBlockPart.class, TileMultiBlockPart.class).func_71849_a(null);
        blockMulti.setPacketType(References.PACKET_TILE);
        if (References.CONFIGURATION.get("CreaiveModeTools", "CreativeBuilder", runningAsDev).getBoolean(true)) {
            blockCreativeBuilder = (BlockCreativeBuilder)contentRegistry.createBlock(BlockCreativeBuilder.class);
        }
        if (References.CONFIGURATION.get("CreaiveModeTools", "InfiniteSource", runningAsDev).getBoolean(true)) {
            blockInfinite = contentRegistry.createBlock(BlockInfiniteBlock.class, ItemBlockMetadata.class);
        }
        BlockCreativeBuilder.register(new SchematicTestRoom());
        References.CONFIGURATION.load();
        References.CONFIGURATION.save();
        proxy.preInit();
        this.modproxies.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        boolean defaultDoLoad;
        References.CONFIGURATION.load();
        boolean bl = defaultDoLoad = !Loader.isModLoaded((String)"ThermalExpansion") && !Loader.isModLoaded((String)"IC2");
        if (References.CONFIGURATION.get("general", "Enable_Calclavia_Core_Resources", defaultDoLoad).getBoolean(defaultDoLoad)) {
            ComponentRegistry.registerAll();
            ComponentRegistry.register("itemIngotCopper");
            ComponentRegistry.register("itemIngotTin");
            ComponentRegistry.register("blockOreCopper");
            ComponentRegistry.register("blockOreTin");
            ComponentRegistry.register("itemIngotSteel");
            ComponentRegistry.register("itemDustSteel");
            ComponentRegistry.register("itemPlateSteel");
            ComponentRegistry.register("itemIngotBronze");
            ComponentRegistry.register("itemDustBronze");
            ComponentRegistry.register("itemPlateBronze");
            ComponentRegistry.register("itemPlateCopper");
            ComponentRegistry.register("itemPlateTin");
            ComponentRegistry.register("itemPlateIron");
            ComponentRegistry.register("itemPlateGold");
        }
        if (References.CONFIGURATION.get("general", "Enable_Calclavia_Core_Tools", true).getBoolean(true)) {
            ComponentRegistry.register("itemCircuitBasic");
            ComponentRegistry.register("itemCircuitAdvanced");
            ComponentRegistry.register("itemCircuitElite");
            ComponentRegistry.register("itemWrench");
        }
        References.LOGGER.fine("Attempting to load " + ComponentRegistry.requests.size() + " items.");
        for (String request : ComponentRegistry.requests) {
            if (request.contains("block")) {
                ResonantEngine.requestBlock(request, 0);
                continue;
            }
            if (request.contains("item")) {
                ResonantEngine.requestItem(request, 0);
                continue;
            }
            References.LOGGER.severe("Failed to load Resonant Engine item: " + request);
        }
        References.CONFIGURATION.save();
        References.LOGGER.fine("Loaded: " + LanguageUtility.loadLanguages("/assets/resonant/languages/", References.LANGUAGES) + " Languages.");
        ResonantEngine.metadata.modId = "ResonantEngine";
        ResonantEngine.metadata.name = "ResonantEngine";
        ResonantEngine.metadata.description = "ResonantEngine is a mod developement framework designed to assist in creation of mods. It provided basic classes for packet handling, tile creation, inventory handling, saving/loading of NBT, and general all around prefabs.";
        ResonantEngine.metadata.url = "https://github.com/Universal-Electricity/Resonant-Engine";
        ResonantEngine.metadata.version = "@MAJOR@.@MINOR@.@REVIS@@BUILD@";
        ResonantEngine.metadata.authorList = Arrays.asList("Calclavia", "DarkCow", "tgame14", "Maxwolf");
        ResonantEngine.metadata.autogenerated = false;
        proxy.init();
        this.modproxies.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        if (!UpdateTicker.INSTANCE.isAlive()) {
            UpdateTicker.INSTANCE.start();
        }
        ConfigHandler.configure(References.CONFIGURATION, "resonant");
        UpdateTicker.addNetwork(thermalGrid);
        this.modproxies.postInit();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        Object object = SaveManager.createAndLoad(NBTUtility.loadData("ModFlags"), new Object[0]);
        if (!(object instanceof ModFlag)) {
            object = new ModFlag("ModFlags");
        }
        FlagRegistry.registerModFlag("ModFlags", (ModFlag)object);
        ICommandManager commandManager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D();
        ServerCommandManager serverCommandManager = (ServerCommandManager)commandManager;
        serverCommandManager.func_71560_a((ICommand)new CommandFlag(FlagRegistry.getModFlag("ModFlags")));
        serverCommandManager.func_71560_a((ICommand)new UECommand());
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent evt) {
        SaveManager.saveAll();
    }

    @ForgeSubscribe
    public void boilEventHandler(BoilEvent evt) {
        World world = evt.world;
        Vector3 position = evt.position;
        int blockID = position.getBlockID((IBlockAccess)world);
        for (int height = 1; height <= evt.maxSpread; ++height) {
            TileEntity tileEntity = world.func_72796_p(position.intX(), position.intY() + height, position.intZ());
            if (!(tileEntity instanceof IBoilHandler)) continue;
            IBoilHandler handler = (IBoilHandler)tileEntity;
            FluidStack fluid = evt.getRemainForSpread(height);
            if (fluid.amount <= 0 || !handler.canFill(ForgeDirection.DOWN, fluid.getFluid())) continue;
            fluid.amount -= handler.fill(ForgeDirection.DOWN, fluid, true);
        }
        evt.setResult(Event.Result.DENY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForgeSubscribe
    public void thermalEventHandler(EventThermal.EventThermalUpdate evt) {
        final VectorWorld pos = evt.position;
        World world = pos.world;
        synchronized (world) {
            Block block = Block.field_71973_m[pos.getBlockID()];
            Material mat = pos.world.func_72803_f(pos.intX(), pos.intY(), pos.intZ());
            if (mat == Material.field_76249_a) {
                evt.heatLoss = 0.15f;
            }
            if ((block == Block.field_71942_A || block == Block.field_71943_B) && evt.temperature >= 373.0f) {
                if (FluidRegistry.getFluid((String)"steam") != null) {
                    int volume = (int)((double)(1000.0f * (evt.temperature / 373.0f)) * steamMultiplier);
                    MinecraftForge.EVENT_BUS.post((Event)new BoilEvent(pos.world, (Vector3)pos, new FluidStack(FluidRegistry.WATER, volume), new FluidStack(FluidRegistry.getFluid((String)"steam"), volume), 2, evt.isReactor));
                }
                evt.heatLoss = 0.2f;
            }
            if (block == Block.field_72036_aT) {
                if (evt.temperature >= 273.0f) {
                    NetworkTickHandler.addNetwork((IUpdate)new IUpdate(){

                        public void update() {
                            pos.setBlock(Block.field_71942_A.field_71990_ca);
                        }

                        public boolean canUpdate() {
                            return true;
                        }

                        public boolean continueUpdate() {
                            return false;
                        }
                    });
                }
                evt.heatLoss = 0.4f;
            }
        }
    }

    static {
        idBlockOreCopper = idManager.getNextBlockID();
        idBlockOreTin = idManager.getNextBlockID();
        idItemWrench = idManager.getNextItemID();
        idItemMotor = idManager.getNextItemID();
        idItemCircuitBasic = idManager.getNextItemID();
        idItemCircuitAdvanced = idManager.getNextItemID();
        idItemCircuitElite = idManager.getNextItemID();
        idItemPlateCopper = idManager.getNextItemID();
        idItemPlateTin = idManager.getNextItemID();
        idItemPlateBronze = idManager.getNextItemID();
        idItemPlateSteel = idManager.getNextItemID();
        idItemPlateIron = idManager.getNextItemID();
        idItemPlateGold = idManager.getNextItemID();
        idItemIngotCopper = idManager.getNextItemID();
        idItemIngotTin = idManager.getNextItemID();
        idItemIngotSteel = idManager.getNextItemID();
        idItemIngotBronze = idManager.getNextItemID();
        idItemDustSteel = idManager.getNextItemID();
        idItemDustBronze = idManager.getNextItemID();
        runningAsDev = false;
        steamMultiplier = 1.0;
    }
}

