/*
 * Decompiled with CFR 0.152.
 */
package resonant.core.content.debug;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import resonant.core.content.debug.TileInfiniteEnergy;
import resonant.core.content.debug.TileInfiniteFluid;
import resonant.lib.content.BlockInfo;
import resonant.lib.multiblock.IBlockActivate;
import resonant.lib.prefab.block.BlockSidedIO;
import universalelectricity.api.UniversalElectricity;

@BlockInfo(tileEntity={"resonant.core.content.debug.TileInfiniteEnergy", "resonant.core.content.debug.TileInfiniteFluid"})
public class BlockInfiniteBlock
extends BlockSidedIO {
    public BlockInfiniteBlock(int id) {
        super(id, UniversalElectricity.machine);
        this.func_71849_a(CreativeTabs.field_78040_i);
        this.func_71875_q();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconReg) {
        super.func_94332_a(iconReg);
        for (Types block : Types.values()) {
            block.icon = iconReg.func_94245_a("resonant:" + block.getTextureName());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        if (meta < Types.values().length) {
            return Types.values()[meta].icon;
        }
        return this.field_94336_cN;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata < Types.values().length) {
            try {
                return Types.values()[metadata].clazz.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.createTileEntity(world, metadata);
    }

    public void func_71879_a(int blockID, CreativeTabs tab, List creativeTabList) {
        for (Types block : Types.values()) {
            creativeTabList.add(new ItemStack(blockID, 1, block.ordinal()));
        }
    }

    @Override
    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_72796_p(x, y, z);
        return tile instanceof IBlockActivate && ((IBlockActivate)tile).onActivated(entityPlayer);
    }

    private static enum Types {
        ENERGY("infiniteEnergy", TileInfiniteEnergy.class),
        FLUID("infiniteFluid", TileInfiniteFluid.class);

        public Icon icon;
        public String name;
        public String texture;
        Class<? extends TileEntity> clazz;

        private Types(String name, Class<? extends TileEntity> clazz) {
            this.name = name;
            this.clazz = clazz;
            this.texture = name;
        }

        public String getTextureName() {
            if (this.texture == null || this.texture.isEmpty()) {
                return this.name;
            }
            return this.texture;
        }
    }
}

