/*
 * Decompiled with CFR 0.152.
 */
package resonant.core.content.debug;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import resonant.lib.multiblock.IBlockActivate;
import resonant.lib.prefab.tile.TileIO;
import universalelectricity.api.UniversalElectricity;
import universalelectricity.api.vector.Vector3;

public class TileInfiniteFluid
extends TileIO
implements IFluidHandler,
IBlockActivate {
    FluidTank tank;
    boolean active = false;

    public TileInfiniteFluid() {
        super(UniversalElectricity.machine);
        this.saveIOMap = true;
        this.tank = new FluidTank(Integer.MAX_VALUE);
        this.ioMap = (short)728;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.active) {
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile;
                if (!this.getOutputDirections().contains(direction) || !((tile = new Vector3((TileEntity)this).translate(direction).getTileEntity((IBlockAccess)this.field_70331_k)) instanceof IFluidHandler)) continue;
                ((IFluidHandler)tile).fill(direction.getOpposite(), this.tank.getFluid(), true);
            }
        }
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.getInputDirections().contains(from)) {
            return resource.amount;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.getOutputDirections().contains(from)) {
            return resource;
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.getOutputDirections().contains(from)) {
            return this.tank.drain(maxDrain, false);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.getInputDirections().contains(from);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.getOutputDirections().contains(from);
    }

    @Override
    public boolean onActivated(EntityPlayer entityPlayer) {
        if (entityPlayer != null && entityPlayer.func_70694_bm() != null) {
            if (entityPlayer.func_70694_bm().func_77973_b() == Item.field_77669_D) {
                this.active = !this.active;
                entityPlayer.func_70006_a(ChatMessageComponent.func_111066_d((String)("[FluidVoid]Pumping:" + this.active)));
                return true;
            }
            FluidStack stack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)entityPlayer.func_70694_bm());
            if (stack != null) {
                stack = stack.copy();
                stack.amount = Integer.MAX_VALUE;
                this.tank.setFluid(stack);
                entityPlayer.func_70006_a(ChatMessageComponent.func_111066_d((String)("[FluidVoid]Fluid:" + stack.getFluid().getName())));
                return true;
            }
        }
        return false;
    }
}

