/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.access;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import resonant.lib.access.AccessGroup;
import resonant.lib.access.AccessUser;
import resonant.lib.access.AccessUtility;
import resonant.lib.access.IProfileContainer;
import resonant.lib.utility.LanguageUtility;
import resonant.lib.utility.nbt.IVirtualObject;
import resonant.lib.utility.nbt.NBTUtility;
import resonant.lib.utility.nbt.SaveManager;

public class AccessProfile
implements IVirtualObject {
    private static final Set<AccessProfile> globalList = new LinkedHashSet<AccessProfile>();
    private final Set<IProfileContainer> containers = Collections.newSetFromMap(new WeakHashMap());
    protected Set<AccessGroup> groups = new LinkedHashSet<AccessGroup>();
    protected String profileName = "";
    protected String profileID = "LocalHost";
    protected boolean global = false;
    protected File saveFile;

    public AccessProfile() {
        if (this.global) {
            SaveManager.register(this);
            globalList.add(this);
        }
    }

    public AccessProfile(NBTTagCompound nbt) {
        this(nbt, false);
    }

    public AccessProfile(NBTTagCompound nbt, boolean global) {
        this();
        this.load(nbt);
        if (this.profileName == null || this.profileID == null) {
            if (!global) {
                this.generateNew("Default", null);
            } else {
                this.generateNew("New Group", "global");
            }
        }
    }

    public static AccessProfile get(String name) {
        for (AccessProfile profile : globalList) {
            if (!profile.getID().equalsIgnoreCase(name)) continue;
            return profile;
        }
        return null;
    }

    public AccessProfile generateNew(String name, Object object) {
        AccessUtility.loadNewGroupSet(this);
        this.profileName = name;
        name.replaceAll(" ", "");
        String id = null;
        if (object instanceof EntityPlayer) {
            id = ((EntityPlayer)object).field_71092_bJ + "_" + System.currentTimeMillis();
            this.global = true;
        } else if (object instanceof TileEntity || object == null) {
            id = "LocalHost:" + name;
        } else if (object instanceof String && ((String)object).equalsIgnoreCase("global")) {
            id = "P_" + name + "_" + System.currentTimeMillis();
            this.global = true;
        }
        this.profileID = id;
        return this;
    }

    public String getName() {
        return this.profileName;
    }

    public String getID() {
        return this.profileID;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public AccessUser getUserAccess(String username) {
        for (AccessGroup group : this.groups) {
            AccessUser user = group.getMember(username);
            if (user == null) continue;
            return user;
        }
        return new AccessUser(username);
    }

    public List<AccessUser> getUsers() {
        ArrayList<AccessUser> users = new ArrayList<AccessUser>();
        for (AccessGroup group : this.groups) {
            users.addAll(group.getMembers());
        }
        return users;
    }

    public void addContainer(IProfileContainer container) {
        if (!this.containers.contains(container)) {
            this.containers.add(container);
        }
    }

    public boolean setUserAccess(String player, AccessGroup g) {
        return this.setUserAccess(player, g, true);
    }

    public boolean setUserAccess(String player, AccessGroup g, boolean save) {
        return this.setUserAccess(new AccessUser(player).setTempary(!save), g);
    }

    public boolean setUserAccess(AccessUser user, AccessGroup group) {
        boolean bool = false;
        if (user != null && user.getName() != null) {
            boolean bl = bool = this.removeUserAccess(user.getName()) && group == null;
            if (group != null) {
                bool = group.addMemeber(user);
            }
            if (bool) {
                this.onProfileUpdate();
            }
        }
        return bool;
    }

    public boolean removeUserAccess(String player) {
        boolean re = false;
        for (AccessGroup group : this.groups) {
            AccessUser user = group.getMember(player);
            if (user == null || !group.removeMemeber(user)) continue;
            re = true;
        }
        if (re) {
            this.onProfileUpdate();
        }
        return re;
    }

    public void onProfileUpdate() {
        Iterator<IProfileContainer> it = this.containers.iterator();
        while (it.hasNext()) {
            IProfileContainer container = it.next();
            if (container != null && this.equals(container.getAccessProfile())) {
                container.onProfileChange();
                continue;
            }
            it.remove();
        }
    }

    public AccessGroup getGroup(String name) {
        return AccessUtility.getGroup(this.getGroups(), name);
    }

    public boolean addGroup(AccessGroup group) {
        if (!this.groups.contains(group) && this.groups.add(group)) {
            this.onProfileUpdate();
            return true;
        }
        return false;
    }

    public AccessGroup getOwnerGroup() {
        return this.getGroup("owner");
    }

    public Set<AccessGroup> getGroups() {
        if (this.groups == null) {
            AccessUtility.loadNewGroupSet(this);
        }
        return this.groups;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        this.profileName = nbt.func_74779_i("name");
        this.global = nbt.func_74767_n("global");
        this.profileID = nbt.func_74779_i("profileID");
        NBTTagList group_list = nbt.func_74761_m("groups");
        if (group_list != null && group_list.func_74745_c() > 0) {
            this.groups.clear();
            for (int i = 0; i < group_list.func_74745_c(); ++i) {
                AccessGroup group = new AccessGroup("", new AccessUser[0]);
                group.load((NBTTagCompound)group_list.func_74743_b(i));
                this.groups.add(group);
            }
            for (AccessGroup group : this.groups) {
                if (group.getExtendGroupName() == null) continue;
                group.setToExtend(this.getGroup(group.getExtendGroupName()));
            }
        }
    }

    @Override
    public void save(NBTTagCompound nbt) {
        nbt.func_74778_a("name", this.profileName);
        nbt.func_74757_a("global", this.global);
        nbt.func_74778_a("profileID", this.profileID);
        NBTTagList groupTags = new NBTTagList();
        for (AccessGroup group : this.getGroups()) {
            NBTTagCompound groupTag = new NBTTagCompound();
            group.save(groupTag);
            groupTags.func_74742_a((NBTBase)groupTag);
        }
        nbt.func_74782_a("groups", (NBTBase)groupTags);
    }

    @Override
    public File getSaveFile() {
        if (this.saveFile == null) {
            this.saveFile = new File(NBTUtility.getSaveDirectory(MinecraftServer.func_71276_C().func_71270_I()), "Access/Profile/" + this.getID() + ".dat");
        }
        return this.saveFile;
    }

    @Override
    public void setSaveFile(File file) {
        this.saveFile = file;
    }

    public String toString() {
        return LanguageUtility.getLocal("info.accessprofile.tostring").replaceAll("%p", this.profileName.toString()).replaceAll("%g", this.groups.toString());
    }

    static {
        SaveManager.registerClass("AccessProfile", AccessProfile.class);
    }
}

